/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class DisassemblyStorage
implements IDisassemblyStorage {
    protected ICDIInstruction[] fInstructions;
    protected IDebugTarget fDebugTarget;
    protected ByteArrayInputStream fInputStream = null;
    protected long fStartAddress = 0L;
    protected long fEndAddress = 0L;
    static /* synthetic */ Class class$org$eclipse$core$resources$IStorage;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IExecFileInfo;

    public DisassemblyStorage(IDebugTarget target, ICDIInstruction[] instructions) {
        this.setDebugTarget(target);
        this.setInstructions(instructions);
        this.initializeAddresses();
        this.createContent();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public boolean containsAddress(long address) {
        return address >= this.fStartAddress && address <= this.fEndAddress;
    }

    public int getLineNumber(long address) {
        int i = 0;
        while (i < this.fInstructions.length) {
            if (this.fInstructions[i].getAdress() == address) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public InputStream getContents() throws CoreException {
        if (this.fInputStream != null) {
            this.fInputStream.reset();
        }
        return this.fInputStream;
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        try {
            if (this.getDebugTarget() != null) {
                return this.getDebugTarget().getName();
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return "disassembly";
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$core$resources$IStorage == null ? (class$org$eclipse$core$resources$IStorage = DisassemblyStorage.class$("org.eclipse.core.resources.IStorage")) : class$org$eclipse$core$resources$IStorage)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage = DisassemblyStorage.class$("org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage")) : class$org$eclipse$cdt$debug$core$sourcelookup$IDisassemblyStorage)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage == null ? (class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage = DisassemblyStorage.class$("org.eclipse.cdt.debug.internal.core.DisassemblyStorage")) : class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = DisassemblyStorage.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) {
            return this.getBinary();
        }
        return null;
    }

    protected void setDebugTarget(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected void setInstructions(ICDIInstruction[] intructions) {
        this.fInstructions = intructions;
    }

    private void createContent() {
        StringBuffer lines = new StringBuffer();
        int maxFunctionName = 0;
        int maxOpcodeLength = 0;
        long maxOffset = 0L;
        int i = 0;
        while (i < this.fInstructions.length) {
            String opcode;
            if (this.fInstructions[i].getFuntionName().length() > maxFunctionName) {
                maxFunctionName = this.fInstructions[i].getFuntionName().length();
            }
            if ((opcode = this.fInstructions[i].getOpcode()).length() > maxOpcodeLength) {
                maxOpcodeLength = opcode.length();
            }
            if (this.fInstructions[i].getOffset() > maxOffset) {
                maxOffset = this.fInstructions[i].getOffset();
            }
            ++i;
        }
        int instrPos = this.calculateInstructionPosition(maxFunctionName, maxOffset);
        int argPosition = instrPos + maxOpcodeLength + 1;
        int i2 = 0;
        while (i2 < this.fInstructions.length) {
            lines.append(this.getInstructionString(this.fInstructions[i2], instrPos, argPosition));
            ++i2;
        }
        this.fInputStream = new ByteArrayInputStream(lines.toString().getBytes());
    }

    private void initializeAddresses() {
        if (this.fInstructions.length > 0) {
            this.fStartAddress = this.fInstructions[0].getAdress();
            this.fEndAddress = this.fInstructions[this.fInstructions.length - 1].getAdress();
        }
    }

    private String getInstructionString(ICDIInstruction instruction, int instrPosition, int argPosition) {
        int worstCaseSpace = Math.max(instrPosition, argPosition);
        char[] spaces = new char[worstCaseSpace];
        Arrays.fill(spaces, ' ');
        StringBuffer sb = new StringBuffer();
        if (instruction != null) {
            sb.append(CDebugUtils.toHexAddressString(instruction.getAdress()));
            sb.append(' ');
            if (instruction.getFuntionName() != null && instruction.getFuntionName().length() > 0) {
                sb.append('<');
                sb.append(instruction.getFuntionName());
                if (instruction.getOffset() != 0L) {
                    sb.append('+');
                    sb.append(instruction.getOffset());
                }
                sb.append(">:");
                sb.append(spaces, 0, instrPosition - sb.length());
            }
            sb.append(instruction.getOpcode());
            sb.append(spaces, 0, argPosition - sb.length());
            sb.append(instruction.getArgs());
            sb.append('\n');
        }
        return sb.toString();
    }

    private int calculateInstructionPosition(int maxFunctionName, long maxOffset) {
        return 16 + maxFunctionName + Long.toString(maxOffset).length();
    }

    private IResource getBinary() {
        IExecFileInfo info;
        if (this.getDebugTarget() != null && (info = (IExecFileInfo)this.getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$core$model$IExecFileInfo == null ? (class$org$eclipse$cdt$debug$core$model$IExecFileInfo = DisassemblyStorage.class$("org.eclipse.cdt.debug.core.model.IExecFileInfo")) : class$org$eclipse$cdt$debug$core$model$IExecFileInfo)) != null) {
            return info.getExecFile();
        }
        return null;
    }

    public long getAddress(int lineNumber) {
        if (this.fInstructions.length > lineNumber && lineNumber >= 0) {
            return this.fInstructions[lineNumber].getAdress();
        }
        return 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

