/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CygwinDebuggerPage
extends AbstractLaunchConfigurationTab {
    protected Text fGDBCommandText;
    protected Text fGDBInitText;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(768));
        this.setControl((Control)comp);
        Composite subComp = new Composite(comp, 0);
        GridLayout gdbLayout = new GridLayout();
        gdbLayout.numColumns = 2;
        gdbLayout.marginHeight = 0;
        gdbLayout.marginWidth = 0;
        subComp.setLayout((Layout)gdbLayout);
        subComp.setLayoutData((Object)new GridData(768));
        Label label = new Label(subComp, 0);
        label.setText("GDB debugger:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = new Text(subComp, 2052);
        gd = new GridData(768);
        this.fGDBCommandText.setLayoutData((Object)gd);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CygwinDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = this.createPushButton(subComp, "&Browse...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                CygwinDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(CygwinDebuggerPage.this.getShell(), 0);
                dialog.setText("GDB Command");
                String gdbCommand = CygwinDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                CygwinDebuggerPage.this.fGDBCommandText.setText(res);
            }
        });
        subComp = new Composite(comp, 0);
        gdbLayout = new GridLayout();
        gdbLayout.numColumns = 2;
        gdbLayout.marginHeight = 0;
        gdbLayout.marginWidth = 0;
        subComp.setLayout((Layout)gdbLayout);
        subComp.setLayoutData((Object)new GridData(768));
        label = new Label(subComp, 0);
        label.setText("GDB command file:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fGDBInitText = new Text(subComp, 2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CygwinDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        button = this.createPushButton(subComp, "&Browse...", null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                CygwinDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(CygwinDebuggerPage.this.getShell(), 0);
                dialog.setText("GDB command file");
                String gdbCommand = CygwinDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                CygwinDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
        label = new Label(comp, 64);
        label.setText("(Warning: Some commands in this file may interfere with the startup operation of the debugger, for example \"run\".)");
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, "");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_AUTO_SOLIB, true);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage("Debugger executable must be specified");
            this.setMessage(null);
        }
        return valid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String gdbCommand = "gdb";
        String gdbInit = "";
        try {
            gdbCommand = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            gdbInit = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, "");
        }
        catch (CoreException e) {
            // empty catch block
        }
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String gdbStr = this.fGDBCommandText.getText();
        gdbStr.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, gdbStr);
        gdbStr = this.fGDBInitText.getText();
        gdbStr.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, gdbStr);
    }

    public String getName() {
        return "Cygwin GDB Debugger Options";
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected Shell getShell() {
        return super.getShell();
    }
}

