/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIAsm {
    long address;
    String function = "";
    String opcode = "";
    String args = "";
    long offset;

    public MIAsm(MITuple tuple) {
        this.parse(tuple);
    }

    public long getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.function;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getInstruction() {
        return this.opcode + " " + this.args;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        buffer.append("address=\"" + Long.toHexString(this.address) + "\"");
        buffer.append(",func-name=\"" + this.function + "\"");
        buffer.append(",offset=\"").append(this.offset).append('\"');
        buffer.append(",inst=\"" + this.getInstruction() + "\"");
        buffer.append('}');
        return buffer.toString();
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("address")) {
                try {
                    this.address = Long.decode(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("func-name")) {
                this.function = str;
            } else if (var.equals("offset")) {
                try {
                    this.offset = Long.decode(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("inst")) {
                str = ((MIConst)value).getString();
                char[] chars = str.toCharArray();
                int index = 0;
                while (index < chars.length && chars[index] > ' ') {
                    ++index;
                }
                this.opcode = str.substring(0, index);
                while (index < chars.length && chars[index] >= '\u0000' && chars[index] <= ' ') {
                    ++index;
                }
                if (index < chars.length) {
                    this.args = str.substring(index);
                }
            }
            ++i;
        }
    }

    public String getArgs() {
        return this.args;
    }

    public String getOpcode() {
        return this.opcode;
    }
}

