/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build.managed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.managed.BuildException;
import org.eclipse.cdt.core.build.managed.IConfiguration;
import org.eclipse.cdt.core.build.managed.IOption;
import org.eclipse.cdt.core.build.managed.ITarget;
import org.eclipse.cdt.internal.core.build.managed.ResourceBuildInfo;
import org.eclipse.cdt.internal.core.build.managed.Target;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManagedBuildManager {
    private static final QualifiedName buildInfoProperty = new QualifiedName("org.eclipse.cdt.core", "buildInfo");
    private static final ITarget[] emptyTargets = new ITarget[0];
    private static boolean extensionTargetsLoaded = false;
    private static List extensionTargets;
    private static Map extensionTargetMap;

    public static ITarget[] getDefinedTargets(IProject project) {
        ManagedBuildManager.loadExtensions();
        List definedTargets = null;
        int size = extensionTargets.size() + (definedTargets != null ? definedTargets.size() : 0);
        ITarget[] targets = new ITarget[size];
        int n = 0;
        int i = 0;
        while (i < extensionTargets.size()) {
            targets[n++] = (ITarget)extensionTargets.get(i);
            ++i;
        }
        if (definedTargets != null) {
            int i2 = 0;
            while (i2 < definedTargets.size()) {
                targets[n++] = (ITarget)definedTargets.get(i2);
                ++i2;
            }
        }
        return targets;
    }

    public static ITarget[] getTargets(IResource resource) {
        ResourceBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(resource);
        if (buildInfo != null) {
            List targets = buildInfo.getTargets();
            return targets.toArray(new ITarget[targets.size()]);
        }
        return emptyTargets;
    }

    public static ITarget getTarget(IResource resource, String id) {
        ResourceBuildInfo buildInfo;
        if (resource != null && (buildInfo = ManagedBuildManager.getBuildInfo(resource)) != null) {
            return buildInfo.getTarget(id);
        }
        ITarget target = (ITarget)extensionTargetMap.get(id);
        if (target != null) {
            return target;
        }
        return null;
    }

    public static ITarget createTarget(IResource resource, ITarget parentTarget) throws BuildException {
        IResource owner = parentTarget.getOwner();
        if (owner != null && owner.equals((Object)resource)) {
            return parentTarget;
        }
        if (resource instanceof IProject) {
            if (owner != null) {
                throw new BuildException("addTarget: owner not null");
            }
        } else {
            if (owner == null) {
                throw new BuildException("addTarget: null owner");
            }
            if (!owner.equals((Object)resource.getProject())) {
                throw new BuildException("addTarget: owner not project");
            }
        }
        return new Target(resource, parentTarget);
    }

    public static void setOption(IConfiguration config, IOption option, String value) {
    }

    public static void setOption(IConfiguration config, IOption option, String[] value) {
    }

    public static void saveBuildInfo(IProject project) {
        DocumentImpl doc = new DocumentImpl();
        Element rootElement = doc.createElement("buildInfo");
        doc.appendChild(rootElement);
        ResourceBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null) {
            buildInfo.serialize((Document)doc, rootElement);
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        String xml = null;
        try {
            Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
            serializer.asDOMSerializer().serialize((Document)doc);
            xml = s.toString("UTF8");
            IFile rscFile = project.getFile(".cdtbuild");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            if (rscFile.exists()) {
                rscFile.setContents((InputStream)inputStream, 1, null);
            } else {
                rscFile.create((InputStream)inputStream, 1, null);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public static void removeBuildInfo(IResource resource) {
        try {
            resource.setSessionProperty(buildInfoProperty, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void addExtensionTarget(Target target) {
        if (extensionTargets == null) {
            extensionTargets = new ArrayList();
            extensionTargetMap = new HashMap();
        }
        extensionTargets.add(target);
        extensionTargetMap.put(target.getId(), target);
    }

    private static void loadExtensions() {
        if (extensionTargetsLoaded) {
            return;
        }
        extensionTargetsLoaded = true;
        IExtensionPoint extensionPoint = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("ManagedBuildInfo");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (element.getName().equals("target")) {
                    new Target(element);
                }
                ++j;
            }
            ++i;
        }
    }

    private static ResourceBuildInfo loadBuildInfo(IProject project) {
        ResourceBuildInfo buildInfo = null;
        IFile file = project.getFile(".cdtbuild");
        if (!file.exists()) {
            return null;
        }
        try {
            InputStream stream = file.getContents();
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(stream);
            Node rootElement = document.getFirstChild();
            if (rootElement.getNodeName().equals("buildInfo")) {
                buildInfo = new ResourceBuildInfo((IResource)project, (Element)rootElement);
                project.setSessionProperty(buildInfoProperty, (Object)buildInfo);
            }
        }
        catch (Exception e) {
            buildInfo = null;
        }
        return buildInfo;
    }

    public static ResourceBuildInfo getBuildInfo(IResource resource, boolean create) {
        ResourceBuildInfo buildInfo = null;
        try {
            buildInfo = (ResourceBuildInfo)resource.getSessionProperty(buildInfoProperty);
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = ManagedBuildManager.loadBuildInfo((IProject)resource);
        }
        if (buildInfo == null && create) {
            try {
                buildInfo = new ResourceBuildInfo();
                resource.setSessionProperty(buildInfoProperty, (Object)buildInfo);
            }
            catch (CoreException e) {
                buildInfo = null;
            }
        }
        return buildInfo;
    }

    public static ResourceBuildInfo getBuildInfo(IResource resource) {
        return ManagedBuildManager.getBuildInfo(resource, false);
    }
}

