/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.core.ICPathEntry;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.cdt.internal.core.CExtensionReference;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.CPathEntry;
import org.eclipse.cdt.internal.core.InternalCExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDescriptor
implements ICDescriptor {
    private ICPathEntry[] fPathEntries = new ICPathEntry[0];
    private COwner fOwner;
    private IProject fProject;
    private HashMap extMap = new HashMap(4);
    private HashMap extInfoMap = new HashMap(4);
    static final String DESCRIPTION_FILE_NAME = ".cdtproject";
    private static final char[][] NO_CHAR_CHAR = new char[0][];
    private static final String PROJECT_DESCRIPTION = "cdtproject";
    private static final String PROJECT_EXTENSION = "extension";
    private static final String PROJECT_EXTENSION_ATTRIBUTE = "attribute";
    private static final String PATH_ENTRY = "cpathentry";
    private boolean fDirty;
    private boolean autoSave;

    protected CDescriptor(IProject project, String id) throws CoreException {
        IPath descriptionPath;
        boolean isDefaultLocation;
        this.fProject = project;
        IPath projectLocation = project.getDescription().getLocation();
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(project);
        }
        if ((descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status;
            String ownerID = this.readCDTProject(descriptionPath);
            if (ownerID.equals(id)) {
                this.fOwner = new COwner(ownerID);
                status = new Status(2, "org.eclipse.cdt.core", 1, "CDTProject already exisits", (Throwable)null);
            } else {
                status = new Status(4, "org.eclipse.cdt.core", 2, "CDTProject already exisits but does not match owner ID of creator", (Throwable)null);
            }
            throw new CoreException((IStatus)status);
        }
        this.fOwner = new COwner(id);
    }

    protected CDescriptor(IProject project) throws CoreException {
        IPath descriptionPath;
        boolean isDefaultLocation;
        this.fProject = project;
        IPath projectLocation = project.getDescription().getLocation();
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(project);
        }
        if (!(descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, "CDTProject file not found", (Throwable)null);
            throw new CoreException((IStatus)status);
        }
        this.fOwner = new COwner(this.readCDTProject(descriptionPath));
    }

    protected CDescriptor(IProject project, COwner owner) throws CoreException {
        IPath descriptionPath;
        boolean isDefaultLocation;
        this.fProject = project;
        IPath projectLocation = project.getDescription().getLocation();
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(project);
        }
        if (!(descriptionPath = projectLocation.append(DESCRIPTION_FILE_NAME)).toFile().exists()) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, "CDTProject file not found", (Throwable)null);
            throw new CoreException((IStatus)status);
        }
        this.readCDTProject(descriptionPath);
        this.fOwner = owner;
        this.setDirty();
    }

    protected COwner getOwner() {
        return this.fOwner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readCDTProject(IPath descriptionPath) throws CoreException {
        FileInputStream file = null;
        try {
            try {
                file = new FileInputStream(descriptionPath.toFile());
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(file);
                Node node = document.getFirstChild();
                if (!node.getNodeName().equals(PROJECT_DESCRIPTION)) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, "Missing cdtproject element", null);
                    throw new CoreException((IStatus)status);
                }
                String string = this.readProjectDescription(node);
                Object var8_10 = null;
                if (file == null) return string;
                try {
                    file.close();
                    return string;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return string;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.cdt.core", -1, e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (file == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            file.close();
            throw throwable;
        }
    }

    private IPath getProjectDefaultLocation(IProject project) {
        return Platform.getLocation().append(project.getFullPath());
    }

    public ICOwnerInfo getProjectOwner() {
        return this.fOwner;
    }

    public String getPlatform() {
        return this.fOwner.getPlatform();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public ICExtensionReference[] get(String extensionID) {
        ICExtensionReference[] refs = (CExtensionReference[])this.extMap.get(extensionID);
        if (refs == null) {
            return new ICExtensionReference[0];
        }
        return refs;
    }

    public ICExtensionReference[] get(String extensionID, boolean update) {
        ICExtensionReference[] ext = this.get(extensionID);
        if (ext.length == 0 && update) {
            try {
                this.fOwner.update(this.fProject, this, extensionID);
                this.saveInfo();
                ext = this.get(extensionID);
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return ext;
    }

    public ICExtensionReference create(String extensionPoint, String extensionID) throws CoreException {
        CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(extensionPoint);
        if (extensions == null) {
            extensions = new CExtensionReference[1];
            this.extMap.put(extensionPoint, extensions);
        } else {
            CExtensionReference[] newExtensions = new CExtensionReference[extensions.length + 1];
            System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
            extensions = newExtensions;
            this.extMap.put(extensionPoint, extensions);
        }
        extensions[extensions.length - 1] = new CExtensionReference(this, extensionPoint, extensionID);
        this.setDirty();
        return extensions[extensions.length - 1];
    }

    public void remove(ICExtensionReference ext) throws CoreException {
        CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(ext.getExtension());
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i] == ext) {
                System.arraycopy(extensions, i, extensions, i + 1, extensions.length - 1 - i);
                CExtensionReference[] newExtensions = new CExtensionReference[extensions.length - 1];
                System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
                extensions = newExtensions;
                if (extensions.length == 0) {
                    this.extMap.put(ext.getExtension(), null);
                } else {
                    this.extMap.put(ext.getExtension(), extensions);
                }
                this.setDirty();
            }
            ++i;
        }
    }

    public void remove(String extensionPoint) throws CoreException {
        CExtensionReference[] extensions = (CExtensionReference[])this.extMap.get(extensionPoint);
        if (extensions != null) {
            this.extMap.remove(extensionPoint);
            this.setDirty();
        }
    }

    public CExtensionInfo getInfo(CExtensionReference cProjectExtension) {
        CExtensionInfo info = (CExtensionInfo)this.extInfoMap.get(cProjectExtension);
        if (info == null) {
            info = new CExtensionInfo();
            this.extInfoMap.put(cProjectExtension, info);
        }
        return info;
    }

    protected void saveInfo() throws CoreException {
        String xml;
        if (!this.isDirty()) {
            return;
        }
        try {
            xml = this.getAsXML();
        }
        catch (IOException e) {
            Status s = new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        IFile rscFile = this.getProject().getFile(DESCRIPTION_FILE_NAME);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        if (rscFile.exists()) {
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
        this.fDirty = false;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    protected void setDirty() throws CoreException {
        this.fDirty = true;
        if (this.isAutoSave()) {
            this.saveInfo();
        }
    }

    protected boolean isDirty() {
        return this.fDirty;
    }

    protected String serializeDocument(Document doc) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
        serializer.asDOMSerializer().serialize(doc);
        return s.toString("UTF8");
    }

    private String readProjectDescription(Node node) throws CoreException {
        ArrayList<ICPathEntry> pathEntries = new ArrayList<ICPathEntry>();
        String ownerID = node.getAttributes().getNamedItem("id").getNodeValue();
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() == 1) {
                ICPathEntry entry;
                if (childNode.getNodeName().equals(PROJECT_EXTENSION)) {
                    this.decodeProjectExtension((Element)childNode);
                } else if (childNode.getNodeName().equals(PATH_ENTRY) && (entry = this.decodePathEntry((Element)childNode)) != null) {
                    pathEntries.add(entry);
                }
            }
            ++i;
        }
        this.fPathEntries = pathEntries.toArray(new ICPathEntry[0]);
        return ownerID;
    }

    private void decodeProjectExtension(Element element) throws CoreException {
        ICExtensionReference ext = this.create(element.getAttribute("point"), element.getAttribute("id"));
        NodeList extAttrib = element.getChildNodes();
        int j = 0;
        while (j < extAttrib.getLength()) {
            if (extAttrib.item(j).getNodeName().equals(PROJECT_EXTENSION_ATTRIBUTE)) {
                NamedNodeMap attrib = extAttrib.item(j).getAttributes();
                ext.setExtensionData(attrib.getNamedItem("key").getNodeValue(), attrib.getNamedItem("value").getNodeValue());
            }
            ++j;
        }
    }

    private ICPathEntry decodePathEntry(Element element) throws CoreException {
        char[][] patterns;
        int patternCount;
        IPath projectPath = this.fProject.getProject().getFullPath();
        String kindAttr = element.getAttribute("kind");
        String pathAttr = element.getAttribute("path");
        Path path = new Path(pathAttr);
        int kind = CPathEntry.kindFromString(kindAttr);
        if (kind != 4 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path sourceAttachmentPath = element.hasAttribute("sourcepath") ? new Path(element.getAttribute("sourcepath")) : null;
        Path sourceAttachmentRootPath = element.hasAttribute("rootpath") ? new Path(element.getAttribute("rootpath")) : null;
        Path sourceAttachmentPrefixMapping = element.hasAttribute("prefixmapping") ? new Path(element.getAttribute("prefixmapping")) : null;
        String exclusion = element.getAttribute("excluding");
        IPath[] exclusionPatterns = CPathEntry.NO_EXCLUSION_PATTERNS;
        if (!exclusion.equals("") && (patternCount = (patterns = this.splitOn('|', exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        switch (kind) {
            case 2: {
                return CCorePlugin.newProjectEntry((IPath)path);
            }
            case 1: {
                return CCorePlugin.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IPath)sourceAttachmentPrefixMapping);
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(this.fProject.getName())) {
                    return CCorePlugin.newSourceEntry((IPath)path, exclusionPatterns);
                }
                return CCorePlugin.newProjectEntry((IPath)path);
            }
            case 4: {
                return CCorePlugin.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath);
            }
            case 5: {
                return CCorePlugin.newIncludeEntry((IPath)path, exclusionPatterns);
            }
        }
        Status status = new Status(4, "org.eclipse.cdt.core", -1, "CPathEntry: unknown kind (" + kindAttr + ")", (Throwable)null);
        throw new CoreException((IStatus)status);
    }

    private char[][] splitOn(char divider, char[] array) {
        int length;
        int n = length = array == null ? 0 : array.length;
        if (length == 0) {
            return NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = 0;
        while (i < length) {
            if (array[i] == divider) {
                ++wordCount;
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        int i2 = 0;
        while (i2 < length) {
            if (array[i2] == divider) {
                split[currentWord] = new char[i2 - last];
                System.arraycopy(array, last, split[currentWord++], 0, i2 - last);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = new char[length - last];
        System.arraycopy(array, last, split[currentWord], 0, length - last);
        return split;
    }

    protected String getAsXML() throws IOException {
        DocumentImpl doc = new DocumentImpl();
        Element configRootElement = doc.createElement(PROJECT_DESCRIPTION);
        doc.appendChild(configRootElement);
        configRootElement.setAttribute("id", this.fOwner.getID());
        this.encodeProjectExtensions((Document)doc, configRootElement);
        this.encodePathEntries((Document)doc, configRootElement);
        return this.serializeDocument((Document)doc);
    }

    private void encodeProjectExtensions(Document doc, Element configRootElement) {
        Iterator extIterator = this.extMap.values().iterator();
        while (extIterator.hasNext()) {
            CExtensionReference[] extension = (CExtensionReference[])extIterator.next();
            int i = 0;
            while (i < extension.length) {
                Element element = doc.createElement(PROJECT_EXTENSION);
                configRootElement.appendChild(element);
                element.setAttribute("point", extension[i].getExtension());
                element.setAttribute("id", extension[i].getID());
                CExtensionInfo info = (CExtensionInfo)this.extInfoMap.get(extension[i]);
                if (info != null) {
                    Iterator attribIterator = info.getAttributes().entrySet().iterator();
                    while (attribIterator.hasNext()) {
                        Map.Entry entry = attribIterator.next();
                        Element extAttributes = doc.createElement(PROJECT_EXTENSION_ATTRIBUTE);
                        extAttributes.setAttribute("key", (String)entry.getKey());
                        extAttributes.setAttribute("value", (String)entry.getValue());
                        element.appendChild(extAttributes);
                    }
                }
                ++i;
            }
        }
    }

    private void encodePathEntries(Document doc, Element configRootElement) {
        IPath projectPath = this.fProject.getProject().getFullPath();
        int i = 0;
        while (i < this.fPathEntries.length) {
            IPath[] exclusionPatterns;
            Element element = doc.createElement(PATH_ENTRY);
            configRootElement.appendChild(element);
            element.setAttribute("kind", CPathEntry.kindToString(this.fPathEntries[i].getEntryKind()));
            IPath xmlPath = this.fPathEntries[i].getPath();
            if (this.fPathEntries[i].getEntryKind() != 4 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
                if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                    xmlPath = xmlPath.removeFirstSegments(1);
                    xmlPath = xmlPath.makeRelative();
                } else {
                    xmlPath = xmlPath.makeAbsolute();
                }
            }
            element.setAttribute("path", xmlPath.toString());
            if (this.fPathEntries[i].getSourceAttachmentPath() != null) {
                element.setAttribute("sourcepath", this.fPathEntries[i].getSourceAttachmentPath().toString());
            }
            if (this.fPathEntries[i].getSourceAttachmentRootPath() != null) {
                element.setAttribute("rootpath", this.fPathEntries[i].getSourceAttachmentRootPath().toString());
            }
            if (this.fPathEntries[i].getSourceAttachmentPrefixMapping() != null) {
                element.setAttribute("prefixmapping", this.fPathEntries[i].getSourceAttachmentPrefixMapping().toString());
            }
            if ((exclusionPatterns = this.fPathEntries[i].getExclusionPatterns()).length > 0) {
                StringBuffer excludeRule = new StringBuffer(10);
                int j = 0;
                int max = exclusionPatterns.length;
                while (j < max) {
                    if (j > 0) {
                        excludeRule.append('|');
                    }
                    excludeRule.append(exclusionPatterns[j]);
                    ++j;
                }
                element.setAttribute("excluding", excludeRule.toString());
            }
            ++i;
        }
    }

    public void setPathEntries(ICPathEntry[] entries) throws CoreException {
        this.fPathEntries = entries;
        this.setDirty();
    }

    public ICPathEntry[] getPathEntries() {
        return this.fPathEntries;
    }

    protected ICExtension createExtensions(ICExtensionReference ext) throws CoreException {
        InternalCExtension cExtension = null;
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(ext.getExtension());
        IExtension extension = extensionPoint.getExtension(ext.getID());
        IConfigurationElement[] element = extension.getConfigurationElements();
        int i = 0;
        while (i < element.length) {
            if (element[i].getName().equalsIgnoreCase("cextension")) {
                cExtension = (InternalCExtension)element[i].createExecutableExtension("run");
                cExtension.setExtenionReference(ext);
                cExtension.setProject(this.fProject);
                break;
            }
            ++i;
        }
        return (ICExtension)((Object)cExtension);
    }
}

