/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.build.managed.BuildException;
import org.eclipse.cdt.core.build.managed.IConfiguration;
import org.eclipse.cdt.core.build.managed.IOption;
import org.eclipse.cdt.core.build.managed.ITarget;
import org.eclipse.cdt.core.build.managed.ITool;
import org.eclipse.cdt.internal.core.build.managed.BuildObject;
import org.eclipse.cdt.internal.core.build.managed.OptionReference;
import org.eclipse.cdt.internal.core.build.managed.Target;
import org.eclipse.cdt.internal.core.build.managed.ToolReference;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Configuration
extends BuildObject
implements IConfiguration {
    private ITarget target;
    private IConfiguration parent;
    private List toolReferences;

    public Configuration(Target target, String id) {
        this.id = id;
        this.target = target;
        target.addConfiguration(this);
    }

    public Configuration(Target target, IConfiguration parent, String id) {
        this.id = id;
        this.target = target;
        this.parent = parent;
        target.addConfiguration(this);
    }

    public Configuration(Target target, IConfigurationElement element) {
        this.target = target;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        this.setName(element.getAttribute("name"));
        IConfigurationElement[] configElements = element.getChildren();
        int l = 0;
        while (l < configElements.length) {
            IConfigurationElement configElement = configElements[l];
            if (configElement.getName().equals("toolRef")) {
                new ToolReference(this, configElement);
            }
            ++l;
        }
    }

    public Configuration(Target target, Element element) {
        this.target = target;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("parent")) {
            this.parent = target.getParent().getConfiguration(element.getAttribute("parent"));
        }
    }

    public void serealize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        if (this.toolReferences != null) {
            int i = 0;
            while (i < this.toolReferences.size()) {
                ToolReference toolRef = (ToolReference)this.toolReferences.get(i);
                Element toolRefElement = doc.createElement("toolRef");
                toolRef.serealize(doc, toolRefElement);
                ++i;
            }
        }
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITool[] getTools() {
        ITool[] tools = this.parent != null ? this.parent.getTools() : this.target.getTools();
        int i = 0;
        while (i < tools.length) {
            ToolReference ref = this.getToolReference(tools[i]);
            if (ref != null) {
                tools[i] = ref;
            }
            ++i;
        }
        return tools;
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public ITarget getTarget() {
        return this.target == null && this.parent != null ? this.parent.getTarget() : this.target;
    }

    public IResource getOwner() {
        return this.getTarget().getOwner();
    }

    private ToolReference getToolReference(ITool tool) {
        if (this.toolReferences != null) {
            int i = 0;
            while (i < this.toolReferences.size()) {
                ToolReference toolRef = (ToolReference)this.toolReferences.get(i);
                if (toolRef.references(tool)) {
                    return toolRef;
                }
                ++i;
            }
        }
        return null;
    }

    public void addToolReference(ToolReference toolRef) {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
        }
        this.toolReferences.add(toolRef);
    }

    public OptionReference createOptionReference(IOption option) {
        if (option instanceof OptionReference) {
            OptionReference optionRef = (OptionReference)option;
            ToolReference toolRef = optionRef.getToolReference();
            if (toolRef.getConfiguration().equals(this)) {
                return optionRef;
            }
            toolRef = new ToolReference(this, toolRef);
            return toolRef.createOptionReference(option);
        }
        ToolReference toolRef = this.getToolReference(option.getTool());
        if (toolRef == null) {
            toolRef = new ToolReference(this, option.getTool());
        }
        return toolRef.createOptionReference(option);
    }

    public void setOption(IOption option, String value) throws BuildException {
        this.createOptionReference(option).setValue(value);
    }

    public void setOption(IOption option, String[] value) throws BuildException {
        this.createOptionReference(option).setValue(value);
    }
}

