/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build.managed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.managed.IConfiguration;
import org.eclipse.cdt.core.build.managed.IOption;
import org.eclipse.cdt.core.build.managed.IOptionCategory;
import org.eclipse.cdt.core.build.managed.ITarget;
import org.eclipse.cdt.core.build.managed.ITool;
import org.eclipse.cdt.internal.core.build.managed.BuildObject;
import org.eclipse.cdt.internal.core.build.managed.Option;
import org.eclipse.cdt.internal.core.build.managed.OptionCategory;
import org.eclipse.cdt.internal.core.build.managed.Target;
import org.eclipse.cdt.internal.core.build.managed.ToolReference;
import org.eclipse.core.runtime.IConfigurationElement;

public class Tool
extends BuildObject
implements ITool,
IOptionCategory {
    private ITarget target;
    private List options;
    private Map optionMap;
    private List childOptionCategories;
    private Map categoryMap;
    private static IOption[] emptyOptions = new IOption[0];
    private static IOptionCategory[] emptyCategories = new IOptionCategory[0];

    public Tool(Target target) {
        this.target = target;
    }

    public Tool(Target target, IConfigurationElement element) {
        this(target);
        this.setId(element.getAttribute("id"));
        target.addTool(this);
        this.setName(element.getAttribute("name"));
        this.categoryMap = new HashMap();
        this.addOptionCategory(this);
        IConfigurationElement[] toolElements = element.getChildren();
        int l = 0;
        while (l < toolElements.length) {
            IConfigurationElement toolElement = toolElements[l];
            if (toolElement.getName().equals("option")) {
                new Option(this, toolElement);
            } else if (toolElement.getName().equals("optionCategory")) {
                new OptionCategory(this, toolElement);
            }
            ++l;
        }
    }

    public ITarget getTarget() {
        return this.target;
    }

    public IOptionCategory getOptionCategory(String id) {
        return (IOptionCategory)this.categoryMap.get(id);
    }

    void addOptionCategory(IOptionCategory category) {
        this.categoryMap.put(category.getId(), category);
    }

    void addChildCategory(IOptionCategory category) {
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(category);
    }

    public IOption[] getOptions() {
        if (this.options != null) {
            return this.options.toArray(new IOption[this.options.size()]);
        }
        return emptyOptions;
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new ArrayList();
            this.optionMap = new HashMap();
        }
        this.options.add(option);
        this.optionMap.put(option.getId(), option);
    }

    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.childOptionCategories != null) {
            return this.childOptionCategories.toArray(new IOptionCategory[this.childOptionCategories.size()]);
        }
        return emptyCategories;
    }

    public IOptionCategory createChildCategory() {
        OptionCategory category = new OptionCategory(this);
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(category);
        return category;
    }

    public IOptionCategory getOwner() {
        return null;
    }

    public ITool getTool() {
        return this;
    }

    public IOption[] getOptions(IConfiguration configuration) {
        ITool tool = this;
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            int i = 0;
            while (i < tools.length) {
                if (tools[i] instanceof ToolReference) {
                    if (((ToolReference)tools[i]).references(tool)) {
                        tool = tools[i];
                        break;
                    }
                } else if (tools[i].equals(tool)) break;
                ++i;
            }
        }
        IOption[] allOptions = tool.getOptions();
        ArrayList<IOption> myOptions = new ArrayList<IOption>();
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            if (option.getCategory().equals(this)) {
                myOptions.add(option);
            }
            ++i;
        }
        return myOptions.toArray(new IOption[myOptions.size()]);
    }

    public IOption getOption(String id) {
        return (IOption)this.optionMap.get(id);
    }
}

