/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.internal.core.dom.AccessSpecifier;
import org.eclipse.cdt.internal.core.dom.BaseSpecifier;
import org.eclipse.cdt.internal.core.dom.ClassKey;
import org.eclipse.cdt.internal.core.dom.Declaration;
import org.eclipse.cdt.internal.core.dom.IAccessable;
import org.eclipse.cdt.internal.core.dom.IOffsetable;
import org.eclipse.cdt.internal.core.dom.IScope;
import org.eclipse.cdt.internal.core.dom.Name;
import org.eclipse.cdt.internal.core.dom.TypeSpecifier;
import org.eclipse.cdt.internal.core.parser.Token;

public class ClassSpecifier
extends TypeSpecifier
implements IScope,
IOffsetable,
IAccessable {
    private AccessSpecifier access = new AccessSpecifier(0);
    private ClassKey key = new ClassKey();
    private int startingOffset = 0;
    private int totalLength = 0;
    private int topLine = 0;
    private int bottomLine = 0;
    private Token classKeyToken = null;
    private Name name;
    private List baseSpecifiers = new LinkedList();
    private List declarations = new LinkedList();

    public int getClassKey() {
        return this.key.getClassKey();
    }

    public ClassSpecifier(int classKey, TypeSpecifier.IOwner declaration) {
        super(declaration);
        this.key.setClassKey(classKey);
    }

    public void setName(Name n) {
        this.name = n;
    }

    public Name getName() {
        return this.name;
    }

    public void addBaseSpecifier(BaseSpecifier baseSpecifier) {
        this.baseSpecifiers.add(baseSpecifier);
    }

    public List getBaseSpecifiers() {
        return Collections.unmodifiableList(this.baseSpecifiers);
    }

    public void addDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public List getDeclarations() {
        return Collections.unmodifiableList(this.declarations);
    }

    public int getVisibility() {
        return this.access.getAccess();
    }

    public void setVisibility(int currentVisiblity) {
        this.access.setAccess(currentVisiblity);
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setStartingOffset(int i) {
        this.startingOffset = i;
    }

    public void setTotalLength(int i) {
        this.totalLength = i;
    }

    public Token getClassKeyToken() {
        return this.classKeyToken;
    }

    public void setClassKeyToken(Token classKeyToken) {
        this.classKeyToken = classKeyToken;
    }

    public void setTopLine(int lineNumber) {
        this.topLine = lineNumber;
    }

    public void setBottomLine(int lineNumber) {
        this.bottomLine = lineNumber;
    }

    public int getTopLine() {
        return this.topLine;
    }

    public int getBottomLine() {
        return this.bottomLine;
    }
}

