/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import org.eclipse.cdt.internal.core.dom.ASMDefinition;
import org.eclipse.cdt.internal.core.dom.AccessSpecifier;
import org.eclipse.cdt.internal.core.dom.ArrayQualifier;
import org.eclipse.cdt.internal.core.dom.BaseSpecifier;
import org.eclipse.cdt.internal.core.dom.ClassSpecifier;
import org.eclipse.cdt.internal.core.dom.ConstructorChain;
import org.eclipse.cdt.internal.core.dom.ConstructorChainElement;
import org.eclipse.cdt.internal.core.dom.ConstructorChainElementExpression;
import org.eclipse.cdt.internal.core.dom.DeclSpecifier;
import org.eclipse.cdt.internal.core.dom.Declarator;
import org.eclipse.cdt.internal.core.dom.ElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.EnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.EnumeratorDefinition;
import org.eclipse.cdt.internal.core.dom.ExplicitTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.Expression;
import org.eclipse.cdt.internal.core.dom.IAccessable;
import org.eclipse.cdt.internal.core.dom.IDeclaratorOwner;
import org.eclipse.cdt.internal.core.dom.IExpressionOwner;
import org.eclipse.cdt.internal.core.dom.IOffsetable;
import org.eclipse.cdt.internal.core.dom.IScope;
import org.eclipse.cdt.internal.core.dom.ITemplateParameterListOwner;
import org.eclipse.cdt.internal.core.dom.Inclusion;
import org.eclipse.cdt.internal.core.dom.LinkageSpecification;
import org.eclipse.cdt.internal.core.dom.Macro;
import org.eclipse.cdt.internal.core.dom.Name;
import org.eclipse.cdt.internal.core.dom.NamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.ParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.ParameterDeclarationClause;
import org.eclipse.cdt.internal.core.dom.PointerOperator;
import org.eclipse.cdt.internal.core.dom.SimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.TemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.TemplateParameter;
import org.eclipse.cdt.internal.core.dom.TemplateParameterList;
import org.eclipse.cdt.internal.core.dom.TranslationUnit;
import org.eclipse.cdt.internal.core.dom.TypeSpecifier;
import org.eclipse.cdt.internal.core.dom.UsingDeclaration;
import org.eclipse.cdt.internal.core.dom.UsingDirective;
import org.eclipse.cdt.internal.core.parser.IParser;
import org.eclipse.cdt.internal.core.parser.IParserCallback;
import org.eclipse.cdt.internal.core.parser.Token;

public class DOMBuilder
implements IParserCallback {
    protected Name currName;
    protected IParser parser = null;
    protected TranslationUnit translationUnit;

    protected DOMBuilder() {
    }

    public TranslationUnit getTranslationUnit() {
        return this.translationUnit;
    }

    public Object argumentsBegin(Object declarator) {
        Declarator decl = (Declarator)declarator;
        ParameterDeclarationClause clause = new ParameterDeclarationClause(decl);
        return clause;
    }

    public void argumentsEnd(Object parameterDeclarationClause) {
    }

    public Object classSpecifierBegin(Object container, Token classKey) {
        TypeSpecifier.IOwner decl = (TypeSpecifier.IOwner)container;
        int kind = 1;
        int visibility = 2;
        switch (classKey.getType()) {
            case 65: {
                kind = 0;
                visibility = 0;
                break;
            }
            case 109: {
                kind = 1;
                break;
            }
            case 119: {
                kind = 2;
            }
        }
        ClassSpecifier classSpecifier = new ClassSpecifier(kind, decl);
        classSpecifier.setVisibility(visibility);
        classSpecifier.setStartingOffset(classKey.getOffset());
        classSpecifier.setClassKeyToken(classKey);
        decl.setTypeSpecifier(classSpecifier);
        return classSpecifier;
    }

    public void classSpecifierName(Object classSpecifier) {
        ((ClassSpecifier)classSpecifier).setName(this.currName);
    }

    public void classSpecifierEnd(Object classSpecifier, Token closingBrace) {
        ClassSpecifier c = (ClassSpecifier)classSpecifier;
        c.setTotalLength(closingBrace.getOffset() + closingBrace.getLength() - c.getStartingOffset());
    }

    public Object declaratorBegin(Object container) {
        if (container instanceof DeclSpecifier.IContainer) {
            DeclSpecifier.IContainer decl = (DeclSpecifier.IContainer)container;
            Declarator declarator = new Declarator(decl);
            return declarator;
        }
        if (container instanceof IDeclaratorOwner) {
            IDeclaratorOwner owner = (IDeclaratorOwner)container;
            Declarator declarator = new Declarator(owner);
            return declarator;
        }
        return null;
    }

    public void declaratorEnd(Object declarator) {
        Declarator d = (Declarator)declarator;
        if (d.getDeclaration() != null) {
            d.getDeclaration().addDeclarator(d);
        } else if (d.getOwnerDeclarator() != null) {
            d.getOwnerDeclarator().setDeclarator(d);
        }
    }

    public void declaratorId(Object declarator) {
        ((Declarator)declarator).setName(this.currName);
    }

    public void simpleDeclSpecifier(Object Container, Token specifier) {
        DeclSpecifier.IContainer decl = (DeclSpecifier.IContainer)Container;
        DeclSpecifier declSpec = decl.getDeclSpecifier();
        declSpec.setType(specifier);
    }

    public void expressionOperator(Object expression, Token operator) {
        Expression e = (Expression)expression;
        e.add(operator);
    }

    public void expressionTerminal(Object expression, Token terminal) {
        Expression e = (Expression)expression;
        e.add(terminal);
    }

    public Object functionBodyBegin(Object declaration) {
        SimpleDeclaration simpleDec = (SimpleDeclaration)declaration;
        simpleDec.setFunctionDefinition(true);
        return null;
    }

    public void functionBodyEnd(Object functionBody) {
    }

    public Object inclusionBegin(String includeFile, int offset, int inclusionBeginOffset) {
        Inclusion inclusion = new Inclusion(includeFile, offset, inclusionBeginOffset, offset - inclusionBeginOffset + includeFile.length() + 1);
        this.translationUnit.addInclusion(inclusion);
        return inclusion;
    }

    public void inclusionEnd(Object inclusion) {
    }

    public Object macro(String macroName, int offset, int macroBeginOffset, int macroEndOffset) {
        Macro macro = new Macro(macroName, offset, macroBeginOffset, macroEndOffset - macroBeginOffset);
        this.translationUnit.addMacro(macro);
        return macro;
    }

    public Object simpleDeclarationBegin(Object container, Token firstToken) {
        SimpleDeclaration decl = new SimpleDeclaration((IScope)container);
        if (container instanceof IAccessable) {
            decl.setAccessSpecifier(new AccessSpecifier(((IAccessable)container).getVisibility()));
        }
        decl.setStartingOffset(firstToken.getOffset());
        return decl;
    }

    public void simpleDeclarationEnd(Object declaration, Token lastToken) {
        SimpleDeclaration decl;
        SimpleDeclaration offsetable = decl = (SimpleDeclaration)declaration;
        offsetable.setTotalLength(lastToken.getOffset() + lastToken.getLength() - offsetable.getStartingOffset());
        decl.getOwnerScope().addDeclaration(decl);
    }

    public Object translationUnitBegin() {
        this.translationUnit = new TranslationUnit();
        return this.translationUnit;
    }

    public void translationUnitEnd(Object unit) {
    }

    public void nameBegin(Token firstToken) {
        this.currName = new Name(firstToken);
    }

    public void nameEnd(Token lastToken) {
        this.currName.setEnd(lastToken);
    }

    public Object baseSpecifierBegin(Object classSpecifier) {
        ClassSpecifier cs = (ClassSpecifier)classSpecifier;
        BaseSpecifier baseSpec = new BaseSpecifier(cs);
        return baseSpec;
    }

    public void baseSpecifierEnd(Object baseSpecifier) {
    }

    public void baseSpecifierVirtual(Object baseSpecifier, boolean virtual) {
        BaseSpecifier bs = (BaseSpecifier)baseSpecifier;
        bs.setVirtual(virtual);
    }

    public void baseSpecifierVisibility(Object baseSpecifier, Token visibility) {
        int access = 2;
        switch (visibility.type) {
            case 100: {
                access = 2;
                break;
            }
            case 99: {
                access = 1;
                break;
            }
            case 98: {
                access = 0;
                break;
            }
        }
        ((BaseSpecifier)baseSpecifier).setAccess(access);
    }

    public void baseSpecifierName(Object baseSpecifier) {
        ((BaseSpecifier)baseSpecifier).setName(this.currName);
    }

    public Object parameterDeclarationBegin(Object container) {
        IScope clause = (IScope)container;
        ParameterDeclaration pd = new ParameterDeclaration(clause);
        return pd;
    }

    public void parameterDeclarationEnd(Object declaration) {
        ParameterDeclaration d = (ParameterDeclaration)declaration;
        d.getOwnerScope().addDeclaration(d);
    }

    public void declaratorAbort(Object declarator) {
        this.currName = null;
    }

    public Object expressionBegin(Object container) {
        IExpressionOwner owner = (IExpressionOwner)container;
        Expression expression = new Expression();
        owner.setExpression(expression);
        return expression;
    }

    public void expressionEnd(Object expression) {
    }

    public void classSpecifierAbort(Object classSpecifier) {
        ClassSpecifier cs = (ClassSpecifier)classSpecifier;
        cs.getOwner().setTypeSpecifier(null);
    }

    public Object elaboratedTypeSpecifierBegin(Object container, Token classKey) {
        int kind = 1;
        switch (classKey.getType()) {
            case 65: {
                kind = 0;
                break;
            }
            case 109: {
                kind = 1;
                break;
            }
            case 119: {
                kind = 2;
                break;
            }
            case 77: {
                kind = 3;
            }
        }
        ElaboratedTypeSpecifier elab = null;
        TypeSpecifier.IOwner declaration = (TypeSpecifier.IOwner)container;
        elab = new ElaboratedTypeSpecifier(kind, declaration);
        declaration.setTypeSpecifier(elab);
        return elab;
    }

    public void elaboratedTypeSpecifierEnd(Object elab) {
    }

    public void elaboratedTypeSpecifierName(Object elab) {
        ((ElaboratedTypeSpecifier)elab).setName(this.currName);
    }

    public void simpleDeclSpecifierName(Object declaration) {
        DeclSpecifier.IContainer decl = (DeclSpecifier.IContainer)declaration;
        DeclSpecifier declSpec = decl.getDeclSpecifier();
        declSpec.setName(this.currName);
    }

    public void expressionAbort(Object expression) {
    }

    public void classMemberVisibility(Object classSpecifier, Token visibility) {
        ClassSpecifier spec = (ClassSpecifier)classSpecifier;
        switch (visibility.getType()) {
            case 100: {
                spec.setVisibility(2);
                break;
            }
            case 99: {
                spec.setVisibility(1);
                break;
            }
            case 98: {
                spec.setVisibility(0);
            }
        }
    }

    public Object pointerOperatorBegin(Object container) {
        Declarator declarator = (Declarator)container;
        PointerOperator ptrOp = new PointerOperator(declarator);
        return ptrOp;
    }

    public void pointerOperatorEnd(Object ptrOperator) {
        PointerOperator ptrOp = (PointerOperator)ptrOperator;
        Declarator owner = ptrOp.getOwnerDeclarator();
        owner.addPointerOperator(ptrOp);
    }

    public void pointerOperatorName(Object ptrOperator) {
    }

    public void pointerOperatorType(Object ptrOperator, Token type) {
        PointerOperator ptrOp = (PointerOperator)ptrOperator;
        switch (type.getType()) {
            case 23: {
                ptrOp.setType(1);
                break;
            }
            case 30: {
                ptrOp.setType(2);
                break;
            }
        }
    }

    public void pointerOperatorCVModifier(Object ptrOperator, Token modifier) {
        PointerOperator ptrOp = (PointerOperator)ptrOperator;
        switch (modifier.getType()) {
            case 67: {
                ptrOp.setConst(true);
                break;
            }
            case 124: {
                ptrOp.setVolatile(true);
                break;
            }
        }
    }

    public void declaratorCVModifier(Object declarator, Token modifier) {
        Declarator decl = (Declarator)declarator;
        switch (modifier.getType()) {
            case 67: {
                decl.setConst(true);
                break;
            }
            case 124: {
                decl.setVolatile(true);
                break;
            }
        }
    }

    public Object arrayDeclaratorBegin(Object declarator) {
        Declarator decl = (Declarator)declarator;
        ArrayQualifier qual = new ArrayQualifier(decl);
        return qual;
    }

    public void arrayDeclaratorEnd(Object arrayQualifier) {
        ArrayQualifier qual = (ArrayQualifier)arrayQualifier;
        Declarator parent = qual.getOwnerDeclarator();
        parent.addArrayQualifier(qual);
    }

    public void declaratorThrowExceptionName(Object declarator) {
        Declarator decl = (Declarator)declarator;
        decl.getExceptionSpecifier().addTypeName(this.currName);
    }

    public void declaratorThrowsException(Object declarator) {
        Declarator decl = (Declarator)declarator;
        decl.getExceptionSpecifier().setThrowsException(true);
    }

    public Object namespaceDefinitionBegin(Object container, Token namespace) {
        IScope ownerScope = (IScope)container;
        NamespaceDefinition namespaceDef = new NamespaceDefinition(ownerScope);
        namespaceDef.setStartToken(namespace);
        namespaceDef.setStartingOffset(namespace.getOffset());
        return namespaceDef;
    }

    public void namespaceDefinitionId(Object namespace) {
        NamespaceDefinition ns = (NamespaceDefinition)namespace;
        ns.setName(this.currName);
    }

    public void namespaceDefinitionAbort(Object namespace) {
    }

    public void namespaceDefinitionEnd(Object namespace, Token closingBrace) {
        NamespaceDefinition ns = (NamespaceDefinition)namespace;
        ns.setTotalLength(closingBrace.getOffset() + closingBrace.getLength() - ns.getStartingOffset());
        ns.getOwnerScope().addDeclaration(ns);
    }

    public Object linkageSpecificationBegin(Object container, String literal) {
        IScope scope = (IScope)container;
        LinkageSpecification linkage = new LinkageSpecification(scope, literal);
        return linkage;
    }

    public void linkageSpecificationEnd(Object linkageSpec) {
        LinkageSpecification linkage = (LinkageSpecification)linkageSpec;
        linkage.getOwnerScope().addDeclaration(linkage);
    }

    public Object usingDirectiveBegin(Object container) {
        IScope scope = (IScope)container;
        UsingDirective directive = new UsingDirective(scope);
        return directive;
    }

    public void usingDirectiveNamespaceId(Object dir) {
        UsingDirective directive = (UsingDirective)dir;
        directive.setNamespaceName(this.currName);
    }

    public void usingDirectiveEnd(Object dir) {
        UsingDirective directive = (UsingDirective)dir;
        directive.getOwnerScope().addDeclaration(directive);
    }

    public Object usingDeclarationBegin(Object container) {
        IScope scope = (IScope)container;
        UsingDeclaration declaration = new UsingDeclaration(scope);
        return declaration;
    }

    public void usingDeclarationMapping(Object decl, boolean isTypename) {
        UsingDeclaration declaration = (UsingDeclaration)decl;
        declaration.setMappedName(this.currName);
        declaration.setTypename(isTypename);
    }

    public void usingDeclarationEnd(Object decl) {
        UsingDeclaration declaration = (UsingDeclaration)decl;
        declaration.getOwnerScope().addDeclaration(declaration);
    }

    public void usingDirectiveAbort(Object directive) {
    }

    public void usingDeclarationAbort(Object declaration) {
    }

    public Object enumSpecifierBegin(Object container, Token enumKey) {
        TypeSpecifier.IOwner decl = (TypeSpecifier.IOwner)container;
        EnumerationSpecifier es = new EnumerationSpecifier(decl);
        es.setStartToken(enumKey);
        decl.setTypeSpecifier(es);
        es.setStartingOffset(enumKey.getOffset());
        return es;
    }

    public void enumSpecifierId(Object enumSpec) {
        EnumerationSpecifier es = (EnumerationSpecifier)enumSpec;
        es.setName(this.currName);
    }

    public void enumSpecifierAbort(Object enumSpec) {
        EnumerationSpecifier es = (EnumerationSpecifier)enumSpec;
        es.getOwner().setTypeSpecifier(null);
    }

    public void enumSpecifierEnd(Object enumSpec, Token closingBrace) {
        IOffsetable offsetable = (IOffsetable)enumSpec;
        offsetable.setTotalLength(closingBrace.getOffset() + closingBrace.getLength() - offsetable.getStartingOffset());
    }

    public Object enumeratorBegin(Object enumSpec) {
        EnumerationSpecifier es = (EnumerationSpecifier)enumSpec;
        EnumeratorDefinition definition = new EnumeratorDefinition();
        es.addEnumeratorDefinition(definition);
        return definition;
    }

    public void enumeratorId(Object enumDefn) {
        EnumeratorDefinition definition = (EnumeratorDefinition)enumDefn;
        definition.setName(this.currName);
        ((IOffsetable)enumDefn).setStartingOffset(this.currName.getStartOffset());
    }

    public void enumeratorEnd(Object enumDefn, Token lastToken) {
        IOffsetable offsetable = (IOffsetable)enumDefn;
        offsetable.setTotalLength(lastToken.getOffset() + lastToken.getLength() - offsetable.getStartingOffset());
    }

    public void asmDefinition(Object container, String assemblyCode) {
        IScope scope = (IScope)container;
        ASMDefinition definition = new ASMDefinition(scope, assemblyCode);
        scope.addDeclaration(definition);
    }

    public Object constructorChainBegin(Object declarator) {
        Declarator d = (Declarator)declarator;
        ConstructorChain chain = new ConstructorChain(d);
        return chain;
    }

    public void constructorChainAbort(Object ctor) {
        ctor = null;
    }

    public void constructorChainEnd(Object ctor) {
        ConstructorChain chain = (ConstructorChain)ctor;
        chain.getOwnerDeclarator().setCtorChain(chain);
    }

    public Object constructorChainElementBegin(Object ctor) {
        return new ConstructorChainElement((ConstructorChain)ctor);
    }

    public void constructorChainElementEnd(Object element) {
        ConstructorChainElement ele = (ConstructorChainElement)element;
        ele.getOwnerChain().addChainElement(ele);
    }

    public void constructorChainElementId(Object element) {
        ConstructorChainElement ele = (ConstructorChainElement)element;
        ele.setName(this.currName);
    }

    public Object constructorChainElementExpressionListElementBegin(Object element) {
        return new ConstructorChainElementExpression((ConstructorChainElement)element);
    }

    public void constructorChainElementExpressionListElementEnd(Object expression) {
        ConstructorChainElementExpression exp = (ConstructorChainElementExpression)expression;
        exp.getOwnerElement().addExpression(exp);
    }

    public Object explicitInstantiationBegin(Object container) {
        IScope scope = (IScope)container;
        ExplicitTemplateDeclaration etd = new ExplicitTemplateDeclaration(scope, 2);
        return etd;
    }

    public void explicitInstantiationEnd(Object instantiation) {
        ExplicitTemplateDeclaration declaration = (ExplicitTemplateDeclaration)instantiation;
        declaration.getOwnerScope().addDeclaration(declaration);
    }

    public Object explicitSpecializationBegin(Object container) {
        IScope scope = (IScope)container;
        ExplicitTemplateDeclaration etd = new ExplicitTemplateDeclaration(scope, 1);
        return etd;
    }

    public void explicitSpecializationEnd(Object instantiation) {
        ExplicitTemplateDeclaration etd = (ExplicitTemplateDeclaration)instantiation;
        etd.getOwnerScope().addDeclaration(etd);
    }

    public void declaratorPureVirtual(Object declarator) {
        Declarator d = (Declarator)declarator;
        d.setPureVirtual(true);
    }

    public Object templateDeclarationBegin(Object container, Token exported) {
        TemplateDeclaration d = new TemplateDeclaration((IScope)container, exported);
        if (container instanceof IAccessable) {
            d.setVisibility(((IAccessable)container).getVisibility());
        }
        return d;
    }

    public void templateDeclarationAbort(Object templateDecl) {
        templateDecl = null;
    }

    public void templateDeclarationEnd(Object templateDecl, Token lastToken) {
        TemplateDeclaration decl = (TemplateDeclaration)templateDecl;
        decl.setLastToken(lastToken);
        decl.getOwnerScope().addDeclaration(decl);
    }

    public Object templateTypeParameterBegin(Object templDecl, Token kind) {
        int k;
        TemplateParameterList list = (TemplateParameterList)templDecl;
        switch (kind.getType()) {
            case 65: {
                k = 2;
                break;
            }
            case 118: {
                k = 3;
                break;
            }
            case 111: {
                k = 4;
                break;
            }
            default: {
                k = 0;
            }
        }
        TemplateParameter p = new TemplateParameter(list, k);
        return p;
    }

    public void templateTypeParameterName(Object typeParm) {
        ((TemplateParameter)typeParm).setName(this.currName);
    }

    public void templateTypeParameterInitialTypeId(Object typeParm) {
        ((TemplateParameter)typeParm).setTypeId(this.currName);
    }

    public void templateTypeParameterEnd(Object typeParm) {
        TemplateParameter parameter = (TemplateParameter)typeParm;
        parameter.getOwnerScope().addDeclaration(parameter);
    }

    public void templateTypeParameterAbort(Object typeParm) {
        typeParm = null;
    }

    public void pointerOperatorAbort(Object ptrOperator) {
        ptrOperator = null;
    }

    public Object templateParameterListBegin(Object declaration) {
        ITemplateParameterListOwner d = (ITemplateParameterListOwner)declaration;
        TemplateParameterList list = new TemplateParameterList();
        d.setTemplateParms(list);
        return list;
    }

    public void templateParameterListEnd(Object parameterList) {
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }
}

