/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import org.eclipse.cdt.internal.core.dom.DOMBuilder;
import org.eclipse.cdt.internal.core.dom.IOffsetable;
import org.eclipse.cdt.internal.core.parser.Token;

public class LineNumberedDOMBuilder
extends DOMBuilder {
    protected LineNumberedDOMBuilder() {
    }

    protected void setLineNumber(IOffsetable element, int offset, boolean topLine) {
        try {
            if (topLine) {
                element.setTopLine(this.parser.getLineNumberForOffset(offset));
            } else {
                element.setBottomLine(this.parser.getLineNumberForOffset(offset));
            }
        }
        catch (NoSuchMethodException nsm) {
            System.out.println("Incorrect parser setup to get line numbers");
        }
    }

    public Object classSpecifierBegin(Object container, Token classKey) {
        Object returnValue = super.classSpecifierBegin(container, classKey);
        this.setLineNumber((IOffsetable)returnValue, classKey.getOffset(), true);
        return returnValue;
    }

    public void classSpecifierEnd(Object classSpecifier, Token closingBrace) {
        super.classSpecifierEnd(classSpecifier, closingBrace);
        this.setLineNumber((IOffsetable)classSpecifier, closingBrace.getOffset() + closingBrace.getLength(), false);
    }

    public void enumeratorEnd(Object enumDefn, Token lastToken) {
        super.enumeratorEnd(enumDefn, lastToken);
        this.setLineNumber((IOffsetable)enumDefn, lastToken.getOffset() + lastToken.getLength(), false);
    }

    public void enumeratorId(Object enumDefn) {
        super.enumeratorId(enumDefn);
        this.setLineNumber((IOffsetable)enumDefn, this.currName.getStartOffset(), true);
    }

    public Object enumSpecifierBegin(Object container, Token enumKey) {
        Object returnValue = super.enumSpecifierBegin(container, enumKey);
        this.setLineNumber((IOffsetable)returnValue, enumKey.getOffset(), true);
        return returnValue;
    }

    public void enumSpecifierEnd(Object enumSpec, Token closingBrace) {
        super.enumSpecifierEnd(enumSpec, closingBrace);
        this.setLineNumber((IOffsetable)enumSpec, closingBrace.getOffset() + closingBrace.getLength(), false);
    }

    public Object inclusionBegin(String includeFile, int offset, int inclusionBeginOffset) {
        Object inclusion = super.inclusionBegin(includeFile, offset, inclusionBeginOffset);
        this.setLineNumber((IOffsetable)inclusion, inclusionBeginOffset, true);
        this.setLineNumber((IOffsetable)inclusion, offset + includeFile.length() + 1, false);
        return inclusion;
    }

    public Object macro(String macroName, int offset, int macroBeginOffset, int macroEndOffset) {
        Object macro = super.macro(macroName, offset, macroBeginOffset, macroEndOffset);
        this.setLineNumber((IOffsetable)macro, macroBeginOffset, true);
        this.setLineNumber((IOffsetable)macro, macroEndOffset, false);
        return macro;
    }

    public Object namespaceDefinitionBegin(Object container, Token namespace) {
        Object namespaceDef = super.namespaceDefinitionBegin(container, namespace);
        this.setLineNumber((IOffsetable)namespaceDef, namespace.getOffset(), true);
        return namespaceDef;
    }

    public void namespaceDefinitionEnd(Object namespace, Token closingBrace) {
        super.namespaceDefinitionEnd(namespace, closingBrace);
        this.setLineNumber((IOffsetable)namespace, closingBrace.getOffset() + closingBrace.getLength(), false);
    }

    public Object simpleDeclarationBegin(Object container, Token firstToken) {
        Object retval = super.simpleDeclarationBegin(container, firstToken);
        this.setLineNumber((IOffsetable)retval, firstToken.getOffset(), true);
        return retval;
    }

    public void simpleDeclarationEnd(Object declaration, Token lastToken) {
        super.simpleDeclarationEnd(declaration, lastToken);
        this.setLineNumber((IOffsetable)declaration, lastToken.getOffset() + lastToken.getLength(), false);
    }

    public Object templateDeclarationBegin(Object container, Token exported) {
        Object template = super.templateDeclarationBegin(container, exported);
        this.setLineNumber((IOffsetable)template, exported.getOffset(), true);
        return template;
    }

    public void templateDeclarationEnd(Object templateDecl, Token lastToken) {
        super.templateDeclarationEnd(templateDecl, lastToken);
        this.setLineNumber((IOffsetable)templateDecl, lastToken.getOffset() + lastToken.getLength(), false);
    }
}

