/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.core.dom.AccessSpecifier;
import org.eclipse.cdt.internal.core.dom.Declaration;
import org.eclipse.cdt.internal.core.dom.IAccessable;
import org.eclipse.cdt.internal.core.dom.IOffsetable;
import org.eclipse.cdt.internal.core.dom.IScope;
import org.eclipse.cdt.internal.core.dom.ITemplateParameterListOwner;
import org.eclipse.cdt.internal.core.dom.TemplateParameterList;
import org.eclipse.cdt.internal.core.parser.Token;

public class TemplateDeclaration
extends Declaration
implements IScope,
IAccessable,
ITemplateParameterListOwner,
IOffsetable {
    private final boolean exported;
    private AccessSpecifier visibility = null;
    private Token firstToken;
    private Token lastToken;
    private List declarations = new ArrayList();
    private TemplateParameterList templateParms = null;
    private int topLine = 0;
    private int bottomLine = 0;

    public TemplateDeclaration(IScope ownerScope, Token exported) {
        super(ownerScope);
        this.firstToken = exported;
        this.exported = exported.getType() == 79;
    }

    public void addDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public List getDeclarations() {
        return Collections.unmodifiableList(this.declarations);
    }

    public boolean isExported() {
        return this.exported;
    }

    public TemplateParameterList getTemplateParms() {
        return this.templateParms;
    }

    public void setTemplateParms(TemplateParameterList list) {
        this.templateParms = list;
    }

    public Token getFirstToken() {
        return this.firstToken;
    }

    public Token getLastToken() {
        return this.lastToken;
    }

    public void setFirstToken(Token token) {
        this.firstToken = token;
    }

    public void setLastToken(Token token) {
        this.lastToken = token;
    }

    public int getStartingOffset() {
        return this.getFirstToken().getOffset();
    }

    public int getTotalLength() {
        return this.getLastToken().getOffset() + this.getLastToken().getLength() - this.getStartingOffset();
    }

    public void setStartingOffset(int i) {
        throw new Error("Offset should not be set");
    }

    public void setTotalLength(int i) {
        throw new Error("Offset should not be set");
    }

    public int getVisibility() {
        if (this.visibility == null) {
            return 3;
        }
        return this.visibility.getAccess();
    }

    public void setVisibility(int visibility) {
        if (this.visibility == null) {
            this.visibility = new AccessSpecifier(visibility);
        } else {
            this.visibility.setAccess(visibility);
        }
    }

    public void setTopLine(int lineNumber) {
        this.topLine = lineNumber;
    }

    public void setBottomLine(int lineNumber) {
        this.bottomLine = lineNumber;
    }

    public int getTopLine() {
        return this.topLine;
    }

    public int getBottomLine() {
        return this.bottomLine;
    }
}

