/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.internal.core.dom.Declaration;
import org.eclipse.cdt.internal.core.dom.IOffsetable;
import org.eclipse.cdt.internal.core.dom.IScope;
import org.eclipse.cdt.internal.core.dom.Inclusion;
import org.eclipse.cdt.internal.core.dom.Macro;

public class TranslationUnit
implements IScope {
    private boolean parseSuccessful = true;
    private List declarations = new ArrayList();
    private List macros = new ArrayList();
    private List inclusions = new ArrayList();

    public void addDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public List getDeclarations() {
        return Collections.unmodifiableList(this.declarations);
    }

    public List getInclusions() {
        return Collections.unmodifiableList(this.inclusions);
    }

    public List getMacros() {
        return Collections.unmodifiableList(this.macros);
    }

    public void addMacro(Macro macro) {
        this.macros.add(macro);
    }

    public void addInclusion(Inclusion inclusion) {
        this.inclusions.add(inclusion);
    }

    public Iterator iterateOffsetableElements() {
        return new OffsetableIterator();
    }

    public boolean isParseSuccessful() {
        return this.parseSuccessful;
    }

    public void setParseSuccessful(boolean b) {
        this.parseSuccessful = b;
    }

    public class OffsetableIterator
    implements Iterator {
        private final Iterator declarationIter;
        private final Iterator inclusionIter;
        private final Iterator macroIter;
        private IOffsetable currentMacro = null;
        private IOffsetable currentInclusion = null;
        private IOffsetable currentDeclaration = null;

        public OffsetableIterator() {
            this.declarationIter = TranslationUnit.this.getDeclarations().iterator();
            this.inclusionIter = TranslationUnit.this.getInclusions().iterator();
            this.macroIter = TranslationUnit.this.getMacros().iterator();
            this.updateInclusionIterator();
            this.updateDeclarationIterator();
            this.updateMacroIterator();
        }

        private Object updateDeclarationIterator() {
            IOffsetable offsetable = this.currentDeclaration;
            this.currentDeclaration = this.declarationIter.hasNext() ? (IOffsetable)this.declarationIter.next() : null;
            return offsetable;
        }

        private Object updateMacroIterator() {
            IOffsetable offsetable = this.currentMacro;
            this.currentMacro = this.macroIter.hasNext() ? (IOffsetable)this.macroIter.next() : null;
            return offsetable;
        }

        private Object updateInclusionIterator() {
            IOffsetable offsetable = this.currentInclusion;
            this.currentInclusion = this.inclusionIter.hasNext() ? (IOffsetable)this.inclusionIter.next() : null;
            return offsetable;
        }

        public boolean hasNext() {
            return this.currentMacro != null || this.currentInclusion != null || this.currentDeclaration != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentMacro == null && this.currentInclusion == null) {
                return this.updateDeclarationIterator();
            }
            if (this.currentDeclaration == null && this.currentInclusion == null) {
                return this.updateMacroIterator();
            }
            if (this.currentMacro == null && this.currentDeclaration == null) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentInclusion.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateInclusionIterator();
            }
            if (this.currentInclusion == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentDeclaration == null) {
                if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateInclusionIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset() && this.currentInclusion.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro.getStartingOffset() < this.currentInclusion.getStartingOffset() && this.currentMacro.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateMacroIterator();
            }
            return this.updateDeclarationIterator();
        }

        public void remove() {
            throw new UnsupportedOperationException("OffsetableIterator is a const iterator");
        }
    }
}

