/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.ArrayQualifier;
import org.eclipse.cdt.internal.core.dom.ClassSpecifier;
import org.eclipse.cdt.internal.core.dom.DOMBuilder;
import org.eclipse.cdt.internal.core.dom.DOMFactory;
import org.eclipse.cdt.internal.core.dom.DeclSpecifier;
import org.eclipse.cdt.internal.core.dom.Declaration;
import org.eclipse.cdt.internal.core.dom.Declarator;
import org.eclipse.cdt.internal.core.dom.ElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.EnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.EnumeratorDefinition;
import org.eclipse.cdt.internal.core.dom.IOffsetable;
import org.eclipse.cdt.internal.core.dom.ITemplateParameterListOwner;
import org.eclipse.cdt.internal.core.dom.Inclusion;
import org.eclipse.cdt.internal.core.dom.Name;
import org.eclipse.cdt.internal.core.dom.NamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.ParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.ParameterDeclarationClause;
import org.eclipse.cdt.internal.core.dom.PointerOperator;
import org.eclipse.cdt.internal.core.dom.SimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.TemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.TemplateParameter;
import org.eclipse.cdt.internal.core.dom.TypeSpecifier;
import org.eclipse.cdt.internal.core.model.ClassTemplate;
import org.eclipse.cdt.internal.core.model.Enumeration;
import org.eclipse.cdt.internal.core.model.Enumerator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.Namespace;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TypeDef;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.parser.IParserCallback;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.core.resources.IProject;

public class CModelBuilder {
    protected TranslationUnit translationUnit;
    protected Map newElements;

    public CModelBuilder(TranslationUnit tu) {
        this.translationUnit = tu;
        this.newElements = new HashMap();
    }

    public Map parse(boolean requiresLineNumbers) throws Exception {
        DOMBuilder domBuilder = DOMFactory.createDOMBuilder(requiresLineNumbers);
        String code = this.translationUnit.getBuffer().getContents();
        Parser parser = new Parser(code, (IParserCallback)domBuilder, true);
        parser.mapLineNumbers(requiresLineNumbers);
        if (this.translationUnit.getCProject() != null) {
            IProject currentProject = this.translationUnit.getCProject().getProject();
            boolean hasCppNature = CoreModel.getDefault().hasCCNature(currentProject);
            parser.setCppNature(hasCppNature);
        }
        try {
            parser.parse();
        }
        catch (Exception e) {
            System.out.println("Parse Exception in Outline View");
            e.printStackTrace();
        }
        long startTime = System.currentTimeMillis();
        try {
            this.generateModelElements(domBuilder.getTranslationUnit());
        }
        catch (NullPointerException npe) {
            System.out.println("NullPointer exception generating CModel");
            npe.printStackTrace();
        }
        System.out.println("CModel build: " + (System.currentTimeMillis() - startTime) + "ms");
        return this.newElements;
    }

    protected void generateModelElements(org.eclipse.cdt.internal.core.dom.TranslationUnit tu) {
        Iterator i = tu.iterateOffsetableElements();
        while (i.hasNext()) {
            IOffsetable offsetable = (IOffsetable)i.next();
            if (offsetable instanceof Inclusion) {
                this.createInclusion(this.translationUnit, (Inclusion)offsetable);
                continue;
            }
            if (offsetable instanceof org.eclipse.cdt.internal.core.dom.Macro) {
                this.createMacro(this.translationUnit, (org.eclipse.cdt.internal.core.dom.Macro)offsetable);
                continue;
            }
            if (!(offsetable instanceof Declaration)) continue;
            this.generateModelElements(this.translationUnit, (Declaration)((Object)offsetable));
        }
    }

    protected void generateModelElements(Parent parent, Declaration declaration) {
        if (declaration instanceof NamespaceDefinition) {
            NamespaceDefinition nsDef = (NamespaceDefinition)declaration;
            Namespace namespace = this.createNamespace(parent, nsDef);
            List nsDeclarations = nsDef.getDeclarations();
            Iterator nsDecls = nsDeclarations.iterator();
            while (nsDecls.hasNext()) {
                Declaration subNsDeclaration = (Declaration)nsDecls.next();
                this.generateModelElements(namespace, subNsDeclaration);
            }
        }
        if (declaration instanceof SimpleDeclaration) {
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)declaration;
            TypeSpecifier typeSpec = simpleDeclaration.getTypeSpecifier();
            if (typeSpec instanceof EnumerationSpecifier) {
                EnumerationSpecifier enumSpecifier = (EnumerationSpecifier)typeSpec;
                Enumeration enumElement = this.createEnumeration(parent, enumSpecifier);
            } else if (typeSpec instanceof ClassSpecifier) {
                ClassSpecifier classSpecifier = (ClassSpecifier)typeSpec;
                Structure classElement = this.createClass(parent, simpleDeclaration, classSpecifier, false);
                List declarations = classSpecifier.getDeclarations();
                Iterator j = declarations.iterator();
                while (j.hasNext()) {
                    Declaration subDeclaration = (Declaration)j.next();
                    this.generateModelElements(classElement, subDeclaration);
                }
            }
            List declarators = simpleDeclaration.getDeclarators();
            Iterator d = declarators.iterator();
            while (d.hasNext()) {
                Declarator declarator = (Declarator)d.next();
                this.createElement(parent, simpleDeclaration, declarator);
            }
        }
        if (declaration instanceof TemplateDeclaration) {
            TemplateDeclaration templateDeclaration = (TemplateDeclaration)declaration;
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)templateDeclaration.getDeclarations().get(0);
            TypeSpecifier typeSpec = simpleDeclaration.getTypeSpecifier();
            if (typeSpec instanceof ClassSpecifier) {
                ClassSpecifier classSpecifier = (ClassSpecifier)typeSpec;
                ClassTemplate classTemplate = (ClassTemplate)this.createClass(parent, simpleDeclaration, classSpecifier, true);
                String[] parameterTypes = this.getTemplateParameters(templateDeclaration);
                classTemplate.setTemplateParameterTypes(parameterTypes);
                List declarations = classSpecifier.getDeclarations();
                Iterator j = declarations.iterator();
                while (j.hasNext()) {
                    Declaration subDeclaration = (Declaration)j.next();
                    this.generateModelElements(classTemplate, subDeclaration);
                }
            }
            List declarators = simpleDeclaration.getDeclarators();
            Iterator d = declarators.iterator();
            while (d.hasNext()) {
                Declarator declarator = (Declarator)d.next();
                this.createTemplateElement(parent, templateDeclaration, simpleDeclaration, declarator);
            }
        }
    }

    protected void createElement(Parent parent, SimpleDeclaration simpleDeclaration, Declarator declarator) {
        if (simpleDeclaration.getDeclSpecifier().isTypedef()) {
            this.createTypeDef(parent, declarator, simpleDeclaration);
        } else {
            ParameterDeclarationClause pdc = declarator.getParms();
            if (pdc == null) {
                this.createVariableSpecification(parent, simpleDeclaration, declarator);
            } else if (declarator.getDeclarator() != null) {
                this.createPointerToFunction(parent, simpleDeclaration, declarator, pdc, false);
            } else {
                this.createFunctionSpecification(parent, simpleDeclaration, declarator, pdc, false);
            }
        }
    }

    protected void createTemplateElement(Parent parent, TemplateDeclaration templateDeclaration, SimpleDeclaration simpleDeclaration, Declarator declarator) {
        ParameterDeclarationClause pdc = declarator.getParms();
        if (pdc != null) {
            ITemplate template = (ITemplate)((Object)this.createFunctionSpecification(parent, simpleDeclaration, declarator, pdc, true));
            String[] parameterTypes = this.getTemplateParameters(templateDeclaration);
            template.setTemplateParameterTypes(parameterTypes);
        }
    }

    protected Include createInclusion(Parent parent, Inclusion inclusion) {
        Include element = new Include(parent, inclusion.getName());
        parent.addChild(element);
        element.setIdPos(inclusion.getNameOffset(), inclusion.getNameLength());
        element.setPos(inclusion.getStartingOffset(), inclusion.getTotalLength());
        element.setLines(inclusion.getTopLine(), inclusion.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected Macro createMacro(Parent parent, org.eclipse.cdt.internal.core.dom.Macro macro) {
        Macro element = new Macro(parent, macro.getName());
        parent.addChild(element);
        element.setIdPos(macro.getNameOffset(), macro.getNameLength());
        element.setPos(macro.getStartingOffset(), macro.getTotalLength());
        element.setLines(macro.getTopLine(), macro.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected Namespace createNamespace(Parent parent, NamespaceDefinition nsDef) {
        String nsName = nsDef.getName() == null ? "" : nsDef.getName().toString();
        Namespace element = new Namespace(parent, nsName);
        parent.addChild(element);
        if (nsDef.getName() != null) {
            element.setIdPos(nsDef.getName().getStartOffset(), nsDef.getName().length());
        } else {
            element.setIdPos(nsDef.getStartToken().getOffset(), nsDef.getStartToken().getLength());
        }
        element.setPos(nsDef.getStartingOffset(), nsDef.getTotalLength());
        element.setTypeName(nsDef.getStartToken().getImage());
        element.setLines(nsDef.getTopLine(), nsDef.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected Enumeration createEnumeration(Parent parent, EnumerationSpecifier enumSpecifier) {
        String enumName = enumSpecifier.getName() == null ? "" : enumSpecifier.getName().toString();
        Enumeration element = new Enumeration(parent, enumName);
        parent.addChild(element);
        List enumItems = enumSpecifier.getEnumeratorDefinitions();
        Iterator i = enumItems.iterator();
        while (i.hasNext()) {
            EnumeratorDefinition enumDef = (EnumeratorDefinition)i.next();
            this.createEnumerator(element, enumDef);
        }
        if (enumSpecifier.getName() != null) {
            element.setIdPos(enumSpecifier.getName().getStartOffset(), enumSpecifier.getName().length());
        } else {
            element.setIdPos(enumSpecifier.getStartToken().getOffset(), enumSpecifier.getStartToken().getLength());
        }
        element.setPos(enumSpecifier.getStartingOffset(), enumSpecifier.getTotalLength());
        element.setTypeName(enumSpecifier.getStartToken().getImage());
        element.setLines(enumSpecifier.getTopLine(), enumSpecifier.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected Enumerator createEnumerator(Parent parent, EnumeratorDefinition enumDef) {
        Enumerator element = new Enumerator(parent, enumDef.getName().toString());
        parent.addChild(element);
        element.setIdPos(enumDef.getName().getStartOffset(), enumDef.getName().length());
        element.setPos(enumDef.getStartingOffset(), enumDef.getTotalLength());
        element.setLines(enumDef.getTopLine(), enumDef.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected Structure createClass(Parent parent, SimpleDeclaration simpleDeclaration, ClassSpecifier classSpecifier, boolean isTemplate) {
        String type;
        Structure element;
        int kind;
        String className = classSpecifier.getName() == null ? "" : classSpecifier.getName().toString();
        switch (classSpecifier.getClassKey()) {
            case 0: {
                kind = 64;
                break;
            }
            case 1: {
                kind = 65;
                break;
            }
            default: {
                kind = 66;
            }
        }
        if (!isTemplate) {
            Structure classElement;
            element = classElement = new Structure((ICElement)parent, kind, className);
        } else {
            ClassTemplate classTemplate = new ClassTemplate(parent, className);
            element = classTemplate;
        }
        parent.addChild(element);
        if (classSpecifier.getName() != null) {
            type = simpleDeclaration.getDeclSpecifier().getTypeName();
            element.setIdPos(classSpecifier.getName().getStartOffset(), classSpecifier.getName().length());
        } else {
            type = classSpecifier.getClassKeyToken().getImage();
            element.setIdPos(classSpecifier.getClassKeyToken().getOffset(), classSpecifier.getClassKeyToken().getLength());
        }
        element.setTypeName(type);
        element.setPos(classSpecifier.getStartingOffset(), classSpecifier.getTotalLength());
        element.setLines(classSpecifier.getTopLine(), classSpecifier.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected TypeDef createTypeDef(Parent parent, Declarator declarator, SimpleDeclaration simpleDeclaration) {
        Name domName = declarator.getDeclarator() != null ? declarator.getDeclarator().getName() : declarator.getName();
        String declaratorName = domName.toString();
        TypeDef element = new TypeDef(parent, declaratorName);
        String type = this.getType(simpleDeclaration, declarator);
        element.setTypeName(type);
        parent.addChild(element);
        element.setIdPos(domName.getStartOffset(), domName.length());
        element.setPos(simpleDeclaration.getStartingOffset(), simpleDeclaration.getTotalLength());
        element.setLines(simpleDeclaration.getTopLine(), simpleDeclaration.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected VariableDeclaration createVariableSpecification(Parent parent, SimpleDeclaration simpleDeclaration, Declarator declarator) {
        Name domName = declarator.getDeclarator() != null ? declarator.getDeclarator().getName() : declarator.getName();
        String variableName = domName.toString();
        DeclSpecifier declSpecifier = simpleDeclaration.getDeclSpecifier();
        VariableDeclaration element = null;
        if (parent instanceof IStructure) {
            Field newElement = new Field(parent, variableName);
            newElement.setMutable(declSpecifier.isMutable());
            newElement.setVisibility(simpleDeclaration.getAccessSpecifier().getAccess());
            element = newElement;
        } else if (declSpecifier.isExtern()) {
            VariableDeclaration newElement;
            element = newElement = new VariableDeclaration(parent, variableName);
        } else {
            Variable newElement = new Variable(parent, variableName);
            element = newElement;
        }
        element.setTypeName(this.getType(simpleDeclaration, declarator));
        element.setConst(declSpecifier.isConst());
        element.setVolatile(declSpecifier.isVolatile());
        element.setStatic(declSpecifier.isStatic());
        parent.addChild(element);
        element.setIdPos(domName.getStartOffset(), domName.length());
        element.setPos(simpleDeclaration.getStartingOffset(), simpleDeclaration.getTotalLength());
        element.setLines(simpleDeclaration.getTopLine(), simpleDeclaration.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected FunctionDeclaration createFunctionSpecification(Parent parent, SimpleDeclaration simpleDeclaration, Declarator declarator, ParameterDeclarationClause pdc, boolean isTemplate) {
        FunctionDeclaration newElement;
        Name domName = declarator.getDeclarator() != null ? declarator.getDeclarator().getName() : declarator.getName();
        String declaratorName = domName.toString();
        DeclSpecifier declSpecifier = simpleDeclaration.getDeclSpecifier();
        List parameterList = pdc.getDeclarations();
        String[] parameterTypes = new String[parameterList.size()];
        FunctionDeclaration element = null;
        int j = 0;
        while (j < parameterList.size()) {
            ParameterDeclaration param = (ParameterDeclaration)parameterList.get(j);
            parameterTypes[j] = new String(this.getType(param, (Declarator)param.getDeclarators().get(0)));
            ++j;
        }
        if (parent instanceof IStructure) {
            if (simpleDeclaration.isFunctionDefinition()) {
                if (!isTemplate) {
                    newElement = new Method(parent, declaratorName);
                    newElement.setVisibility(simpleDeclaration.getAccessSpecifier().getAccess());
                    element = newElement;
                } else {
                    newElement = new MethodTemplate(parent, declaratorName);
                    newElement.setVisibility(simpleDeclaration.getAccessSpecifier().getAccess());
                    element = newElement;
                }
            } else if (!isTemplate) {
                newElement = new MethodDeclaration(parent, declaratorName);
                newElement.setVisibility(simpleDeclaration.getAccessSpecifier().getAccess());
                element = newElement;
            } else {
                newElement = new MethodTemplate(parent, declaratorName);
                newElement.setVisibility(simpleDeclaration.getAccessSpecifier().getAccess());
                element = newElement;
            }
        } else if (parent instanceof ITranslationUnit || parent instanceof INamespace) {
            if (simpleDeclaration.isFunctionDefinition()) {
                if (!isTemplate) {
                    newElement = new Function(parent, declaratorName);
                    element = newElement;
                } else {
                    newElement = new FunctionTemplate(parent, declaratorName);
                    element = newElement;
                }
            } else if (!isTemplate) {
                newElement = new FunctionDeclaration(parent, declaratorName);
                element = newElement;
            } else {
                newElement = new FunctionTemplate(parent, declaratorName);
                element = newElement;
            }
        }
        element.setParameterTypes(parameterTypes);
        element.setReturnType(this.getType(simpleDeclaration, declarator));
        element.setVolatile(declSpecifier.isVolatile());
        element.setStatic(declSpecifier.isStatic());
        element.setConst(declarator.isConst());
        parent.addChild(element);
        element.setIdPos(domName.getStartOffset(), domName.length());
        element.setPos(simpleDeclaration.getStartingOffset(), simpleDeclaration.getTotalLength());
        element.setLines(simpleDeclaration.getTopLine(), simpleDeclaration.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    protected VariableDeclaration createPointerToFunction(Parent parent, SimpleDeclaration simpleDeclaration, Declarator declarator, ParameterDeclarationClause pdc, boolean isTemplate) {
        String declaratorName = declarator.getDeclarator().getName().toString();
        DeclSpecifier declSpecifier = simpleDeclaration.getDeclSpecifier();
        List parameterList = pdc.getDeclarations();
        String[] parameterTypes = new String[parameterList.size()];
        VariableDeclaration element = null;
        int j = 0;
        while (j < parameterList.size()) {
            ParameterDeclaration param = (ParameterDeclaration)parameterList.get(j);
            parameterTypes[j] = new String(this.getType(param, (Declarator)param.getDeclarators().get(0)));
            ++j;
        }
        if (parent instanceof ITranslationUnit || parent instanceof INamespace) {
            element = new VariableDeclaration(parent, declaratorName);
        } else if (parent instanceof IStructure) {
            Field newElement = new Field(parent, declaratorName);
            newElement.setVisibility(simpleDeclaration.getAccessSpecifier().getAccess());
            element = newElement;
        }
        StringBuffer typeName = new StringBuffer();
        typeName.append(this.getType(simpleDeclaration, declarator));
        if (parameterTypes.length > 0) {
            typeName.append("(");
            int i = 0;
            typeName.append(parameterTypes[i++]);
            while (i < parameterTypes.length) {
                typeName.append(", ");
                typeName.append(parameterTypes[i++]);
            }
            typeName.append(")");
        } else {
            typeName.append("()");
        }
        element.setTypeName(typeName.toString());
        element.setVolatile(declSpecifier.isVolatile());
        element.setStatic(declSpecifier.isStatic());
        element.setConst(declarator.isConst());
        parent.addChild(element);
        element.setIdPos(declarator.getDeclarator().getName().getStartOffset(), declarator.getDeclarator().getName().length());
        element.setPos(simpleDeclaration.getStartingOffset(), simpleDeclaration.getTotalLength());
        element.setLines(simpleDeclaration.getTopLine(), simpleDeclaration.getBottomLine());
        this.newElements.put(element, element.getElementInfo());
        return element;
    }

    private String[] getTemplateParameters(ITemplateParameterListOwner templateDeclaration) {
        List templateParameters = templateDeclaration.getTemplateParms().getDeclarations();
        Iterator i = templateParameters.iterator();
        String[] parameterTypes = new String[templateParameters.size()];
        int j = 0;
        while (j < templateParameters.size()) {
            Declaration parameter;
            StringBuffer paramType = new StringBuffer();
            Declaration decl = (Declaration)templateParameters.get(j);
            if (decl instanceof TemplateParameter) {
                parameter = (TemplateParameter)decl;
                if (((TemplateParameter)parameter).getName() != null) {
                    paramType.append(((TemplateParameter)parameter).getName().toString());
                } else {
                    int kind = ((TemplateParameter)parameter).getKind();
                    switch (kind) {
                        case 2: {
                            paramType.append("class");
                            break;
                        }
                        case 3: {
                            paramType.append("typename");
                            break;
                        }
                        case 4: {
                            paramType.append("template<");
                            String[] subParams = this.getTemplateParameters((ITemplateParameterListOwner)((Object)parameter));
                            int p = 0;
                            if (subParams.length > 0) {
                                paramType.append(subParams[p++]);
                            }
                            while (p < subParams.length) {
                                paramType.append(", ");
                                paramType.append(subParams[p++]);
                            }
                            paramType.append(">");
                            break;
                        }
                    }
                }
            } else if (decl instanceof ParameterDeclaration) {
                parameter = (ParameterDeclaration)decl;
                paramType.append(this.getType(parameter, (Declarator)((ParameterDeclaration)parameter).getDeclarators().get(0)));
            }
            parameterTypes[j] = new String(paramType.toString());
            ++j;
        }
        return parameterTypes;
    }

    private String getType(Declaration declaration, Declarator declarator) {
        StringBuffer type = new StringBuffer();
        type.append(this.getDeclarationType(declaration));
        type.append(this.getDeclaratorPointerOperation(declarator));
        if (declarator.getDeclarator() != null) {
            type.append("(*)");
        }
        type.append(this.getDeclaratorArrayQualifiers(declarator));
        return type.toString();
    }

    private String getDeclarationType(Declaration declaration) {
        ElaboratedTypeSpecifier elab;
        TypeSpecifier typeSpecifier;
        StringBuffer type = new StringBuffer();
        if (declaration instanceof ParameterDeclaration) {
            ParameterDeclaration paramDeclaration = (ParameterDeclaration)declaration;
            if (paramDeclaration.getDeclSpecifier().isConst()) {
                type.append("const ");
            }
            if (paramDeclaration.getDeclSpecifier().isVolatile()) {
                type.append("volatile ");
            }
            if ((typeSpecifier = paramDeclaration.getTypeSpecifier()) == null) {
                type.append(paramDeclaration.getDeclSpecifier().getTypeName());
            } else if (typeSpecifier instanceof ElaboratedTypeSpecifier) {
                elab = (ElaboratedTypeSpecifier)typeSpecifier;
                type.append(this.getElaboratedTypeSignature(elab));
            }
        }
        if (declaration instanceof SimpleDeclaration) {
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)declaration;
            if (simpleDeclaration.getDeclSpecifier().isConst()) {
                type.append("const ");
            }
            if (simpleDeclaration.getDeclSpecifier().isVolatile()) {
                type.append("volatile ");
            }
            if ((typeSpecifier = simpleDeclaration.getTypeSpecifier()) == null) {
                type.append(simpleDeclaration.getDeclSpecifier().getTypeName());
            } else if (typeSpecifier instanceof ElaboratedTypeSpecifier) {
                elab = (ElaboratedTypeSpecifier)typeSpecifier;
                type.append(this.getElaboratedTypeSignature(elab));
            }
        }
        return type.toString();
    }

    private String getElaboratedTypeSignature(ElaboratedTypeSpecifier elab) {
        StringBuffer type = new StringBuffer();
        int t = elab.getClassKey();
        switch (t) {
            case 0: {
                type.append("class");
                break;
            }
            case 1: {
                type.append("struct");
                break;
            }
            case 2: {
                type.append("union");
                break;
            }
            case 3: {
                type.append("enum");
            }
        }
        type.append(" ");
        type.append(elab.getName().toString());
        return type.toString();
    }

    private String getDeclaratorPointerOperation(Declarator declarator) {
        StringBuffer pointerString = new StringBuffer();
        List pointerOperators = declarator.getPointerOperators();
        if (pointerOperators != null) {
            Iterator i = pointerOperators.iterator();
            while (i.hasNext()) {
                PointerOperator po = (PointerOperator)i.next();
                switch (po.getType()) {
                    case 1: {
                        pointerString.append("*");
                        break;
                    }
                    case 2: {
                        pointerString.append("&");
                    }
                }
                if (po.isConst()) {
                    pointerString.append(" const");
                }
                if (!po.isVolatile()) continue;
                pointerString.append(" volatile");
            }
        }
        return pointerString.toString();
    }

    private String getDeclaratorArrayQualifiers(Declarator declarator) {
        StringBuffer arrayString = new StringBuffer();
        List arrayQualifiers = declarator.getArrayQualifiers();
        if (arrayQualifiers != null) {
            Iterator i = arrayQualifiers.iterator();
            while (i.hasNext()) {
                ArrayQualifier q = (ArrayQualifier)i.next();
                arrayString.append("[]");
            }
        }
        return arrayString.toString();
    }
}

