/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.internal.core.parser.Declaration;
import org.eclipse.cdt.internal.core.parser.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.TypeInfo;

public class ParserSymbolTable {
    private Stack _contextStack = new Stack();
    private Declaration _compilationUnit = new Declaration();
    static /* synthetic */ Class class$org$eclipse$cdt$internal$core$parser$Declaration;
    static /* synthetic */ Class class$java$util$LinkedList;

    public ParserSymbolTable() {
        try {
            this._compilationUnit.setType(2);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            // empty catch block
        }
        this.push(this._compilationUnit);
    }

    public void push(Declaration obj) {
        if (!this._contextStack.empty() && obj.getContainingScope() == null) {
            obj.setContainingScope((Declaration)this._contextStack.peek());
        }
        this._contextStack.push(obj);
    }

    public Declaration pop() {
        return (Declaration)this._contextStack.pop();
    }

    public Declaration peek() {
        return (Declaration)this._contextStack.peek();
    }

    public Declaration getCompilationUnit() {
        return this._compilationUnit;
    }

    public Declaration Lookup(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        return ParserSymbolTable.ResolveAmbiguities(data);
    }

    public Declaration ElaboratedLookup(int type, String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, type);
        ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        return ParserSymbolTable.ResolveAmbiguities(data);
    }

    public Declaration LookupNestedNameSpecifier(String name) throws ParserSymbolTableException {
        return this.LookupNestedNameSpecifier(name, (Declaration)this._contextStack.peek());
    }

    private Declaration LookupNestedNameSpecifier(String name, Declaration inDeclaration) throws ParserSymbolTableException {
        Declaration foundDeclaration = null;
        LookupData data = new LookupData(name, 2);
        data.upperType = 5;
        ParserSymbolTable.LookupInContained(data, inDeclaration);
        if (data.foundItems != null) {
            foundDeclaration = ParserSymbolTable.ResolveAmbiguities(data);
        }
        if (foundDeclaration == null && inDeclaration._containingScope != null) {
            foundDeclaration = this.LookupNestedNameSpecifier(name, inDeclaration._containingScope);
        }
        return foundDeclaration;
    }

    public Declaration LookupMemberForDefinition(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        data.qualified = true;
        ParserSymbolTable.LookupInContained(data, (Declaration)this._contextStack.peek());
        return ParserSymbolTable.ResolveAmbiguities(data);
    }

    public Declaration QualifiedLookup(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        data.qualified = true;
        ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        return ParserSymbolTable.ResolveAmbiguities(data);
    }

    public Declaration QualifiedFunctionLookup(String name, LinkedList parameters) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, 7);
        data.qualified = true;
        data.parameters = parameters == null ? new LinkedList() : parameters;
        ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        return ParserSymbolTable.ResolveAmbiguities(data);
    }

    public Declaration MemberFunctionLookup(String name, LinkedList parameters) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, 7);
        data.parameters = parameters == null ? new LinkedList() : parameters;
        ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        return ParserSymbolTable.ResolveAmbiguities(data);
    }

    public Declaration UnqualifiedFunctionLookup(String name, LinkedList parameters) throws ParserSymbolTableException {
        HashSet associated = new HashSet();
        int size = parameters == null ? 0 : parameters.size();
        Iterator iter = parameters == null ? null : parameters.iterator();
        TypeInfo param = null;
        Declaration paramType = null;
        int i = size;
        while (i > 0) {
            param = (TypeInfo)iter.next();
            paramType = ParserSymbolTable.getFlatTypeInfo(param).getTypeDeclaration();
            ParserSymbolTable.getAssociatedScopes(paramType, associated);
            if (param.getPtrOperator() != null && (param.getPtrOperator().equals("*") || param.getPtrOperator().equals("[]")) && paramType._containingScope.isType(3, 5)) {
                ParserSymbolTable.getAssociatedScopes(paramType._containingScope, associated);
            }
            --i;
        }
        LookupData data = new LookupData(name, 7);
        data.parameters = parameters == null ? new LinkedList() : parameters;
        data.associated = associated;
        ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        Declaration found = ParserSymbolTable.ResolveAmbiguities(data);
        if (found == null || found._containingScope.getType() != 3) {
            if (found != null) {
                data.foundItems.add(found);
            }
            Object[] scopes = ((AbstractCollection)associated).toArray();
            size = associated.size();
            int i2 = 0;
            while (i2 < size) {
                Declaration decl = (Declaration)scopes[i2];
                if (associated.contains(decl)) {
                    data.qualified = true;
                    data.ignoreUsingDirectives = true;
                    ParserSymbolTable.Lookup(data, decl);
                }
                ++i2;
            }
            found = ParserSymbolTable.ResolveAmbiguities(data);
        }
        return found;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private Declaration LookupForFriendship(String name) throws ParserSymbolTableException {
        boolean bl;
        LookupData data = new LookupData(name, -1);
        Declaration decl = (Declaration)this._contextStack.peek();
        boolean inClass = decl.getType() == 3;
        Declaration enclosing = decl._containingScope;
        boolean bl2 = true;
        do {
            if (!bl2 || (bl2 = false) || !true) {
                enclosing = enclosing._containingScope;
            }
            if (enclosing == null) break;
            if (inClass) {
                if (enclosing.getType() != 3) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = enclosing.getType() == 2;
        } while (bl);
        data.stopAt = enclosing;
        ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        return ParserSymbolTable.ResolveAmbiguities(data);
    }

    public void addUsingDirective(Declaration namespace) throws ParserSymbolTableException {
        if (namespace.getType() != 2) {
            throw new ParserSymbolTableException(1);
        }
        Declaration declaration = (Declaration)this._contextStack.peek();
        if (declaration._usingDirectives == null) {
            declaration._usingDirectives = new LinkedList();
        }
        declaration._usingDirectives.add(namespace);
    }

    public Declaration addUsingDeclaration(String name) throws ParserSymbolTableException {
        return this.addUsingDeclaration(name, null);
    }

    public Declaration addUsingDeclaration(String name, Declaration declContext) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        if (declContext != null) {
            this.push(declContext);
            data.qualified = true;
            ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
            this.pop();
        } else {
            ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
        }
        Declaration obj = ParserSymbolTable.ResolveAmbiguities(data);
        if (data.foundItems == null) {
            throw new ParserSymbolTableException();
        }
        Declaration clone = null;
        int size = obj == null ? data.foundItems.size() : 1;
        Iterator iter = data.foundItems.iterator();
        int i = size;
        while (i > 0) {
            Declaration declaration = obj = obj != null && size == 1 ? obj : (Declaration)iter.next();
            if (!ParserSymbolTable.okToAddUsingDeclaration(obj, (Declaration)this._contextStack.peek())) {
                throw new ParserSymbolTableException();
            }
            clone = (Declaration)obj.clone();
            this.addDeclaration(clone);
            --i;
        }
        return size == 1 ? clone : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDeclaration(Declaration obj) throws ParserSymbolTableException {
        Declaration containing = (Declaration)this._contextStack.peek();
        if (obj.getType() == 15 && containing.getType() == 6) {
            obj.setTypeDeclaration(containing);
            containing = containing.getContainingScope();
        }
        Map declarations = containing.getContainedDeclarations();
        boolean unnamed = obj.getName().equals("");
        Object origObj = null;
        obj.setContainingScope(containing);
        if (declarations == null) {
            declarations = containing.createContained();
        } else {
            origObj = declarations.get(obj.getName());
        }
        if (origObj != null) {
            Declaration origDecl = null;
            LinkedList<Declaration> origList = null;
            if (origObj.getClass() == (class$org$eclipse$cdt$internal$core$parser$Declaration == null ? (class$org$eclipse$cdt$internal$core$parser$Declaration = ParserSymbolTable.class$("org.eclipse.cdt.internal.core.parser.Declaration")) : class$org$eclipse$cdt$internal$core$parser$Declaration)) {
                origDecl = (Declaration)origObj;
            } else {
                if (origObj.getClass() != (class$java$util$LinkedList == null ? (class$java$util$LinkedList = ParserSymbolTable.class$("java.util.LinkedList")) : class$java$util$LinkedList)) throw new ParserSymbolTableException();
                origList = (LinkedList<Declaration>)origObj;
            }
            if (!(unnamed || origList == null ? ParserSymbolTable.isValidOverload(origDecl, obj) : ParserSymbolTable.isValidOverload(origList, obj))) throw new ParserSymbolTableException(3);
            if (origList == null) {
                origList = new LinkedList<Declaration>();
                origList.add(origDecl);
                origList.add(obj);
                declarations.remove(obj);
                declarations.put(obj.getName(), origList);
            } else {
                origList.add(obj);
            }
        } else {
            declarations.put(obj.getName(), obj);
        }
        TypeInfo type = obj._typeInfo;
        if (!type.isType(7) || type.checkBit(128)) return;
        this.addThis(obj);
    }

    public Declaration addFriend(String name) throws ParserSymbolTableException {
        Declaration friend = this.LookupForFriendship(name);
        if (friend == null) {
            friend = new Declaration(name);
            friend.setNeedsDefinition(true);
            Declaration decl = (Declaration)this._contextStack.peek();
            Declaration containing = decl._containingScope;
            while (containing != null && containing.getType() != 2) {
                containing = containing._containingScope;
            }
            Declaration namespace = containing == null ? this._compilationUnit : containing;
            this.push(namespace);
            this.addDeclaration(friend);
            this.pop();
        }
        return friend;
    }

    private void addThis(Declaration obj) throws ParserSymbolTableException {
        TypeInfo type = obj._typeInfo;
        if (!type.isType(7) || type.checkBit(128)) {
            return;
        }
        if (obj._containingScope.isType(3, 5)) {
            LookupData data = new LookupData("this", -1);
            ParserSymbolTable.LookupInContained(data, obj);
            if (data.foundItems == null) {
                Declaration thisObj = new Declaration("this");
                thisObj.setType(1);
                thisObj.setTypeDeclaration(obj._containingScope);
                thisObj.setCVQualifier(obj.getCVQualifier());
                thisObj.setPtrOperator("*");
                this.push(obj);
                this.addDeclaration(thisObj);
                this.pop();
            }
        }
    }

    private static void Lookup(LookupData data, Declaration inDeclaration) throws ParserSymbolTableException {
        if (data.type != -1 && data.type < 3 && data.upperType > 5) {
            throw new ParserSymbolTableException(1);
        }
        Declaration decl = null;
        LinkedList transitives = new LinkedList();
        ParserSymbolTable.LookupInContained(data, inDeclaration);
        if (!data.ignoreUsingDirectives) {
            data.visited.clear();
            ParserSymbolTable.LookupInNominated(data, inDeclaration, transitives);
            if (!data.qualified || data.foundItems == null) {
                ParserSymbolTable.ProcessDirectives(inDeclaration, data, transitives);
                if (inDeclaration._usingDirectives != null) {
                    ParserSymbolTable.ProcessDirectives(inDeclaration, data, inDeclaration._usingDirectives);
                }
                while (data.usingDirectives != null && data.usingDirectives.get(inDeclaration) != null) {
                    transitives.clear();
                    ParserSymbolTable.LookupInNominated(data, inDeclaration, transitives);
                    if (data.qualified && data.foundItems != null) continue;
                    ParserSymbolTable.ProcessDirectives(inDeclaration, data, transitives);
                }
            }
        }
        if (data.foundItems != null || data.stopAt == inDeclaration) {
            return;
        }
        data.visited.clear();
        decl = ParserSymbolTable.LookupInParents(data, inDeclaration);
        if (decl != null) {
            data.foundItems.add(decl);
        }
        if (data.foundItems == null && inDeclaration._containingScope != null) {
            ParserSymbolTable.Lookup(data, inDeclaration._containingScope);
        }
    }

    private static void LookupInNominated(LookupData data, Declaration declaration, LinkedList transitiveDirectives) throws ParserSymbolTableException {
        if (data.usingDirectives == null) {
            return;
        }
        LinkedList directives = null;
        Iterator iter = null;
        Declaration decl = null;
        boolean foundSomething = false;
        int size = 0;
        directives = (LinkedList)data.usingDirectives.remove(declaration);
        if (directives == null) {
            return;
        }
        iter = directives.iterator();
        int i = size = directives.size();
        while (i > 0) {
            decl = (Declaration)iter.next();
            if (!data.visited.contains(decl)) {
                data.visited.add(decl);
                foundSomething = ParserSymbolTable.LookupInContained(data, decl);
                if (!(data.qualified && foundSomething || decl._usingDirectives == null)) {
                    transitiveDirectives.addAll(decl._usingDirectives);
                }
            }
            --i;
        }
    }

    private static boolean LookupInContained(LookupData data, Declaration lookIn) throws ParserSymbolTableException {
        Map declarations;
        boolean foundSomething = false;
        Declaration temp = null;
        Object obj = null;
        if (data.associated != null) {
            data.associated.remove(lookIn);
        }
        if ((declarations = lookIn.getContainedDeclarations()) == null) {
            return foundSomething;
        }
        obj = declarations.get(data.name);
        if (obj == null) {
            return foundSomething;
        }
        if (obj.getClass() == (class$org$eclipse$cdt$internal$core$parser$Declaration == null ? (class$org$eclipse$cdt$internal$core$parser$Declaration = ParserSymbolTable.class$("org.eclipse.cdt.internal.core.parser.Declaration")) : class$org$eclipse$cdt$internal$core$parser$Declaration)) {
            if (((Declaration)obj).isType(data.type, data.upperType)) {
                if (data.foundItems == null) {
                    data.foundItems = new HashSet();
                }
                data.foundItems.add(obj);
                foundSomething = true;
            }
        } else {
            LinkedList objList = (LinkedList)obj;
            Iterator iter = objList.iterator();
            int size = objList.size();
            int i = 0;
            while (i < size) {
                temp = (Declaration)iter.next();
                if (temp.isType(data.type, data.upperType)) {
                    if (data.foundItems == null) {
                        data.foundItems = new HashSet();
                    }
                    data.foundItems.add(temp);
                    foundSomething = true;
                }
                ++i;
            }
        }
        return foundSomething;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Declaration LookupInParents(LookupData data, Declaration lookIn) throws ParserSymbolTableException {
        int size;
        LinkedList scopes = lookIn.getParentScopes();
        boolean foundSomething = false;
        Declaration temp = null;
        Declaration decl = null;
        Iterator iterator = null;
        Declaration.ParentWrapper wrapper = null;
        if (scopes == null) {
            return null;
        }
        if (data.inheritanceChain == null) {
            data.inheritanceChain = new HashSet();
        }
        data.inheritanceChain.add(lookIn);
        iterator = scopes.iterator();
        int i = size = scopes.size();
        while (i > 0) {
            wrapper = (Declaration.ParentWrapper)iterator.next();
            if (!wrapper.isVirtual || !data.visited.contains(wrapper.parent)) {
                if (wrapper.isVirtual) {
                    data.visited.add(wrapper.parent);
                }
                if (data.inheritanceChain.contains(wrapper.parent)) throw new ParserSymbolTableException(2);
                ParserSymbolTable.LookupInContained(data, wrapper.parent);
                temp = ParserSymbolTable.ResolveAmbiguities(data);
                if (temp == null) {
                    temp = ParserSymbolTable.LookupInParents(data, wrapper.parent);
                }
            }
            if (temp != null && temp.isType(data.type)) {
                if (decl == null) {
                    decl = temp;
                } else if (temp != null) {
                    TypeInfo type = temp._typeInfo;
                    if (decl != temp || !type.checkBit(128) && !type.isType(15)) throw new ParserSymbolTableException(0);
                    temp = null;
                }
            } else {
                temp = null;
            }
            --i;
        }
        data.inheritanceChain.remove(lookIn);
        return decl;
    }

    private static boolean isValidOverload(Declaration origDecl, Declaration newDecl) {
        int origType = origDecl.getType();
        int newType = newDecl.getType();
        if (origType >= 3 && origType <= 6 && (newType == 1 || newType >= 7 && newType <= 31)) {
            return true;
        }
        return ParserSymbolTable.isValidFunctionOverload(origDecl, newDecl);
    }

    private static boolean isValidOverload(LinkedList origList, Declaration newDecl) {
        if (origList.size() == 1) {
            return ParserSymbolTable.isValidOverload((Declaration)origList.getFirst(), newDecl);
        }
        if (origList.size() > 1) {
            if (newDecl.getType() != 7) {
                return false;
            }
            Iterator iter = origList.iterator();
            Declaration decl = (Declaration)iter.next();
            boolean valid = decl.getType() >= 3 && decl.getType() <= 6 || ParserSymbolTable.isValidFunctionOverload(decl, newDecl);
            while (valid && iter.hasNext()) {
                decl = (Declaration)iter.next();
                valid = ParserSymbolTable.isValidFunctionOverload(decl, newDecl);
            }
            return valid;
        }
        return true;
    }

    private static boolean isValidFunctionOverload(Declaration origDecl, Declaration newDecl) {
        if (origDecl.getType() != 7 || newDecl.getType() != 7) {
            return false;
        }
        if (origDecl.hasSameParameters(newDecl)) {
            if (origDecl._typeInfo.checkBit(128) || newDecl._typeInfo.checkBit(128)) {
                return false;
            }
            return origDecl.getCVQualifier() != newDecl.getCVQualifier();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Declaration ResolveAmbiguities(LookupData data) throws ParserSymbolTableException {
        Declaration decl = null;
        Declaration obj = null;
        Declaration cls = null;
        if (data.foundItems == null) {
            return null;
        }
        int size = data.foundItems.size();
        Iterator iter = data.foundItems.iterator();
        boolean needDecl = true;
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            decl = (Declaration)iter.next();
            if (!decl.isType(7)) {
                data.foundItems.clear();
                return decl;
            }
            needDecl = false;
        }
        LinkedList<Declaration> functionList = null;
        int i = size;
        while (i > 0) {
            if (needDecl) {
                decl = (Declaration)iter.next();
            } else {
                needDecl = true;
            }
            if (decl.isType(7)) {
                if (functionList == null) {
                    functionList = new LinkedList<Declaration>();
                }
                functionList.add(decl);
            } else if (decl.isType(3, 6)) {
                if (cls != null) throw new ParserSymbolTableException(0);
                cls = decl;
            } else {
                if (obj != null) throw new ParserSymbolTableException(0);
                obj = decl;
            }
            decl = null;
            --i;
        }
        data.foundItems.clear();
        int numFunctions = functionList == null ? 0 : functionList.size();
        boolean ambiguous = false;
        if (cls != null) {
            if (obj != null && cls._containingScope != obj._containingScope) {
                ambiguous = true;
            }
            if (functionList != null) {
                Iterator fnIter = functionList.iterator();
                Declaration fn = null;
                int i2 = numFunctions;
                while (i2 > 0) {
                    fn = (Declaration)fnIter.next();
                    if (cls._containingScope != fn._containingScope) {
                        ambiguous = true;
                        break;
                    }
                    --i2;
                }
            }
        }
        if (obj != null && !ambiguous) {
            if (numFunctions <= 0) return obj;
            ambiguous = true;
        } else if (numFunctions > 0) {
            if (data.parameters != null) return ParserSymbolTable.ResolveFunction(data, functionList);
            if (numFunctions == 1) {
                return (Declaration)functionList.getFirst();
            }
            data.foundItems.addAll(functionList);
            return null;
        }
        if (!ambiguous) return cls;
        throw new ParserSymbolTableException(0);
    }

    private static Declaration ResolveFunction(LookupData data, LinkedList functions) throws ParserSymbolTableException {
        ParserSymbolTable.ReduceToViable(data, functions);
        int numSourceParams = data.parameters == null ? 0 : data.parameters.size();
        int numFns = functions.size();
        if (numSourceParams == 0) {
            if (numFns == 0) {
                return null;
            }
            if (numFns == 1) {
                return (Declaration)functions.getFirst();
            }
            throw new ParserSymbolTableException(0);
        }
        Declaration bestFn = null;
        Declaration currFn = null;
        Cost[] bestFnCost = null;
        Cost[] currFnCost = null;
        Iterator iterFns = functions.iterator();
        Iterator sourceParams = null;
        Iterator targetParams = null;
        int numTargetParams = 0;
        int numParams = 0;
        Cost cost = null;
        Cost temp = null;
        TypeInfo source = null;
        TypeInfo target = null;
        boolean hasWorse = false;
        boolean hasBetter = false;
        boolean ambiguous = false;
        boolean currHasAmbiguousParam = false;
        boolean bestHasAmbiguousParam = false;
        int i = numFns;
        while (i > 0) {
            currFn = (Declaration)iterFns.next();
            sourceParams = data.parameters.iterator();
            targetParams = currFn._parameters.iterator();
            numTargetParams = currFn._parameters.size();
            int n = numParams = numTargetParams < numSourceParams ? numTargetParams : numSourceParams;
            if (currFnCost == null) {
                currFnCost = new Cost[numParams];
            }
            int comparison = 0;
            int j = 0;
            while (j < numParams) {
                source = (TypeInfo)sourceParams.next();
                if (source.equals(target = (TypeInfo)targetParams.next())) {
                    cost = new Cost(source, target);
                    cost.rank = 0;
                } else {
                    cost = ParserSymbolTable.checkStandardConversionSequence(source, target);
                    if (cost.rank == -1 && (temp = ParserSymbolTable.checkUserDefinedConversionSequence(source, target)) != null) {
                        cost = temp;
                    }
                }
                currFnCost[j] = cost;
                ++j;
            }
            hasWorse = false;
            hasBetter = false;
            int j2 = 0;
            while (j2 < numParams) {
                if (currFnCost[j2].rank < 0) {
                    hasWorse = true;
                    hasBetter = false;
                    break;
                }
                boolean bl = currHasAmbiguousParam = currFnCost[j2].userDefined == 1;
                if (bestFnCost != null) {
                    comparison = currFnCost[j2].compare(bestFnCost[j2]);
                    hasWorse |= comparison < 0;
                    hasBetter |= comparison > 0;
                } else {
                    hasBetter = true;
                }
                ++j2;
            }
            ambiguous |= hasWorse && hasBetter || !hasWorse && !hasBetter;
            if (!hasWorse && hasBetter) {
                ambiguous = false;
                bestFnCost = currFnCost;
                bestHasAmbiguousParam = currHasAmbiguousParam;
                currFnCost = null;
                bestFn = currFn;
            }
            --i;
        }
        if (ambiguous || bestHasAmbiguousParam) {
            throw new ParserSymbolTableException(0);
        }
        return bestFn;
    }

    private static void ReduceToViable(LookupData data, LinkedList functions) {
        int numParameters = data.parameters == null ? 0 : data.parameters.size();
        Iterator iter = functions.iterator();
        block0: while (iter.hasNext()) {
            int num;
            Declaration function = (Declaration)iter.next();
            int n = num = function._parameters == null ? 0 : function._parameters.size();
            if (num == numParameters) continue;
            if (num < numParameters) {
                iter.remove();
                continue;
            }
            ListIterator listIter = function._parameters.listIterator(num);
            int i = num;
            while (i > numParameters - num + 1) {
                TypeInfo param = (TypeInfo)listIter.previous();
                if (!param.getHasDefault()) {
                    iter.remove();
                    continue block0;
                }
                --i;
            }
        }
    }

    private static void ProcessDirectives(Declaration decl, LookupData data, LinkedList directives) {
        Declaration enclosing = null;
        Declaration temp = null;
        int size = directives.size();
        Iterator iter = directives.iterator();
        int i = size;
        while (i > 0) {
            temp = (Declaration)iter.next();
            if (!data.visited.contains(temp)) {
                LinkedList<Declaration> list;
                enclosing = ParserSymbolTable.getClosestEnclosingDeclaration(decl, temp);
                LinkedList<Declaration> linkedList = list = data.usingDirectives == null ? null : (LinkedList<Declaration>)data.usingDirectives.get(enclosing);
                if (list == null) {
                    list = new LinkedList<Declaration>();
                    list.add(temp);
                    if (data.usingDirectives == null) {
                        data.usingDirectives = new HashMap();
                    }
                    data.usingDirectives.put(enclosing, list);
                } else {
                    list.add(temp);
                }
            }
            --i;
        }
    }

    private static Declaration getClosestEnclosingDeclaration(Declaration decl1, Declaration decl2) {
        if (decl1 == decl2) {
            return decl1;
        }
        if (decl1._depth == decl2._depth) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(decl1._containingScope, decl2._containingScope);
        }
        if (decl1._depth > decl2._depth) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(decl1._containingScope, decl2);
        }
        return ParserSymbolTable.getClosestEnclosingDeclaration(decl1, decl2._containingScope);
    }

    private static int hasBaseClass(Declaration obj, Declaration base) {
        if (obj == base) {
            return 0;
        }
        if (obj._parentScopes != null) {
            int size;
            Iterator iter = obj._parentScopes.iterator();
            int i = size = obj._parentScopes.size();
            while (i > 0) {
                Declaration.ParentWrapper wrapper = (Declaration.ParentWrapper)iter.next();
                Declaration decl = wrapper.parent;
                if (decl == base) {
                    return 1;
                }
                int n = ParserSymbolTable.hasBaseClass(decl, base);
                if (n > 0) {
                    return n + 1;
                }
                --i;
            }
        }
        return -1;
    }

    private static void getAssociatedScopes(Declaration decl, HashSet associated) {
        if (decl == null) {
            return;
        }
        if (decl.getType() == 3) {
            associated.add(decl);
            ParserSymbolTable.getBaseClassesAndContainingNamespaces(decl, associated);
        } else if (decl.getType() == 5 || decl.getType() == 6) {
            associated.add(decl._containingScope);
        }
    }

    private static void getBaseClassesAndContainingNamespaces(Declaration obj, HashSet classes) {
        if (obj._parentScopes != null) {
            int size;
            if (classes == null) {
                return;
            }
            Iterator iter = obj._parentScopes.iterator();
            int i = size = obj._parentScopes.size();
            while (i > 0) {
                Declaration.ParentWrapper wrapper = (Declaration.ParentWrapper)iter.next();
                Declaration base = wrapper.parent;
                classes.add(base);
                if (base._containingScope.getType() == 2) {
                    classes.add(base._containingScope);
                }
                ParserSymbolTable.getBaseClassesAndContainingNamespaces(base, classes);
                --i;
            }
        }
    }

    private static boolean okToAddUsingDeclaration(Declaration obj, Declaration context) {
        boolean okToAdd = false;
        if (context.isType(3, 5)) {
            if (obj.getContainingScope().getType() == context.getType()) {
                okToAdd = ParserSymbolTable.hasBaseClass(context, obj.getContainingScope()) > 0;
            } else if (obj.getContainingScope().getType() == 5) {
                Declaration union = obj.getContainingScope();
                okToAdd = ParserSymbolTable.hasBaseClass(context, union.getContainingScope()) > 0;
            } else if (obj.getType() == 15) {
                Declaration enumeration = obj.getContainingScope();
                okToAdd = ParserSymbolTable.hasBaseClass(context, enumeration.getContainingScope()) > 0;
            }
        } else {
            okToAdd = true;
        }
        return okToAdd;
    }

    private static Cost lvalue_to_rvalue(TypeInfo source, TypeInfo target) throws ParserSymbolTableException {
        char[] targetPtrArray;
        char[] sourcePtrArray;
        if (source.isType(1)) {
            source = ParserSymbolTable.getFlatTypeInfo(source);
        }
        String sourcePtr = source.getPtrOperator();
        String targetPtr = target.getPtrOperator();
        if (sourcePtr != null && sourcePtr.length() > 0 && (sourcePtrArray = sourcePtr.toCharArray())[0] == '&') {
            source.setPtrOperator(new String(sourcePtrArray, 1, sourcePtr.length() - 1));
        }
        if (targetPtr != null && targetPtr.length() > 0 && (targetPtrArray = targetPtr.toCharArray())[0] == '&') {
            target.setPtrOperator(new String(targetPtrArray, 1, targetPtr.length() - 1));
        }
        Cost cost = new Cost(source, target);
        return cost;
    }

    private static void qualificationConversion(Cost cost) {
        if (cost.source.getCVQualifier() == cost.target.getCVQualifier() || cost.target.getCVQualifier() - cost.source.getCVQualifier() > 1) {
            cost.qualification = cost.target.getCVQualifier() + 1;
            cost.rank = 0;
        } else {
            cost.qualification = 0;
        }
    }

    private static void promotion(Cost cost) {
        TypeInfo src = cost.source;
        TypeInfo trg = cost.target;
        int mask = 917504;
        if ((src.isType(8, 12) || src.isType(6)) && (trg.isType(11) || trg.isType(13))) {
            if (src.getType() == trg.getType() && (src.getTypeInfo() & mask) == (trg.getTypeInfo() & mask)) {
                return;
            }
            cost.promotion = src.isType(12) ? (trg.isType(13) ? 1 : 0) : (trg.isType(11) && trg.canHold(src) ? 1 : 0);
        } else {
            cost.promotion = 0;
        }
        cost.rank = cost.promotion > 0 ? 1 : -1;
    }

    private static void conversion(Cost cost) {
        TypeInfo src = cost.source;
        TypeInfo trg = cost.target;
        String tempStr = src.getPtrOperator();
        String srcPtr = tempStr == null ? new String("") : tempStr;
        tempStr = trg.getPtrOperator();
        String trgPtr = tempStr == null ? new String("") : tempStr;
        cost.conversion = 0;
        cost.detail = 0;
        if (!srcPtr.equals(trgPtr)) {
            return;
        }
        if (srcPtr.equals("*")) {
            Declaration trgDecl;
            Declaration srcDecl = src.isType(1) ? src.getTypeDeclaration() : null;
            Declaration declaration = trgDecl = trg.isType(1) ? trg.getTypeDeclaration() : null;
            if (srcDecl == null || trgDecl == null && !trg.isType(14)) {
                return;
            }
            if (trg.isType(14)) {
                cost.rank = 2;
                cost.conversion = 1;
                cost.detail = 2;
                return;
            }
            cost.detail = 1;
            if (srcDecl.isType(3) && trgDecl.isType(3)) {
                int temp = ParserSymbolTable.hasBaseClass(srcDecl, trgDecl);
                cost.rank = 2;
                cost.conversion = temp > -1 ? temp : 0;
                cost.detail = 1;
                return;
            }
            if (srcDecl._containingScope.isType(3) && trgDecl._containingScope.isType(3)) {
                int temp = ParserSymbolTable.hasBaseClass(trgDecl._containingScope, srcDecl._containingScope);
                cost.rank = 2;
                cost.conversion = temp > -1 ? temp : 0;
                return;
            }
        } else if ((src.isType(8, 11) || src.isType(12, 13) || src.isType(6)) && (trg.isType(8, 11) || trg.isType(12, 13))) {
            cost.rank = 2;
            cost.conversion = 1;
        }
    }

    private static Cost checkStandardConversionSequence(TypeInfo source, TypeInfo target) throws ParserSymbolTableException {
        Cost cost = ParserSymbolTable.lvalue_to_rvalue(source, target);
        if (cost.source.equals(cost.target)) {
            cost.rank = 0;
            return cost;
        }
        ParserSymbolTable.qualificationConversion(cost);
        if (cost.qualification == 0) {
            return cost;
        }
        ParserSymbolTable.promotion(cost);
        if (cost.promotion > 0 || cost.rank > -1) {
            return cost;
        }
        ParserSymbolTable.conversion(cost);
        return cost;
    }

    private static Cost checkUserDefinedConversionSequence(TypeInfo source, TypeInfo target) throws ParserSymbolTableException {
        String name;
        Cost cost = null;
        Cost constructorCost = null;
        Cost conversionCost = null;
        Declaration targetDecl = null;
        Declaration sourceDecl = null;
        Object constructor = null;
        Object conversion = null;
        if (target.getType() == 1 && (targetDecl = target.getTypeDeclaration()).isType(3, 5)) {
            LookupData data = new LookupData("", 7);
            LinkedList<TypeInfo> params = new LinkedList<TypeInfo>();
            params.add(source);
            data.parameters = params;
            ParserSymbolTable.LookupInContained(data, targetDecl);
            constructor = ParserSymbolTable.ResolveAmbiguities(data);
        }
        if (source.getType() == 1 && (sourceDecl = (source = ParserSymbolTable.getFlatTypeInfo(source)).getTypeDeclaration()) != null && !(name = target.toString()).equals("")) {
            LinkedList params;
            LookupData data = new LookupData("operator " + name, 7);
            data.parameters = params = new LinkedList();
            ParserSymbolTable.LookupInContained(data, sourceDecl);
            conversion = ParserSymbolTable.ResolveAmbiguities(data);
        }
        if (constructor != null) {
            constructorCost = ParserSymbolTable.checkStandardConversionSequence(new TypeInfo(1, ((Declaration)constructor)._containingScope), target);
        }
        if (conversion != null) {
            conversionCost = ParserSymbolTable.checkStandardConversionSequence(new TypeInfo(target.getType(), target.getTypeDeclaration()), target);
        }
        if (constructorCost != null && constructorCost.rank != -1 && conversionCost != null && conversionCost.rank != -1) {
            cost = constructorCost;
            cost.userDefined = 1;
            cost.rank = 3;
        } else if (constructorCost != null && constructorCost.rank != -1) {
            cost = constructorCost;
            cost.userDefined = constructor.hashCode();
            cost.rank = 3;
        } else if (conversionCost != null && conversionCost.rank != -1) {
            cost = conversionCost;
            cost.userDefined = conversion.hashCode();
            cost.rank = 3;
        }
        return cost;
    }

    private static TypeInfo getFlatTypeInfo(TypeInfo topInfo) throws ParserSymbolTableException {
        TypeInfo returnInfo = topInfo;
        TypeInfo info = null;
        if (topInfo.getType() == 1) {
            returnInfo = new TypeInfo();
            Declaration typeDecl = topInfo.getTypeDeclaration();
            info = topInfo.getTypeDeclaration().getTypeInfo();
            while (info.getType() == 1) {
                typeDecl = info.getTypeDeclaration();
                returnInfo.addCVQualifier(info.getCVQualifier());
                returnInfo.addPtrOperator(info.getPtrOperator());
                info = info.getTypeDeclaration().getTypeInfo();
            }
            if (info.isType(3, 6)) {
                returnInfo.setType(1);
                returnInfo.setTypeDeclaration(typeDecl);
            } else {
                returnInfo.setTypeInfo(info.getTypeInfo());
                returnInfo.setTypeDeclaration(null);
            }
            String ptrOp = returnInfo.getPtrOperator();
            returnInfo.setPtrOperator(topInfo.getInvertedPtrOperator());
            if (ptrOp != null) {
                returnInfo.addPtrOperator(ptrOp);
            }
            returnInfo.setCVQualifier(info.getCVQualifier());
            returnInfo.addCVQualifier(topInfo.getCVQualifier());
        }
        return returnInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Cost {
        public TypeInfo source;
        public TypeInfo target;
        public int lvalue;
        public int promotion;
        public int conversion;
        public int qualification;
        public int userDefined;
        public int rank = -1;
        public int detail;

        public Cost(TypeInfo s, TypeInfo t) {
            this.source = s;
            this.target = t;
        }

        public int compare(Cost cost) {
            int result = 0;
            if (this.rank != cost.rank) {
                return cost.rank - this.rank;
            }
            if (this.userDefined != 0 || cost.userDefined != 0) {
                if (this.userDefined == 0 || cost.userDefined == 0) {
                    return cost.userDefined - this.userDefined;
                }
                if (this.userDefined == 1 || cost.userDefined == 1 || this.userDefined != cost.userDefined) {
                    return 0;
                }
            }
            if (this.promotion > 0 || cost.promotion > 0) {
                result = cost.promotion - this.promotion;
            }
            if (this.conversion > 0 || cost.conversion > 0) {
                result = this.detail == cost.detail ? cost.conversion - this.conversion : cost.detail - this.detail;
            }
            if (result == 0) {
                result = cost.qualification - this.qualification;
            }
            return result;
        }
    }

    private static class LookupData {
        public String name;
        public Map usingDirectives;
        public Set visited = new HashSet();
        public HashSet inheritanceChain;
        public LinkedList parameters;
        public HashSet associated;
        public Declaration stopAt;
        public int type = -1;
        public int upperType = 0;
        public boolean qualified = false;
        public boolean ignoreUsingDirectives = false;
        public HashSet foundItems = null;

        public LookupData(String n, int t) {
            this.name = n;
            this.type = t;
        }
    }
}

