/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.internal.core.parser.BranchTracker;
import org.eclipse.cdt.internal.core.parser.ContextStack;
import org.eclipse.cdt.internal.core.parser.ExpressionEvaluator;
import org.eclipse.cdt.internal.core.parser.IMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.IParserCallback;
import org.eclipse.cdt.internal.core.parser.IScanner;
import org.eclipse.cdt.internal.core.parser.IScannerContext;
import org.eclipse.cdt.internal.core.parser.MacroDescriptor;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ScannerContext;
import org.eclipse.cdt.internal.core.parser.ScannerException;
import org.eclipse.cdt.internal.core.parser.Token;

public class Scanner
implements IScanner {
    private static final int NOCHAR = -1;
    private static final String TEXT = "<text>";
    private static final String START = "<initial reader>";
    private static final String EXPRESSION = "<expression>";
    private static final String PASTING = "<pasting>";
    private static final String BAD_PP = "Invalid preprocessor directive encountered at offset ";
    private static final String DEFINED = "defined";
    private static final String POUND_DEFINE = "#define ";
    private ContextStack contextStack = new ContextStack();
    private IScannerContext lastContext = null;
    private List includePathNames = new ArrayList();
    private List includePaths = new ArrayList();
    private Hashtable definitions = new Hashtable();
    private StringBuffer storageBuffer = null;
    private int count = 0;
    private static HashMap cppKeywords = new HashMap();
    private static HashMap cKeywords = new HashMap();
    private static HashMap ppDirectives = new HashMap();
    private Token currentToken = null;
    private Token cachedToken = null;
    private boolean passOnToClient = true;
    private BranchTracker branches = new BranchTracker();
    private boolean throwExceptionOnBadPreprocessorSyntax = true;
    private boolean throwExceptionOnInclusionNotFound = true;
    private boolean throwExceptionOnBadMacroExpansion = true;
    private boolean throwExceptionOnUnboundedString = true;
    private boolean throwExceptionOnEOFWithinMultilineComment = true;
    private boolean throwExceptionOnEOFWithoutBalancedEndifs = true;
    private boolean throwExceptionOnBadCharacterRead = false;
    private boolean atEOF = false;
    private boolean tokenizingMacroReplacementList = false;
    private boolean quickScan = false;
    private IParserCallback callback;
    private boolean cppNature = true;
    private boolean mapLineNumbers = false;

    public IScanner initialize(Reader reader, String filename) {
        this.init(reader, filename);
        return this;
    }

    protected void init(Reader reader, String filename) {
        try {
            this.contextStack.push(new ScannerContext().initialize(new StringReader("\n"), START, 0));
            if (filename == null) {
                this.contextStack.push(new ScannerContext().initialize(reader, TEXT, 1));
            } else {
                this.contextStack.push(new ScannerContext().initialize(reader, filename, 1));
            }
        }
        catch (ScannerException scannerException) {
            // empty catch block
        }
    }

    public Scanner() {
    }

    protected Scanner(Reader reader, String filename, Hashtable defns) {
        this.initialize(reader, filename);
        this.definitions = defns;
    }

    public void addIncludePath(String includePath) {
        this.includePathNames.add(includePath);
        this.includePaths.add(new File(includePath));
    }

    public void overwriteIncludePath(List newIncludePaths) {
        this.includePathNames = null;
        this.includePaths = null;
        this.includePathNames = new ArrayList();
        this.includePaths = new ArrayList();
        this.includePathNames.addAll(newIncludePaths);
        Iterator i = this.includePathNames.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            this.includePaths.add(new File(path));
        }
    }

    public void addDefinition(String key, IMacroDescriptor macro) {
        this.definitions.put(key, macro);
    }

    public void addDefinition(String key, String value) {
        this.definitions.put(key, value);
    }

    public final Object getDefinition(String key) {
        return this.definitions.get(key);
    }

    public final Object[] getIncludePaths() {
        return this.includePathNames.toArray();
    }

    protected boolean skipOverWhitespace() throws ScannerException {
        int c = this.getChar();
        boolean result = false;
        while (c != -1 && (c == 32 || c == 9)) {
            c = this.getChar();
            result = true;
        }
        if (c != -1) {
            this.ungetChar(c);
        }
        return result;
    }

    protected String getRestOfPreprocessorLine() throws ScannerException {
        StringBuffer buffer;
        block7: {
            buffer = new StringBuffer();
            this.skipOverWhitespace();
            int c = this.getChar();
            while (true) {
                if (c != 10 && c != 13 && c != 92 && c != 47 && c != -1) {
                    buffer.append((char)c);
                    c = this.getChar();
                    continue;
                }
                if (c != 47) break;
                int next = this.getChar();
                if (next == 47) {
                    this.skipOverTextUntilNewline();
                    break block7;
                }
                if (next == 42) {
                    if (!this.skipOverMultilineComment()) {
                        c = this.getChar();
                        continue;
                    }
                    break block7;
                }
                buffer.append((char)c);
                c = next;
            }
            if (c != 92) {
                this.ungetChar(c);
            } else {
                c = this.getChar();
            }
        }
        return buffer.toString();
    }

    protected void skipOverTextUntilNewline() {
        while (true) {
            switch (this.getChar()) {
                case -1: 
                case 10: {
                    return;
                }
                case 92: {
                    this.getChar();
                }
            }
        }
    }

    private void setCurrentToken(Token t) {
        if (this.currentToken != null) {
            this.currentToken.setNext(t);
        }
        this.currentToken = t;
    }

    protected void resetStorageBuffer() {
        if (this.storageBuffer != null) {
            this.storageBuffer = null;
        }
    }

    protected Token newToken(int t, String i, IScannerContext c) {
        this.setCurrentToken(new Token(t, i, c));
        return this.currentToken;
    }

    protected Token newToken(int t, String i) {
        this.setCurrentToken(new Token(t, i));
        return this.currentToken;
    }

    protected String getNextIdentifier() throws ScannerException {
        StringBuffer buffer = new StringBuffer();
        this.skipOverWhitespace();
        int c = this.getChar();
        if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
            buffer.append((char)c);
            c = this.getChar();
            while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                buffer.append((char)c);
                c = this.getChar();
            }
        }
        this.ungetChar(c);
        return buffer.toString();
    }

    protected void handleInclusion(String fileName, boolean useIncludePaths) throws ScannerException {
        block9: {
            if (useIncludePaths) {
                Iterator iter = this.includePaths.iterator();
                while (iter.hasNext()) {
                    String newPath;
                    File includeFile;
                    File pathFile = (File)iter.next();
                    if (!pathFile.isDirectory() || !(includeFile = new File(newPath = pathFile.getPath() + File.separatorChar + fileName)).exists() || !includeFile.isFile()) continue;
                    try {
                        FileReader inclusionReader = new FileReader(includeFile);
                        this.contextStack.updateContext(inclusionReader, newPath, 2);
                        return;
                    }
                    catch (FileNotFoundException fnf) {
                        // empty catch block
                    }
                }
            } else {
                String currentFilename = this.contextStack.getCurrentContext().getFilename();
                File currentIncludeFile = new File(currentFilename);
                String parentDirectory = currentIncludeFile.getParent();
                currentIncludeFile = null;
                String fullPath = parentDirectory + File.separatorChar + fileName;
                File includeFile = new File(fullPath);
                if (includeFile.exists() && includeFile.isFile()) {
                    try {
                        FileReader inclusionReader = new FileReader(includeFile);
                        this.contextStack.updateContext(inclusionReader, fullPath, 2);
                        return;
                    }
                    catch (FileNotFoundException fnf) {
                        if (!this.throwExceptionOnInclusionNotFound) break block9;
                        throw new ScannerException("Cannot find inclusion " + fileName);
                    }
                }
            }
        }
        if (this.throwExceptionOnInclusionNotFound) {
            throw new ScannerException("Cannot find inclusion " + fileName);
        }
    }

    public void setTokenizingMacroReplacementList(boolean mr) {
        this.tokenizingMacroReplacementList = mr;
    }

    public void setQuickScan(boolean qs) {
        this.quickScan = qs;
    }

    public void setCallback(IParserCallback c) {
        this.callback = c;
    }

    private int getChar() {
        return this.getChar(false);
    }

    private int getChar(boolean insideString) {
        boolean done;
        int c = -1;
        this.lastContext = this.contextStack.getCurrentContext();
        if (this.contextStack.getCurrentContext() == null) {
            return c;
        }
        do {
            done = true;
            if (this.contextStack.getCurrentContext().undoStackSize() != 0) {
                c = this.contextStack.getCurrentContext().popUndo();
                continue;
            }
            try {
                c = this.contextStack.getCurrentContext().read();
                if (c != -1) continue;
                if (!this.contextStack.rollbackContext()) {
                    c = -1;
                    break;
                }
                done = false;
            }
            catch (IOException e) {
                if (!this.contextStack.rollbackContext()) {
                    c = -1;
                    continue;
                }
                done = false;
            }
        } while (!done);
        if (!insideString) {
            if (c == 92) {
                c = this.getChar(false);
                if (c == 13) {
                    c = this.getChar(false);
                    if (c == 10) {
                        c = this.getChar(false);
                    }
                } else if (c == 10) {
                    this.contextStack.newLine();
                    c = this.getChar(false);
                    if (c == 10) {
                        this.contextStack.newLine();
                    }
                }
            } else if (c == 10) {
                this.contextStack.newLine();
            }
        } else if (c == 10) {
            this.contextStack.newLine();
        }
        return c;
    }

    private void ungetChar(int c) throws ScannerException {
        this.contextStack.getCurrentContext().pushUndo(c);
        if (c == 10) {
            this.contextStack.recantNewline();
        }
        this.contextStack.undoRollback(this.lastContext);
    }

    protected boolean lookAheadForTokenPasting() throws ScannerException {
        int c = this.getChar();
        if (c == 35) {
            c = this.getChar();
            if (c == 35) {
                return true;
            }
            this.ungetChar(c);
        }
        this.ungetChar(c);
        return false;
    }

    public Token nextToken() throws ScannerException, Parser.EndOfFile {
        return this.nextToken(true);
    }

    /*
     * Unable to fully structure code
     */
    protected Token nextToken(boolean pasting) throws ScannerException, Parser.EndOfFile {
        if (this.cachedToken != null) {
            this.setCurrentToken(this.cachedToken);
            this.cachedToken = null;
            return this.currentToken;
        }
        ++this.count;
        madeMistake = false;
        c = this.getChar();
        block110: while (c != -1) {
            block173: {
                if (!this.passOnToClient) {
                    state = false;
                    while (c != -1 && c != 35) {
                        c = this.getChar();
                        if (c != 47) continue;
                        c = this.getChar();
                        if (c == 47) {
                            while (c != 10 && c != -1) {
                                c = this.getChar();
                            }
                            continue;
                        }
                        if (c != 42) continue;
                        this.skipOverMultilineComment();
                        c = this.getChar();
                    }
                    if (c == -1) continue;
                }
                if (c == 32 || c == 13 || c == 9 || c == 10) {
                    c = this.getChar();
                    continue;
                }
                if (c == 34 || c == 76 && !madeMistake) {
                    wideString = false;
                    if (c == 76) {
                        oldChar = c;
                        wideString = true;
                        c = this.getChar();
                        if (c != 34) {
                            this.ungetChar(c);
                            c = oldChar;
                            madeMistake = true;
                            continue;
                        }
                    }
                    buff = new StringBuffer();
                    beforePrevious = -1;
                    previous = c;
                    c = this.getChar(true);
                    while ((c != 34 || previous == 92 && beforePrevious != 92) && c != -1) {
                        buff.append((char)c);
                        beforePrevious = previous;
                        previous = c;
                        c = this.getChar(true);
                    }
                    if (c != -1) {
                        type = wideString != false ? 131 : 129;
                        returnToken = this.newToken(type, buff.toString(), this.contextStack.getCurrentContext());
                        next = null;
                        try {
                            next = this.nextToken(true);
                        }
                        catch (Parser.EndOfFile e) {
                            next = null;
                        }
                        while (next != null && next.type == returnToken.type) {
                            returnToken.image = returnToken.image + next.image;
                            returnToken.setNext(null);
                            this.currentToken = returnToken;
                            try {
                                next = this.nextToken(true);
                            }
                            catch (Parser.EndOfFile e) {
                                next = null;
                            }
                        }
                        this.cachedToken = next;
                        this.currentToken = returnToken;
                        returnToken.setNext(null);
                        return returnToken;
                    }
                    if (!this.throwExceptionOnUnboundedString) continue;
                    throw new ScannerException("Unbounded string");
                }
                if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
                    if (madeMistake) {
                        madeMistake = false;
                    }
                    buff = new StringBuffer();
                    buff.append((char)c);
                    c = this.getChar();
                    while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                        buff.append((char)c);
                        c = this.getChar();
                    }
                    this.ungetChar(c);
                    ident = buff.toString();
                    if (ident.equals("defined")) {
                        return this.newToken(2, this.handleDefinedMacro());
                    }
                    mapping = this.definitions.get(ident);
                    if (mapping != null && this.contextStack.shouldExpandDefinition("#define " + ident)) {
                        this.expandDefinition(ident, mapping);
                        c = this.getChar();
                        continue;
                    }
                    tokenTypeObject = this.cppNature != false ? Scanner.cppKeywords.get(ident) : Scanner.cKeywords.get(ident);
                    tokenType = 1;
                    if (tokenTypeObject != null) {
                        tokenType = (Integer)tokenTypeObject;
                    }
                    if (pasting) {
                        if (this.lookAheadForTokenPasting()) {
                            if (this.storageBuffer == null) {
                                this.storageBuffer = buff;
                            } else {
                                this.storageBuffer.append(ident);
                            }
                            c = this.getChar();
                            continue;
                        }
                        if (this.storageBuffer != null) {
                            this.storageBuffer.append(ident);
                            this.contextStack.updateContext(new StringReader(this.storageBuffer.toString()), "<pasting>", 3);
                            this.storageBuffer = null;
                            c = this.getChar();
                            continue;
                        }
                    }
                    return this.newToken(tokenType, ident, this.contextStack.getCurrentContext());
                }
                if (c >= 48 && c <= 57 || c == 46) {
                    buff = pasting ? (this.storageBuffer != null ? this.storageBuffer : new StringBuffer()) : new StringBuffer();
                    hex = false;
                    floatingPoint = c == 46;
                    firstCharZero = c == 48;
                    buff.append((char)c);
                    c = this.getChar();
                    if (c == 120) {
                        if (!firstCharZero && floatingPoint) {
                            this.ungetChar(c);
                            return this.newToken(50, ".", this.contextStack.getCurrentContext());
                        }
                        if (!firstCharZero) {
                            throw new ScannerException("Invalid Hexidecimal @ offset " + this.contextStack.getCurrentContext().getOffset());
                        }
                        hex = true;
                        c = this.getChar();
                    }
                    while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                        buff.append((char)c);
                        c = this.getChar();
                    }
                    if (c == 46) {
                        buff.append((char)c);
                        if (floatingPoint || hex) {
                            if (buff.toString().equals("..") && this.getChar() == 46) {
                                return this.newToken(48, "...");
                            }
                            throw new ScannerException("Invalid floating point @ offset " + this.contextStack.getCurrentContext().getOffset());
                        }
                        floatingPoint = true;
                        c = this.getChar();
                        while (c >= 48 && c <= 57) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                    }
                    if (c == 101 || c == 69) {
                        if (!floatingPoint) {
                            floatingPoint = true;
                        }
                        buff.append((char)c);
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                        while (c >= 48 && c <= 57) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                        if (c == 108 || c == 76 || c == 102 || c == 70) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                    }
                    this.ungetChar(c);
                    if (pasting) {
                        if (this.lookAheadForTokenPasting()) {
                            this.storageBuffer = buff;
                            c = this.getChar();
                            continue;
                        }
                        if (this.storageBuffer != null) {
                            this.contextStack.updateContext(new StringReader(buff.toString()), "<pasting>", 3);
                            this.storageBuffer = null;
                            c = this.getChar();
                            continue;
                        }
                    }
                    result = buff.toString();
                    tokenType = floatingPoint != false && result.equals(".") != false ? 50 : (floatingPoint != false ? 130 : 2);
                    return this.newToken(tokenType, result, this.contextStack.getCurrentContext());
                }
                if (c != 35) break block173;
                beginningOffset = this.contextStack.getCurrentContext().getOffset() - 1;
                buff = new StringBuffer();
                buff.append((char)c);
                skipped = this.skipOverWhitespace();
                c = this.getChar();
                if (c == 35) {
                    if (skipped) {
                        throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.contextStack.getCurrentContext().getOffset());
                    }
                    return this.newToken(-6, "##");
                }
                if (!this.tokenizingMacroReplacementList) ** GOTO lbl203
                this.ungetChar(c);
                return this.newToken(-7, "#");
lbl-1000:
                // 1 sources

                {
                    buff.append((char)c);
                    c = this.getChar();
lbl203:
                    // 2 sources

                    ** while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95)
                }
lbl204:
                // 1 sources

                this.ungetChar(c);
                token = buff.toString();
                directive = Scanner.ppDirectives.get(token);
                if (directive == null) {
                    if (!this.throwExceptionOnBadPreprocessorSyntax) continue;
                    throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.contextStack.getCurrentContext().getOffset());
                }
                type = (Integer)directive;
                switch (type) {
                    case 0: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block110;
                        }
                        this.poundDefine(beginningOffset);
                        c = this.getChar();
                        continue block110;
                    }
                    case 7: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block110;
                        }
                        this.poundInclude(beginningOffset);
                        c = this.getChar();
                        continue block110;
                    }
                    case 1: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block110;
                        }
                        this.skipOverWhitespace();
                        toBeUndefined = this.getNextIdentifier();
                        if (this.definitions.remove(toBeUndefined) == null && !this.quickScan) {
                            throw new ScannerException("Attempt to #undef symbol " + toBeUndefined + " when it was never defined");
                        }
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block110;
                    }
                    case 2: {
                        expression = this.getRestOfPreprocessorLine();
                        expressionEvalResult = this.evaluateExpression(expression);
                        this.passOnToClient = this.branches.poundif(expressionEvalResult);
                        c = this.getChar();
                        continue block110;
                    }
                    case 3: {
                        this.skipOverWhitespace();
                        definition = this.getNextIdentifier();
                        mapping = this.definitions.get(definition);
                        if (mapping == null) {
                            this.passOnToClient = this.branches.poundif(false);
                            this.skipOverTextUntilNewline();
                            continue block110;
                        }
                        this.passOnToClient = this.branches.poundif(true);
                        c = this.getChar();
                        continue block110;
                    }
                    case 6: {
                        restOfLine = this.getRestOfPreprocessorLine().trim();
                        if (!restOfLine.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.contextStack.getCurrentContext().getOffset());
                        }
                        this.passOnToClient = this.branches.poundendif();
                        c = this.getChar();
                        continue block110;
                    }
                    case 4: {
                        this.skipOverWhitespace();
                        def = this.getNextIdentifier();
                        map = this.definitions.get(def);
                        if (map != null) {
                            this.skipOverTextUntilNewline();
                            this.passOnToClient = this.branches.poundif(false);
                            continue block110;
                        }
                        this.passOnToClient = this.branches.poundif(true);
                        c = this.getChar();
                        continue block110;
                    }
                    case 5: {
                        this.passOnToClient = this.branches.poundelse();
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block110;
                    }
                    case 12: {
                        elsifExpression = this.getRestOfPreprocessorLine();
                        if (elsifExpression.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException("Malformed #elsif clause");
                        }
                        elsifResult = this.evaluateExpression(elsifExpression);
                        this.passOnToClient = this.branches.poundelif(elsifResult);
                        c = this.getChar();
                        continue block110;
                    }
                    case 8: {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block110;
                    }
                    case 9: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block110;
                        }
                        error = this.getRestOfPreprocessorLine();
                        if (!this.quickScan) {
                            throw new ScannerException("#error " + error);
                        }
                        c = this.getChar();
                        continue block110;
                    }
                    case 10: {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block110;
                    }
                    case 11: {
                        remainderOfLine = this.getRestOfPreprocessorLine().trim();
                        if (!remainderOfLine.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.contextStack.getCurrentContext().getOffset());
                        }
                        c = this.getChar();
                        continue block110;
                    }
                    default: {
                        if (!this.throwExceptionOnBadPreprocessorSyntax) continue block110;
                        throw new ScannerException("Invalid preprocessor directive encountered at offset " + this.contextStack.getCurrentContext().getOffset());
                    }
                }
            }
            block17 : switch (c) {
                case 39: {
                    c = this.getChar(true);
                    next = this.getChar(true);
                    if (c != 92) ** GOTO lbl331
                    c = next;
                    next = this.getChar(true);
                    if (next == 39) {
                        return this.newToken(132, '\\' + new Character((char)c).toString(), this.contextStack.getCurrentContext());
                    }
                    if (this.throwExceptionOnBadCharacterRead) {
                        throw new ScannerException("Invalid character '" + (char)c + "' read @ offset " + this.contextStack.getCurrentContext().getOffset() + " of file " + this.contextStack.getCurrentContext().getFilename());
                    }
                    ** GOTO lbl335
lbl331:
                    // 1 sources

                    if (next == 39) {
                        return this.newToken(132, new Character((char)c).toString(), this.contextStack.getCurrentContext());
                    }
                    if (this.throwExceptionOnBadCharacterRead) {
                        throw new ScannerException("Invalid character '" + (char)c + "' read @ offset " + this.contextStack.getCurrentContext().getOffset() + " of file " + this.contextStack.getCurrentContext().getFilename());
                    }
                }
lbl335:
                // 4 sources

                case 58: {
                    c = this.getChar();
                    switch (c) {
                        case 58: {
                            return this.newToken(3, "::", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(4, ":", this.contextStack.getCurrentContext());
                }
                case 59: {
                    return this.newToken(5, ";", this.contextStack.getCurrentContext());
                }
                case 44: {
                    return this.newToken(6, ",", this.contextStack.getCurrentContext());
                }
                case 63: {
                    return this.newToken(7, "?", this.contextStack.getCurrentContext());
                }
                case 40: {
                    return this.newToken(8, "(", this.contextStack.getCurrentContext());
                }
                case 41: {
                    return this.newToken(9, ")", this.contextStack.getCurrentContext());
                }
                case 91: {
                    return this.newToken(10, "[", this.contextStack.getCurrentContext());
                }
                case 93: {
                    return this.newToken(11, "]", this.contextStack.getCurrentContext());
                }
                case 123: {
                    return this.newToken(12, "{", this.contextStack.getCurrentContext());
                }
                case 125: {
                    return this.newToken(13, "}", this.contextStack.getCurrentContext());
                }
                case 43: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(14, "+=", this.contextStack.getCurrentContext());
                        }
                        case 43: {
                            return this.newToken(15, "++", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(16, "+", this.contextStack.getCurrentContext());
                }
                case 45: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(17, "-=", this.contextStack.getCurrentContext());
                        }
                        case 45: {
                            return this.newToken(18, "--", this.contextStack.getCurrentContext());
                        }
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 42: {
                                    return this.newToken(19, "->*", this.contextStack.getCurrentContext());
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(20, "->", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(21, "-", this.contextStack.getCurrentContext());
                }
                case 42: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(22, "*=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(23, "*", this.contextStack.getCurrentContext());
                }
                case 37: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(24, "%=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(25, "%", this.contextStack.getCurrentContext());
                }
                case 94: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(26, "^=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(27, "^", this.contextStack.getCurrentContext());
                }
                case 38: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(28, "&=", this.contextStack.getCurrentContext());
                        }
                        case 38: {
                            return this.newToken(29, "&&", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(30, "&", this.contextStack.getCurrentContext());
                }
                case 124: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(31, "|=", this.contextStack.getCurrentContext());
                        }
                        case 124: {
                            return this.newToken(32, "||", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(33, "|", this.contextStack.getCurrentContext());
                }
                case 126: {
                    return this.newToken(34, "~", this.contextStack.getCurrentContext());
                }
                case 33: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(35, "!=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(36, "!", this.contextStack.getCurrentContext());
                }
                case 61: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(37, "==", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(38, "=", this.contextStack.getCurrentContext());
                }
                case 60: {
                    c = this.getChar();
                    switch (c) {
                        case 60: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(47, "<<=", this.contextStack.getCurrentContext());
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(40, "<<", this.contextStack.getCurrentContext());
                        }
                        case 61: {
                            return this.newToken(41, "<=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(42, "<", this.contextStack.getCurrentContext());
                }
                case 62: {
                    c = this.getChar();
                    switch (c) {
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(43, ">>=", this.contextStack.getCurrentContext());
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(44, ">>", this.contextStack.getCurrentContext());
                        }
                        case 61: {
                            return this.newToken(45, ">=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(46, ">", this.contextStack.getCurrentContext());
                }
                case 46: {
                    c = this.getChar();
                    switch (c) {
                        case 46: {
                            c = this.getChar();
                            switch (c) {
                                case 46: {
                                    return this.newToken(48, "...", this.contextStack.getCurrentContext());
                                }
                            }
                            break block17;
                        }
                        case 42: {
                            return this.newToken(49, ".*", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(50, ".", this.contextStack.getCurrentContext());
                }
                case 47: {
                    c = this.getChar();
                    switch (c) {
                        case 47: {
                            c = this.getChar();
                            while (c != 10 && c != -1) {
                                c = this.getChar();
                            }
                            continue block110;
                        }
                        case 42: {
                            this.skipOverMultilineComment();
                            c = this.getChar();
                            continue block110;
                        }
                        case 61: {
                            return this.newToken(51, "/=", this.contextStack.getCurrentContext());
                        }
                        default: {
                            this.ungetChar(c);
                            return this.newToken(52, "/", this.contextStack.getCurrentContext());
                        }
                    }
                }
                default: {
                    if (this.throwExceptionOnBadCharacterRead) {
                        throw new ScannerException("Invalid character '" + (char)c + "' read @ offset " + this.contextStack.getCurrentContext().getOffset() + " of file " + this.contextStack.getCurrentContext().getFilename());
                    }
                    c = 32;
                    continue block110;
                }
            }
            throw Parser.endOfFile;
        }
        if (this.throwExceptionOnEOFWithoutBalancedEndifs && this.getDepth() != 0 && !this.atEOF) {
            this.atEOF = true;
            throw new ScannerException("End of file encountered without terminating #endif");
        }
        throw Parser.endOfFile;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getDepth() {
        return this.branches.getDepth();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean evaluateExpression(String expression) throws ScannerException {
        Object expressionEvalResult;
        block8: {
            if (this.quickScan) {
                return !expression.trim().equals("0");
            }
            expressionEvalResult = null;
            try {
                try {
                    ExpressionEvaluator evaluator = new ExpressionEvaluator();
                    Scanner trial = new Scanner(new StringReader(expression + ";"), EXPRESSION, this.definitions);
                    Parser parser = new Parser(trial, (IParserCallback)evaluator);
                    parser.expression(null);
                    expressionEvalResult = evaluator.getResult();
                }
                catch (Exception e) {
                    throw new ScannerException("Expression " + expression + " evaluates to an undefined value");
                }
                Object var7_8 = null;
                if (expressionEvalResult != null) break block8;
                throw new ScannerException("Expression " + expression + " evaluates to an undefined value");
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (expressionEvalResult != null) throw throwable;
                throw new ScannerException("Expression " + expression + " evaluates to an undefined value");
            }
        }
        if (expressionEvalResult instanceof Integer) {
            int i = (Integer)expressionEvalResult;
            return i != 0;
        }
        if (!(expressionEvalResult instanceof Boolean)) throw new ScannerException("Unexpected expression type - we do not expect " + expressionEvalResult.getClass().getName());
        return (Boolean)expressionEvalResult;
    }

    protected boolean skipOverMultilineComment() throws ScannerException {
        int state = 0;
        boolean encounteredNewline = false;
        int c = this.getChar();
        while (state != 2 && c != -1) {
            if (c == 10) {
                encounteredNewline = true;
            }
            switch (state) {
                case 0: {
                    if (c != 42) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    if (c == 42) break;
                    state = 0;
                }
            }
            c = this.getChar();
        }
        if (c == -1 && this.throwExceptionOnEOFWithinMultilineComment) {
            throw new ScannerException("Encountered EOF while in multiline comment");
        }
        this.ungetChar(c);
        return encounteredNewline;
    }

    protected void poundInclude(int beginningOffset) throws ScannerException {
        this.skipOverWhitespace();
        int c = this.getChar();
        StringBuffer fileName = new StringBuffer();
        boolean useIncludePath = true;
        if (c == 60) {
            c = this.getChar();
            while (c != 62) {
                fileName.append((char)c);
                c = this.getChar();
            }
        } else if (c == 34) {
            c = this.getChar();
            while (c != 34) {
                fileName.append((char)c);
                c = this.getChar();
            }
            useIncludePath = false;
        }
        String f = fileName.toString();
        if (this.quickScan) {
            if (this.callback != null) {
                int offset = this.contextStack.getCurrentContext().getOffset() - f.length() - 1;
                this.callback.inclusionEnd(this.callback.inclusionBegin(f, offset, beginningOffset));
            }
        } else {
            this.handleInclusion(f.trim(), useIncludePath);
        }
    }

    protected void poundDefine(int beginning) throws ScannerException, Parser.EndOfFile {
        String checkForRedefinition;
        this.skipOverWhitespace();
        String key = this.getNextIdentifier();
        int offset = this.contextStack.getCurrentContext().getOffset() - key.length() - this.contextStack.getCurrentContext().undoStackSize();
        if (!this.quickScan && (checkForRedefinition = (String)this.definitions.get(key)) != null) {
            throw new ScannerException("Preprocessor symbol " + key + " has already been defined to " + checkForRedefinition + " cannot redefined.");
        }
        int c = this.getChar();
        if (c == 40) {
            StringBuffer buffer = new StringBuffer();
            c = this.getChar();
            while (c != 41) {
                buffer.append((char)c);
                c = this.getChar();
            }
            String parameters = buffer.toString();
            StringTokenizer tokenizer = new StringTokenizer(parameters, ",");
            ArrayList<String> parameterIdentifiers = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                parameterIdentifiers.add(tokenizer.nextToken().trim());
            }
            this.skipOverWhitespace();
            ArrayList<Token> macroReplacementTokens = new ArrayList<Token>();
            String replacementString = this.getRestOfPreprocessorLine();
            if (!replacementString.equals("")) {
                Scanner helperScanner = new Scanner();
                helperScanner.initialize(new StringReader(replacementString), null);
                helperScanner.setTokenizingMacroReplacementList(true);
                Token t = helperScanner.nextToken(false);
                try {
                    while (true) {
                        if (t.type == -7) {
                            macroReplacementTokens.add(t);
                            t = helperScanner.nextToken(false);
                            int index = parameterIdentifiers.indexOf(t.image);
                            if (index == -1) {
                                if (this.throwExceptionOnBadPreprocessorSyntax) {
                                    throw new ScannerException(BAD_PP + this.contextStack.getCurrentContext().getOffset());
                                }
                                return;
                            }
                        }
                        macroReplacementTokens.add(t);
                        t = helperScanner.nextToken(false);
                    }
                }
                catch (Parser.EndOfFile eof) {
                    // empty catch block
                }
            }
            MacroDescriptor descriptor = new MacroDescriptor();
            descriptor.initialize(key, parameterIdentifiers, macroReplacementTokens, key + "(" + parameters + ")");
            this.addDefinition(key, descriptor);
        } else if (c == 10 || c == 13) {
            this.addDefinition(key, "");
        } else if (c == 32 || c == 9) {
            this.skipOverWhitespace();
            String value = this.getRestOfPreprocessorLine();
            this.addDefinition(key, value);
        } else if (c == 47) {
            c = this.getChar();
            if (c == 47) {
                this.skipOverTextUntilNewline();
                this.addDefinition(key, "");
            } else if (c == 42) {
                if (this.skipOverMultilineComment()) {
                    this.addDefinition(key, "");
                } else {
                    String value = this.getRestOfPreprocessorLine();
                    this.addDefinition(key, value);
                }
            } else if (this.throwExceptionOnBadPreprocessorSyntax) {
                throw new ScannerException(BAD_PP + this.contextStack.getCurrentContext().getOffset());
            }
        } else {
            System.out.println("Unexpected character " + (char)c);
            if (this.throwExceptionOnBadPreprocessorSyntax) {
                throw new ScannerException(BAD_PP + this.contextStack.getCurrentContext().getOffset());
            }
        }
        if (this.callback != null) {
            this.callback.macro(key, offset, beginning, this.contextStack.getCurrentContext().getOffset());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void expandDefinition(String symbol, Object expansion) throws ScannerException {
        if (expansion instanceof String) {
            replacementValue = (String)expansion;
            this.contextStack.updateContext(new StringReader(replacementValue), "#define " + symbol, 3);
        } else if (expansion instanceof IMacroDescriptor) {
            macro = (IMacroDescriptor)expansion;
            this.skipOverWhitespace();
            c = this.getChar();
            if (c == 40) {
                buffer = new StringBuffer();
                bracketCount = 1;
                c = this.getChar();
                while (true) {
                    if (c == 40) {
                        ++bracketCount;
                    } else if (c == 41) {
                        --bracketCount;
                    }
                    if (bracketCount == 0) break;
                    buffer.append((char)c);
                    c = this.getChar(true);
                }
                betweenTheBrackets = buffer.toString().trim();
                tokenizer = new Scanner(new StringReader(betweenTheBrackets), "<text>", this.definitions);
                parameterValues = new Vector<String>();
                t = null;
                str = new String();
                space = false;
                nParen = 0;
                try {
                    while (true) {
                        t = tokenizer.nextToken(false);
                        if (t.type == 8) {
                            ++nParen;
                        } else if (t.type == 9) {
                            --nParen;
                        } else if (t.type == 6 && nParen == 0) {
                            parameterValues.add(str);
                            str = "";
                            space = false;
                            continue;
                        }
                        if (space) {
                            str = str + ' ';
                        }
                        switch (t.type) {
                            case 129: {
                                str = str + '\"' + t.image + '\"';
                                break;
                            }
                            case 131: {
                                str = str + "L\"" + t.image + '\"';
                                break;
                            }
                            case 132: {
                                str = str + '\'' + t.image + '\'';
                                break;
                            }
                            default: {
                                str = str + t.image;
                            }
                        }
                        space = true;
                    }
                }
                catch (Parser.EndOfFile e) {
                    parameterValues.add(str);
                    buffer = new StringBuffer();
                    tokens = macro.getTokenizedExpansion();
                    parameterNames = macro.getParameters();
                    if (parameterNames.size() != parameterValues.size() && this.throwExceptionOnBadMacroExpansion) {
                        throw new ScannerException("Improper use of macro " + symbol);
                    }
                    numberOfTokens = tokens.size();
                    i = 0;
                    ** while (i < numberOfTokens)
                }
lbl-1000:
                // 1 sources

                {
                    t = (Token)tokens.get(i);
                    if (t.type == 1) {
                        identifierName = t.image;
                        index = parameterNames.indexOf(t.image);
                        if (index == -1) {
                            buffer.append(t.image);
                        } else {
                            buffer.append((String)parameterValues.elementAt(index));
                        }
                    } else if (t.type == -7) {
                        t = (Token)tokens.get(++i);
                        index = parameterNames.indexOf(t.image);
                        if (index == -1) {
                            if (this.throwExceptionOnBadMacroExpansion) {
                                throw new ScannerException("Improper use of the # preprocessing token.");
                            }
                        } else {
                            buffer.append('\"');
                            value = (String)parameterValues.elementAt(index);
                            val = value.toCharArray();
                            length = value.length();
                            j = 0;
                            while (j < length) {
                                ch = val[j];
                                if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                                    while (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                                        ch = val[++j];
                                    }
                                    buffer.append(' ');
                                }
                                if (ch == '\"' || ch == '\\') {
                                    buffer.append('\\');
                                    buffer.append(ch);
                                } else {
                                    buffer.append(ch);
                                }
                                ++j;
                            }
                            buffer.append('\"');
                        }
                    } else {
                        switch (t.type) {
                            case 129: {
                                buffer.append('\"' + t.image + '\"');
                                break;
                            }
                            case 131: {
                                buffer.append("L\"" + t.image + '\"');
                                break;
                            }
                            case 132: {
                                buffer.append('\'' + t.image + '\'');
                                break;
                            }
                            default: {
                                buffer.append(t.image);
                            }
                        }
                    }
                    pastingNext = false;
                    if (i != numberOfTokens - 1 && (t2 = (Token)tokens.get(i + 1)).getType() == -6) {
                        pastingNext = true;
                    }
                    if (t.getType() != -6 && !pastingNext) {
                        buffer.append(" ");
                    }
                    ++i;
                    continue;
                }
lbl143:
                // 1 sources

                finalString = buffer.toString();
                this.contextStack.updateContext(new StringReader(finalString), "#define " + macro.getSignature(), 3);
            } else if (this.throwExceptionOnBadMacroExpansion) {
                throw new ScannerException("Improper use of macro " + symbol);
            }
        } else {
            System.out.println("Unexpected class stored in definitions table. " + expansion.getClass().getName());
        }
    }

    protected String handleDefinedMacro() throws ScannerException {
        this.skipOverWhitespace();
        int c = this.getChar();
        if (c != 40 && this.throwExceptionOnBadMacroExpansion) {
            throw new ScannerException("Improper use of macro defined()");
        }
        StringBuffer buffer = new StringBuffer();
        c = this.getChar();
        while (c != -1 && c != 41) {
            buffer.append((char)c);
            c = this.getChar();
        }
        if (c == -1 && this.throwExceptionOnBadMacroExpansion) {
            throw new ScannerException("Improper use of macro defined()");
        }
        String definitionIdentifier = buffer.toString().trim();
        if (this.definitions.get(definitionIdentifier) != null) {
            return "1";
        }
        return "0";
    }

    public int getLineNumberForOffset(int offset) throws NoSuchMethodException {
        if (this.mapLineNumbers) {
            return this.contextStack.mapOffsetToLineNumber(offset);
        }
        throw new NoSuchMethodException();
    }

    public void setCppNature(boolean value) {
        this.cppNature = value;
    }

    public void mapLineNumbers(boolean value) {
        this.mapLineNumbers = value;
    }

    static {
        cppKeywords.put("and", new Integer(54));
        cppKeywords.put("and_eq", new Integer(55));
        cppKeywords.put("asm", new Integer(56));
        cppKeywords.put("auto", new Integer(57));
        cppKeywords.put("bitand", new Integer(58));
        cppKeywords.put("bitor", new Integer(59));
        cppKeywords.put("bool", new Integer(60));
        cppKeywords.put("break", new Integer(61));
        cppKeywords.put("case", new Integer(62));
        cppKeywords.put("catch", new Integer(63));
        cppKeywords.put("char", new Integer(64));
        cppKeywords.put("class", new Integer(65));
        cppKeywords.put("compl", new Integer(66));
        cppKeywords.put("const", new Integer(67));
        cppKeywords.put("const_cast", new Integer(69));
        cppKeywords.put("continue", new Integer(70));
        cppKeywords.put("default", new Integer(71));
        cppKeywords.put("delete", new Integer(72));
        cppKeywords.put("do", new Integer(73));
        cppKeywords.put("double", new Integer(74));
        cppKeywords.put("dynamic_cast", new Integer(75));
        cppKeywords.put("else", new Integer(76));
        cppKeywords.put("enum", new Integer(77));
        cppKeywords.put("explicit", new Integer(78));
        cppKeywords.put("export", new Integer(79));
        cppKeywords.put("extern", new Integer(80));
        cppKeywords.put("false", new Integer(81));
        cppKeywords.put("float", new Integer(82));
        cppKeywords.put("for", new Integer(83));
        cppKeywords.put("friend", new Integer(84));
        cppKeywords.put("goto", new Integer(85));
        cppKeywords.put("if", new Integer(86));
        cppKeywords.put("inline", new Integer(87));
        cppKeywords.put("int", new Integer(88));
        cppKeywords.put("long", new Integer(89));
        cppKeywords.put("mutable", new Integer(90));
        cppKeywords.put("namespace", new Integer(91));
        cppKeywords.put("new", new Integer(92));
        cppKeywords.put("not", new Integer(93));
        cppKeywords.put("not_eq", new Integer(94));
        cppKeywords.put("operator", new Integer(95));
        cppKeywords.put("or", new Integer(96));
        cppKeywords.put("or_eq", new Integer(97));
        cppKeywords.put("private", new Integer(98));
        cppKeywords.put("protected", new Integer(99));
        cppKeywords.put("public", new Integer(100));
        cppKeywords.put("register", new Integer(101));
        cppKeywords.put("reinterpret_cast", new Integer(102));
        cppKeywords.put("return", new Integer(103));
        cppKeywords.put("short", new Integer(104));
        cppKeywords.put("signed", new Integer(108));
        cppKeywords.put("sizeof", new Integer(105));
        cppKeywords.put("static", new Integer(106));
        cppKeywords.put("static_cast", new Integer(107));
        cppKeywords.put("struct", new Integer(109));
        cppKeywords.put("switch", new Integer(110));
        cppKeywords.put("template", new Integer(111));
        cppKeywords.put("this", new Integer(112));
        cppKeywords.put("throw", new Integer(113));
        cppKeywords.put("true", new Integer(114));
        cppKeywords.put("try", new Integer(115));
        cppKeywords.put("typedef", new Integer(116));
        cppKeywords.put("typeid", new Integer(117));
        cppKeywords.put("typename", new Integer(118));
        cppKeywords.put("union", new Integer(119));
        cppKeywords.put("unsigned", new Integer(120));
        cppKeywords.put("using", new Integer(121));
        cppKeywords.put("virtual", new Integer(122));
        cppKeywords.put("void", new Integer(123));
        cppKeywords.put("volatile", new Integer(124));
        cppKeywords.put("wchar_t", new Integer(125));
        cppKeywords.put("while", new Integer(126));
        cppKeywords.put("xor", new Integer(127));
        cppKeywords.put("xor_eq", new Integer(128));
        ppDirectives.put("#define", new Integer(0));
        ppDirectives.put("#undef", new Integer(1));
        ppDirectives.put("#if", new Integer(2));
        ppDirectives.put("#ifdef", new Integer(3));
        ppDirectives.put("#ifndef", new Integer(4));
        ppDirectives.put("#else", new Integer(5));
        ppDirectives.put("#endif", new Integer(6));
        ppDirectives.put("#include", new Integer(7));
        ppDirectives.put("#line", new Integer(8));
        ppDirectives.put("#error", new Integer(9));
        ppDirectives.put("#pragma", new Integer(10));
        ppDirectives.put("#elif", new Integer(12));
        ppDirectives.put("#", new Integer(11));
        cKeywords.put("auto", new Integer(57));
        cKeywords.put("break", new Integer(61));
        cKeywords.put("case", new Integer(62));
        cKeywords.put("char", new Integer(64));
        cKeywords.put("const", new Integer(67));
        cKeywords.put("continue", new Integer(70));
        cKeywords.put("default", new Integer(71));
        cKeywords.put("delete", new Integer(72));
        cKeywords.put("do", new Integer(73));
        cKeywords.put("double", new Integer(74));
        cKeywords.put("else", new Integer(76));
        cKeywords.put("enum", new Integer(77));
        cKeywords.put("extern", new Integer(80));
        cKeywords.put("float", new Integer(82));
        cKeywords.put("for", new Integer(83));
        cKeywords.put("goto", new Integer(85));
        cKeywords.put("if", new Integer(86));
        cKeywords.put("inline", new Integer(87));
        cKeywords.put("int", new Integer(88));
        cKeywords.put("long", new Integer(89));
        cKeywords.put("register", new Integer(101));
        cKeywords.put("restrict", new Integer(136));
        cKeywords.put("return", new Integer(103));
        cKeywords.put("short", new Integer(104));
        cKeywords.put("signed", new Integer(108));
        cKeywords.put("sizeof", new Integer(105));
        cKeywords.put("static", new Integer(106));
        cKeywords.put("struct", new Integer(109));
        cKeywords.put("switch", new Integer(110));
        cKeywords.put("typedef", new Integer(116));
        cKeywords.put("union", new Integer(119));
        cKeywords.put("unsigned", new Integer(120));
        cKeywords.put("void", new Integer(123));
        cKeywords.put("volatile", new Integer(124));
        cKeywords.put("while", new Integer(126));
        cKeywords.put("_Bool", new Integer(133));
        cKeywords.put("_Complex", new Integer(134));
        cKeywords.put("_Imaginary", new Integer(135));
    }

    public static class PreprocessorDirectives {
        public static final int DEFINE = 0;
        public static final int UNDEFINE = 1;
        public static final int IF = 2;
        public static final int IFDEF = 3;
        public static final int IFNDEF = 4;
        public static final int ELSE = 5;
        public static final int ENDIF = 6;
        public static final int INCLUDE = 7;
        public static final int LINE = 8;
        public static final int ERROR = 9;
        public static final int PRAGMA = 10;
        public static final int BLANK = 11;
        public static final int ELIF = 12;
    }
}

