/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.internal.core.parser.Declaration;
import org.eclipse.cdt.internal.core.parser.ParserSymbolTableException;

public class TypeInfo {
    public static final int typeMask = 31;
    public static final int isAuto = 32;
    public static final int isRegister = 64;
    public static final int isStatic = 128;
    public static final int isExtern = 256;
    public static final int isMutable = 512;
    public static final int isInline = 1024;
    public static final int isVirtual = 2048;
    public static final int isExplicit = 4096;
    public static final int isTypedef = 8192;
    public static final int isFriend = 16384;
    public static final int isConst = 32768;
    public static final int isVolatile = 65536;
    public static final int isUnsigned = 131072;
    public static final int isShort = 262144;
    public static final int isLong = 524288;
    public static final int t_undef = 0;
    public static final int t_type = 1;
    public static final int t_namespace = 2;
    public static final int t_class = 3;
    public static final int t_struct = 4;
    public static final int t_union = 5;
    public static final int t_enumeration = 6;
    public static final int t_function = 7;
    public static final int t_bool = 8;
    public static final int t_char = 9;
    public static final int t_wchar_t = 10;
    public static final int t_int = 11;
    public static final int t_float = 12;
    public static final int t_double = 13;
    public static final int t_void = 14;
    public static final int t_enumerator = 15;
    private static final String[] _image = new String[]{"", "", "namespace", "class", "struct", "union", "enum", "", "bool", "char", "wchar_t", "int", "float", "double", "void", ""};
    public static final int cvConst = 2;
    public static final int cvVolatile = 3;
    public static final int cvConstVolatile = 5;
    private int _typeInfo = 0;
    private Declaration _typeDeclaration;
    private int _cvQualifier = 0;
    private boolean _hasDefaultValue = false;
    private String _ptrOperator;

    public TypeInfo() {
    }

    public TypeInfo(int type, Declaration decl) {
        this._typeInfo = type;
        this._typeDeclaration = decl;
    }

    public TypeInfo(int type, Declaration decl, int cvQualifier, String ptrOp, boolean hasDefault) {
        this._typeInfo = type;
        this._typeDeclaration = decl;
        this._cvQualifier = cvQualifier;
        this._ptrOperator = ptrOp != null ? new String(ptrOp) : null;
        this._hasDefaultValue = hasDefault;
    }

    public TypeInfo(TypeInfo info) {
        this._typeInfo = info._typeInfo;
        this._typeDeclaration = info._typeDeclaration;
        this._cvQualifier = info._cvQualifier;
        this._ptrOperator = info._ptrOperator == null ? null : new String(info._ptrOperator);
        this._hasDefaultValue = info._hasDefaultValue;
    }

    public void setBit(boolean b, int mask) {
        this._typeInfo = b ? (this._typeInfo |= mask) : (this._typeInfo &= ~mask);
    }

    public boolean checkBit(int mask) {
        return (this._typeInfo & mask) != 0;
    }

    public void setType(int t) throws ParserSymbolTableException {
        if (t > 31) {
            throw new ParserSymbolTableException(1);
        }
        this._typeInfo = this._typeInfo & 0xFFFFFFE0 | t;
    }

    public int getType() {
        return this._typeInfo & 0x1F;
    }

    public boolean isType(int type) {
        return this.isType(type, 0);
    }

    public int getTypeInfo() {
        return this._typeInfo;
    }

    public void setTypeInfo(int typeInfo) {
        this._typeInfo = typeInfo;
    }

    public boolean isType(int type, int upperType) {
        if (type == -1) {
            return true;
        }
        if (upperType == 0) {
            return this.getType() == type;
        }
        return this.getType() >= type && this.getType() <= upperType;
    }

    public Declaration getTypeDeclaration() {
        return this._typeDeclaration;
    }

    public void setTypeDeclaration(Declaration type) {
        this._typeDeclaration = type;
    }

    public int getCVQualifier() {
        return this._cvQualifier;
    }

    public void setCVQualifier(int cv) {
        this._cvQualifier = cv;
    }

    public void addCVQualifier(int cv) {
        switch (this._cvQualifier) {
            case 0: {
                this._cvQualifier = cv;
                break;
            }
            case 2: {
                if (cv == 2) break;
                this._cvQualifier = 5;
                break;
            }
            case 3: {
                if (cv == 3) break;
                this._cvQualifier = 5;
                break;
            }
        }
    }

    public String getPtrOperator() {
        return this._ptrOperator;
    }

    public void setPtrOperator(String ptr) {
        this._ptrOperator = ptr;
    }

    public void addPtrOperator(String ptr) {
        if (ptr == null) {
            return;
        }
        char[] chars = this._ptrOperator == null ? ptr.toCharArray() : (ptr + this._ptrOperator).toCharArray();
        int nChars = this._ptrOperator == null ? ptr.length() : ptr.length() + this._ptrOperator.length();
        char[] dest = new char[nChars];
        int j = 0;
        int i = 0;
        while (i < nChars) {
            int currChar = chars[i];
            int nextChar = i + 1 < nChars ? chars[i + 1] : 0;
            block0 : switch (currChar) {
                case 38: {
                    switch (nextChar) {
                        case 91: {
                            char tempChar;
                            char c = tempChar = i + 2 < nChars ? chars[i + 2] : (char)'\u0000';
                            if (tempChar == ']') {
                                ++i;
                                nextChar = 42;
                            }
                        }
                        case 42: {
                            ++i;
                            break block0;
                        }
                    }
                    dest[j++] = currChar;
                    break;
                }
                case 91: {
                    if (nextChar == 93) {
                        currChar = 42;
                        nextChar = ++i + 2 < nChars ? chars[i + 2] : 0;
                    }
                }
                case 42: {
                    if (nextChar == 38) {
                        ++i;
                        break;
                    }
                    dest[j++] = currChar;
                    break;
                }
            }
            ++i;
        }
        this._ptrOperator = new String(dest, 0, j);
    }

    public String getInvertedPtrOperator() {
        if (this._ptrOperator == null) {
            return null;
        }
        char[] chars = this._ptrOperator.toCharArray();
        int nChars = this._ptrOperator.length();
        char[] dest = new char[nChars];
        int i = 0;
        while (i < nChars) {
            char currChar = chars[i];
            switch (currChar) {
                case '*': {
                    dest[i] = 38;
                    break;
                }
                case '&': {
                    dest[i] = 42;
                    break;
                }
                default: {
                    dest[i] = currChar;
                }
            }
            ++i;
        }
        return new String(dest);
    }

    public boolean getHasDefault() {
        return this._hasDefaultValue;
    }

    public void setHasDefault(boolean def) {
        this._hasDefaultValue = def;
    }

    public boolean canHold(TypeInfo type) {
        return this.getType() >= type.getType();
    }

    public boolean equals(Object t) {
        if (t == null || !(t instanceof TypeInfo)) {
            return false;
        }
        TypeInfo type = (TypeInfo)t;
        boolean result = this._typeInfo == type._typeInfo;
        result &= this._typeDeclaration == type._typeDeclaration;
        result &= this._cvQualifier == type._cvQualifier;
        String op1 = this._ptrOperator != null && this._ptrOperator.equals("") ? null : this._ptrOperator;
        String op2 = type._ptrOperator != null && type._ptrOperator.equals("") ? null : type._ptrOperator;
        return result &= op1 != null && op2 != null && op1.equals(op2) || op1 == op2;
    }

    public String toString() {
        if (this.isType(1)) {
            return this._typeDeclaration.getName();
        }
        return _image[this.getType()];
    }
}

