/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.SymbolSortCompare;

public class ElfHelper {
    private Elf elf;
    private Elf.ELFhdr hdr;
    private Elf.Attribute attrib;
    private Elf.Symbol[] dynsyms;
    private Elf.Symbol[] symbols;
    private Elf.Section[] sections;
    private Elf.Dynamic[] dynamics;

    public void dispose() {
        if (this.elf != null) {
            this.elf.dispose();
            this.elf = null;
        }
    }

    private void loadSymbols() throws IOException {
        if (this.symbols == null) {
            this.elf.loadSymbols();
            this.symbols = this.elf.getSymtabSymbols();
            this.dynsyms = this.elf.getDynamicSymbols();
            if (this.symbols.length <= 0) {
                this.symbols = this.dynsyms;
            }
            if (this.dynsyms.length <= 0) {
                this.dynsyms = this.symbols;
            }
        }
    }

    private void loadSections() throws IOException {
        if (this.sections == null) {
            this.sections = this.elf.getSections();
        }
    }

    private void loadDynamics() throws IOException {
        this.loadSections();
        if (this.dynamics == null) {
            this.dynamics = new Elf.Dynamic[0];
            int i = 0;
            while (i < this.sections.length) {
                if (this.sections[i].sh_type == 6L) {
                    this.dynamics = this.elf.getDynamicSections(this.sections[i]);
                    break;
                }
                ++i;
            }
        }
    }

    private void commonSetup() throws IOException {
        this.hdr = this.elf.getELFhdr();
        this.attrib = this.elf.getAttributes();
    }

    public ElfHelper(Elf elf) throws IOException {
        this.elf = elf;
        this.commonSetup();
    }

    public ElfHelper(String filename) throws IOException {
        this.elf = new Elf(filename);
        this.commonSetup();
    }

    public ElfHelper(String filename, boolean filton) throws IOException {
        this.elf = new Elf(filename, filton);
        this.commonSetup();
    }

    public Elf getElf() {
        return this.elf;
    }

    public Elf.Symbol[] getExternalFunctions() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int i = 0;
        while (i < this.dynsyms.length) {
            short idx;
            if (this.dynsyms[i].st_bind() == 1 && this.dynsyms[i].st_type() == 2 && (idx = this.dynsyms[i].st_shndx) >= 0 && this.sections[idx].sh_type == 0L) {
                v.add(this.dynsyms[i]);
            }
            ++i;
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[0]);
        Arrays.sort(ret, new SymbolSortCompare());
        return ret;
    }

    public Elf.Symbol[] getExternalObjects() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int i = 0;
        while (i < this.dynsyms.length) {
            short idx;
            if (this.dynsyms[i].st_bind() == 1 && this.dynsyms[i].st_type() == 1 && (idx = this.dynsyms[i].st_shndx) >= 0 && this.sections[idx].sh_type == 0L) {
                v.add(this.dynsyms[i]);
            }
            ++i;
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[0]);
        Arrays.sort(ret, new SymbolSortCompare());
        return ret;
    }

    public Elf.Symbol[] getUndefined() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        int i = 0;
        while (i < this.dynsyms.length) {
            if (this.dynsyms[i].st_shndx == 0) {
                v.add(this.dynsyms[i]);
            }
            ++i;
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[0]);
        Arrays.sort(ret, new SymbolSortCompare());
        return ret;
    }

    public Elf.Symbol[] getLocalFunctions() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int i = 0;
        while (i < this.symbols.length) {
            short idx;
            if (this.symbols[i].st_bind() == 1 && this.symbols[i].st_type() == 2 && (idx = this.symbols[i].st_shndx) >= 0 && this.sections[idx].sh_type != 0L) {
                v.add(this.symbols[i]);
            }
            ++i;
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[0]);
        Arrays.sort(ret, new SymbolSortCompare());
        return ret;
    }

    public Elf.Symbol[] getLocalObjects() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int i = 0;
        while (i < this.symbols.length) {
            short idx;
            if (this.symbols[i].st_bind() == 1 && this.symbols[i].st_type() == 1 && (idx = this.symbols[i].st_shndx) >= 0 && this.sections[idx].sh_type != 0L) {
                v.add(this.symbols[i]);
            }
            ++i;
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[0]);
        Arrays.sort(ret, new SymbolSortCompare());
        return ret;
    }

    public Elf.Symbol[] getCommonObjects() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        int i = 0;
        while (i < this.symbols.length) {
            short idx;
            if (this.symbols[i].st_bind() == 1 && this.symbols[i].st_type() == 1 && (idx = this.symbols[i].st_shndx) == -14) {
                v.add(this.symbols[i]);
            }
            ++i;
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[0]);
        Arrays.sort(ret, new SymbolSortCompare());
        return ret;
    }

    public Elf.Dynamic[] getNeeded() throws IOException {
        Vector<Elf.Dynamic> v = new Vector<Elf.Dynamic>();
        this.loadDynamics();
        int i = 0;
        while (i < this.dynamics.length) {
            if (this.dynamics[i].d_tag == 1L) {
                v.add(this.dynamics[i]);
            }
            ++i;
        }
        return v.toArray(new Elf.Dynamic[0]);
    }

    public String getSoname() throws IOException {
        String soname = "";
        this.loadDynamics();
        int i = 0;
        while (i < this.dynamics.length) {
            if (this.dynamics[i].d_tag == 14L) {
                soname = this.dynamics[i].toString();
            }
            ++i;
        }
        return soname;
    }

    private String getSubUsage(String full, String name) {
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < full.length()) {
            if (full.charAt(i) == '%' && full.charAt(i + 1) == '-') {
                if (start == 0) {
                    int eol = full.indexOf(10, i + 2);
                    String temp = full.substring(i + 2, eol);
                    if (temp.compareTo(name) == 0) {
                        start = eol;
                    }
                } else if (end == 0) {
                    end = i - 1;
                }
            }
            ++i;
        }
        if (end == 0) {
            end = full.length();
        }
        if (start == 0) {
            return full;
        }
        return full.substring(start, end);
    }

    public String getQnxUsage() throws IOException {
        this.loadSections();
        int i = 0;
        while (i < this.sections.length) {
            if (this.sections[i].toString().compareTo("QNX_usage") == 0) {
                File file = new File(this.elf.getFilename());
                String full_usage = new String(this.sections[i].loadSectionData());
                String usage = this.getSubUsage(full_usage, file.getName());
                StringBuffer buffer = new StringBuffer(usage);
                int j = 0;
                while (j < buffer.length()) {
                    if (buffer.charAt(j) == '%' && buffer.charAt(j + 1) == 'C') {
                        buffer.replace(j, j + 2, file.getName());
                    }
                    ++j;
                }
                return buffer.toString();
            }
            ++i;
        }
        return new String("");
    }

    public Sizes getSizes() throws IOException {
        long text = 0L;
        long data = 0L;
        long bss = 0L;
        this.loadSections();
        int i = 0;
        while (i < this.sections.length) {
            if (this.sections[i].sh_type != 8L) {
                if (this.sections[i].sh_flags == 3L) {
                    data += this.sections[i].sh_size;
                } else if ((this.sections[i].sh_flags & 2L) != 0L) {
                    text += this.sections[i].sh_size;
                }
            } else if (this.sections[i].sh_flags == 3L) {
                bss += this.sections[i].sh_size;
            }
            ++i;
        }
        return new Sizes(text, data, bss);
    }

    public class Sizes {
        public long text;
        public long data;
        public long bss;
        public long total;

        public Sizes(long t, long d, long b) {
            this.text = t;
            this.data = d;
            this.bss = b;
            this.total = this.text + this.data + this.bss;
        }
    }
}

