/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.internal.core.index.CTagsCmd;
import org.eclipse.cdt.internal.core.index.IndexManager;
import org.eclipse.cdt.internal.core.index.RequestList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class CTagsRunner
implements Runnable {
    IndexManager manager;

    public CTagsRunner(IndexManager indexManager) {
        this.manager = indexManager;
    }

    public void run() {
        IndexManager.delay();
        block8: while (true) {
            IResource resource = null;
            RequestList requestList = this.manager.getRequestList();
            try {
                resource = requestList.removeItem();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (resource == null) continue;
            switch (resource.getType()) {
                case 1: {
                    IProject project = resource.getProject();
                    Map projectsMap = this.manager.getProjectsMap();
                    Map filesMap = (Map)projectsMap.get(project.getLocation());
                    if (filesMap == null) {
                        Map m = Collections.synchronizedMap(new HashMap());
                        projectsMap.put(project.getLocation(), m);
                        this.manager.addContainer((IContainer)project);
                        break;
                    }
                    try {
                        CTagsCmd cmd = new CTagsCmd();
                        IFile file = (IFile)resource;
                        String location = file.getLocation().toOSString();
                        ITagEntry[] entries = cmd.getTagEntries(file, location);
                        filesMap.put(resource.getLocation(), entries);
                    }
                    catch (IOException e) {}
                    continue block8;
                }
                case 2: 
                case 4: {
                    System.out.println("Can not index folders " + resource.getName());
                }
            }
        }
    }
}

