/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public abstract class AbstractCLaunchDelegate
implements ILaunchConfigurationDelegate {
    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected String[] getEnvironmentArray(ILaunchConfiguration config) {
        return null;
    }

    protected Properties getEnvironmentProperty(ILaunchConfiguration config) {
        Properties prop = new Properties();
        Map env = null;
        try {
            env = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_MAP, (Map)null);
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (env == null) {
            return prop;
        }
        Iterator entries = env.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            prop.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return prop;
    }

    protected File getWorkingDir(ILaunchConfiguration config) throws CoreException {
        String path = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, (String)null);
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort("Specified working directory does not exist or is not a directory", null, 101);
        }
        return dir;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        String newMessage = message;
        if (exception != null) {
            newMessage = message + " : " + exception.getLocalizedMessage();
        }
        throw new CoreException((IStatus)new Status(4, this.getPluginID(), code, newMessage, exception));
    }

    protected void cancel(String message, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(0, this.getPluginID(), code, message, null));
    }

    protected abstract String getPluginID();

    public ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = this.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    public String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
    }

    public String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_NAME, (String)null);
    }

    public String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, (String)null);
    }

    public String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return AbstractCLaunchDelegate.parseArguments(this.getProgramArguments(config));
    }

    private static String[] parseArguments(String args) {
        if (args == null) {
            return new String[0];
        }
        ArgumentParser parser = new ArgumentParser(args);
        String[] res = parser.parseArguments();
        return res;
    }

    protected ICDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        ICDebugConfiguration dbgCfg = null;
        try {
            dbgCfg = CDebugCorePlugin.getDefault().getDebugConfiguration(config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, ""));
        }
        catch (CoreException e) {
            Object result;
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 106, "CDT Debubger not installed", (Throwable)e);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (handler == null || (result = handler.handleStatus((IStatus)status, (Object)this)) instanceof String) {
                // empty if block
            }
            throw e;
        }
        return dbgCfg;
    }

    protected String renderTargetLabel(ICDebugConfiguration debugConfig) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, debugConfig.getName(), timestamp);
    }

    protected String renderProcessLabel(String commandLine) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine, timestamp);
    }

    protected ICProject verifyCProject(ILaunchConfiguration config) throws CoreException {
        ICProject project;
        String name = this.getProjectName(config);
        if (name == null) {
            this.abort("C project not specified", null, 102);
        }
        if ((project = this.getCProject(config)) == null) {
            this.abort("Project does not exist or is not a C/C++ project", null, 103);
        }
        return project;
    }

    protected IPath verifyProgramFile(ILaunchConfiguration config) throws CoreException {
        IFile projectPath;
        ICProject cproject = this.verifyCProject(config);
        String fileName = this.getProgramName(config);
        if (fileName == null) {
            this.abort("Program file not specified", null, 105);
        }
        if ((projectPath = ((IProject)cproject.getResource()).getFile(fileName)) == null || !projectPath.exists()) {
            this.abort("Program file does not exist", null, 104);
        }
        return projectPath.getLocation();
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.fArgs = args;
        }

        /*
         * Unable to fully structure code
         */
        public String[] parseArguments() {
            v = new ArrayList<String>();
            this.ch = this.getNext();
            ** GOTO lbl13
            {
                this.ch = this.getNext();
                do {
                    if (Character.isWhitespace((char)this.ch)) continue block0;
                    if (this.ch == 34) {
                        v.add(this.parseString());
                        continue;
                    }
                    v.add(this.parseToken());
lbl13:
                    // 3 sources

                } while (this.ch > 0);
            }
            result = new String[v.size()];
            v.toArray(result);
            return result;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            StringBuffer buf = new StringBuffer();
            this.ch = this.getNext();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }
}

