/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.Format;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataListRegisterValues;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteRegisterValues;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataListRegisterValuesInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIRegisterValue;

public class Register
extends CObject
implements ICDIRegister,
ICDIValue {
    RegisterObject regObject;
    int format = 0;
    Register parent;
    String lastname;

    public Register(CTarget target, ICDIRegisterObject r) {
        super(target);
        this.parent = null;
        this.lastname = r.getName();
        this.regObject = (RegisterObject)r;
    }

    public Register(Register p, String n) {
        super(p.getCTarget());
        this.parent = p;
        this.lastname = n;
    }

    public int getId() {
        return this.regObject.getId();
    }

    public String getUniqName() {
        String n = "";
        n = this.parent != null ? this.parent.getUniqName() + "." + this.getLastName() : this.getLastName();
        return n;
    }

    public String getBaseName() {
        String base = "";
        base = this.parent != null ? this.parent.getBaseName() : this.getLastName();
        return base;
    }

    public String getLastName() {
        return this.lastname;
    }

    public String getName() throws CDIException {
        return this.getLastName();
    }

    public String getTypeName() throws CDIException {
        String v = this.getValueString();
        if (v.startsWith("{")) {
            return "struct ";
        }
        return "int";
    }

    public ICDIValue getValue() throws CDIException {
        return this;
    }

    public String getValueString() throws CDIException {
        if (this.parent == null) {
            MISession mi = this.getCTarget().getCSession().getMISession();
            CommandFactory factory = mi.getCommandFactory();
            int[] regno = new int[]{this.regObject.getId()};
            MIDataListRegisterValues registers = factory.createMIDataListRegisterValues(this.format, regno);
            try {
                mi.postCommand(registers);
                MIDataListRegisterValuesInfo info = registers.getMIDataListRegisterValuesInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                MIRegisterValue[] regValues = info.getMIRegisterValues();
                int i = 0;
                while (i < regValues.length) {
                    if (regValues[i].getNumber() == regno[i]) {
                        return regValues[i].getValue();
                    }
                    ++i;
                }
            }
            catch (MIException e) {
                throw new CDIException(e.getMessage());
            }
        } else {
            String u = this.getUniqName();
            String v = this.parent.getValueString();
            Argument[] args = this.parse(this.parent.getUniqName(), v);
            int i = 0;
            while (i < args.length) {
                if (u.equals(args[i].getKey())) {
                    return args[i].getValue();
                }
                ++i;
            }
        }
        return "";
    }

    public boolean isEditable() throws CDIException {
        return false;
    }

    public void setValue(ICDIValue val) throws CDIException {
        this.setValue(val.getValueString());
    }

    public void setValue(String expression) throws CDIException {
        MISession mi = this.getCTarget().getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        int[] regnos = new int[]{this.regObject.getId()};
        String[] values = new String[]{expression};
        MIDataWriteRegisterValues registers = factory.createMIDataWriteRegisterValues(this.format, regnos, values);
        try {
            mi.postCommand(registers);
            MIInfo info = registers.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
        MIRegisterChangedEvent change = new MIRegisterChangedEvent(registers.getToken(), this.regObject.getName(), this.regObject.getId());
        mi.fireEvent(change);
    }

    public void setFormat(int format) throws CDIException {
        format = Format.toMIFormat(format);
    }

    public int getChildrenNumber() throws CDIException {
        return this.getVariables().length;
    }

    public ICDIVariable[] getVariables() throws CDIException {
        ArrayList<Register> aList = new ArrayList<Register>(1);
        String v = this.getValueString();
        Argument[] args = this.parse(this.getUniqName(), v);
        int i = 0;
        while (i < args.length) {
            String p;
            StringTokenizer st;
            String u;
            String n = args[i].getKey();
            if (n.startsWith(u = this.getUniqName()) && n.length() > u.length() && (st = new StringTokenizer(p = n.substring(u.length()), ".")).countTokens() == 1) {
                aList.add(new Register(this, (String)st.nextElement()));
            }
            ++i;
        }
        return aList.toArray(new ICDIVariable[0]);
    }

    public boolean hasChildren() throws CDIException {
        return this.getChildrenNumber() > 0;
    }

    Argument[] parse(String base, String v) throws CDIException {
        ArrayList<Argument> aList = new ArrayList<Argument>(1);
        StringBuffer sb = new StringBuffer(base);
        aList.add(new Argument(sb.toString(), v.trim()));
        while (v.startsWith("{")) {
            int idx;
            if ((v = v.substring(1)).endsWith("}")) {
                idx = v.lastIndexOf(125);
                v = v.substring(0, idx);
            }
            if ((idx = v.indexOf(61)) != -1) {
                String n = v.substring(0, idx).trim();
                sb.append('.').append(n);
                v = v.substring(idx + 1).trim();
                aList.add(new Argument(sb.toString(), v));
                continue;
            }
            StringTokenizer st = new StringTokenizer(v, ",");
            int i = 0;
            while (st.hasMoreElements()) {
                aList.add(new Argument(sb.toString() + "." + Integer.toString(i), ((String)st.nextElement()).trim()));
                ++i;
            }
        }
        return aList.toArray(new Argument[0]);
    }

    class Argument {
        String name;
        String val;

        Argument(String n, String v) {
            this.name = n;
            this.val = v;
        }

        String getKey() {
            return this.name;
        }

        String getValue() {
            return this.val;
        }
    }
}

