/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Argument;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.CThread;
import org.eclipse.cdt.debug.mi.core.cdi.Expression;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class VariableManager
extends SessionObject
implements ICDIExpressionManager {
    List elementList = new ArrayList();
    List oosList = new ArrayList();

    public VariableManager(CSession session) {
        super(session);
    }

    Element getElement(String varName) {
        Element[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].miVar.getVarName().equals(varName)) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    Element getElement(StackFrame stack, String name) {
        Element[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].name.equals(name) && elements[i].stackframe.equals(stack)) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    void addElement(Element element) {
        Element[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            String name = elements[i].miVar.getVarName();
            if (name.equals(element.miVar.getVarName())) {
                return;
            }
            ++i;
        }
        this.elementList.add(element);
    }

    Element[] getElements() {
        return this.elementList.toArray(new Element[0]);
    }

    void update() throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarUpdate update = factory.createMIVarUpdate();
        try {
            mi.postCommand(update);
            MIVarUpdateInfo info = update.getMIVarUpdateInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            MIVarChange[] changes = info.getMIVarChanges();
            ArrayList<MIVarChangedEvent> eventList = new ArrayList<MIVarChangedEvent>(changes.length);
            int i = 0;
            while (i < changes.length) {
                String varName = changes[i].getVarName();
                Element element = this.getElement(varName);
                if (element != null) {
                    eventList.add(new MIVarChangedEvent(update.getToken(), varName, changes[i].isInScope()));
                }
                if (!changes[i].isInScope() && !(element.variable instanceof Expression)) {
                    this.removeElement(changes[i]);
                }
                ++i;
            }
            MIEvent[] events = eventList.toArray(new MIEvent[0]);
            mi.fireEvents(events);
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    Element createElement(StackFrame stack, String name) throws CDIException {
        Element element = this.getElement(stack, name);
        if (element == null) {
            MISession mi = this.getCSession().getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarCreate var = factory.createMIVarCreate(name);
            try {
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                element = new Element();
                element.miVar = info.getMIVar();
                element.name = name;
                element.stackframe = stack;
            }
            catch (MIException e) {
                throw new CDIException(e.getMessage());
            }
        }
        return element;
    }

    Element removeOutOfScope(String varName) {
        Element[] oos = this.oosList.toArray(new Element[0]);
        int i = 0;
        while (i < oos.length) {
            if (oos[i].miVar.getVarName().equals(varName)) {
                return oos[i];
            }
            ++i;
        }
        return null;
    }

    void removeMIVar(MIVar miVar) throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            mi.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    void removeElement(String varName) throws CDIException {
        Element[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].miVar.getVarName().equals(varName)) {
                this.elementList.remove(elements[i]);
                this.oosList.add(elements[i]);
                this.removeMIVar(elements[i].miVar);
            }
            ++i;
        }
    }

    void removeElement(MIVarChange changed) throws CDIException {
        String varName = changed.getVarName();
        this.removeElement(varName);
    }

    void removeElement(Variable variable) throws CDIException {
        String varName = variable.getMIVar().getVarName();
        this.removeElement(varName);
    }

    void removeElements(Variable[] variables) throws CDIException {
        int i = 0;
        while (i < variables.length) {
            this.removeElement(variables[i]);
            ++i;
        }
    }

    ICDIVariable createVariable(StackFrame stack, String name) throws CDIException {
        Variable var;
        Element element = this.createElement(stack, name);
        if (element.variable != null) {
            var = element.variable;
        } else {
            element.variable = var = new Variable(stack, name, element.miVar);
            this.addElement(element);
        }
        return var;
    }

    Variable createVariable(StackFrame stack, String name, MIVar miVar) throws CDIException {
        Variable var;
        Element element = new Element();
        element.miVar = miVar;
        element.name = name;
        element.stackframe = stack;
        element.variable = var = new Variable(stack, name, miVar);
        this.addElement(element);
        return var;
    }

    ICDIArgument createArgument(StackFrame stack, String name) throws CDIException {
        Argument carg;
        Element element = this.createElement(stack, name);
        if (element.variable != null && element.variable instanceof Argument) {
            carg = (Argument)element.variable;
        } else {
            carg = new Argument(stack, name, element.miVar);
            element.variable = carg;
            this.addElement(element);
        }
        return carg;
    }

    ICDIExpression createExpression(StackFrame stack, String name) throws CDIException {
        Expression cexp;
        Element element = this.createElement(stack, name);
        if (element.variable != null && element.variable instanceof Expression) {
            cexp = (Expression)element.variable;
        } else {
            cexp = new Expression(stack, name, element.miVar);
            element.variable = cexp;
            this.addElement(element);
        }
        return cexp;
    }

    public ICDIExpression createExpression(String name) throws CDIException {
        CTarget target = this.getCSession().getCTarget();
        StackFrame frame = ((CThread)target.getCurrentThread()).getCurrentStackFrame();
        return this.createExpression(frame, name);
    }

    public ICDIExpression[] getExpressions() throws CDIException {
        Element[] elements = this.getElements();
        ArrayList<Variable> aList = new ArrayList<Variable>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i].variable instanceof ICDIExpression) {
                aList.add(elements[i].variable);
            }
            ++i;
        }
        return aList.toArray(new ICDIExpression[0]);
    }

    public void removeExpression(ICDIExpression expression) throws CDIException {
        if (expression instanceof Variable) {
            this.removeElement((Variable)expression);
        }
    }

    public void removeExpressions(ICDIExpression[] expressions) throws CDIException {
        int i = 0;
        while (i < expressions.length) {
            this.removeExpression(expressions[i]);
            ++i;
        }
    }

    class Element {
        MIVar miVar;
        String name;
        StackFrame stackframe;
        Variable variable;

        Element() {
        }
    }
}

