/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakPoint {
    int number;
    String type = "";
    String disp = "";
    boolean enabled;
    long address;
    String func = "";
    String file = "";
    int line;
    String cond = "";
    int times;
    String what = "";
    String threadId = "";
    int ignore;
    boolean isWpt;
    boolean isAWpt;
    boolean isRWpt;

    public MIBreakPoint(MITuple tuple) {
        this.parse(tuple);
    }

    public int getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public boolean isHardware() {
        return this.getType().startsWith("hw") || this.isWatchpoint();
    }

    public boolean isTemporary() {
        return this.getDisposition().equals("del");
    }

    public boolean isWatchpoint() {
        return this.isWpt;
    }

    public void setWatcpoint(boolean w) {
        this.isWpt = w;
    }

    public boolean isAccessWatchpoint() {
        return this.isAWpt;
    }

    public void setAccessWatchpoint(boolean a) {
        this.isWpt = a;
        this.isAWpt = a;
    }

    public boolean isReadWatchpoint() {
        return this.isRWpt;
    }

    public void setReadWatchpoint(boolean r) {
        this.isWpt = r;
        this.isRWpt = r;
    }

    public String getDisposition() {
        return this.disp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public long getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.func;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getTimes() {
        return this.times;
    }

    public String getWhat() {
        return this.what;
    }

    public int getIgnoreCount() {
        return this.ignore;
    }

    public String getCondition() {
        return this.cond;
    }

    public String getThreadId() {
        return this.threadId;
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("number")) {
                try {
                    this.number = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("type")) {
                this.type = str;
            } else if (var.equals("disp")) {
                this.disp = str;
            } else if (var.equals("enabled")) {
                this.enabled = str.equals("y");
            } else if (var.equals("addr")) {
                try {
                    this.address = Long.decode(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("func")) {
                this.func = str;
            } else if (var.equals("file")) {
                this.file = str;
            } else if (var.equals("thread")) {
                this.threadId = str;
            } else if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("times")) {
                try {
                    this.times = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("what") || var.equals("exp")) {
                this.what = str;
            } else if (var.equals("ignore")) {
                try {
                    this.ignore = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("cond")) {
                this.cond = str;
            }
            ++i;
        }
    }
}

