/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIAsm;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MISrcAsm {
    int line;
    String file = "";
    MIAsm[] asm;

    public MISrcAsm(MITuple tuple) {
        this.parse(tuple);
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public MIAsm[] getMIAsms() {
        return this.asm;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("src_and_asm_line={");
        buffer.append("line=\"").append(this.line).append('\"');
        buffer.append(",file=\"" + this.file + "\",");
        buffer.append("line_asm_insn=[");
        int i = 0;
        while (i < this.asm.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append(this.asm[i].toString());
            ++i;
        }
        buffer.append(']');
        buffer.append('}');
        return buffer.toString();
    }

    void parse(MITuple tuple) {
        ArrayList<MIAsm> aList = new ArrayList<MIAsm>();
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("line_asm_insn") && value instanceof MIList) {
                MIList list = (MIList)value;
                MIValue[] values = list.getMIValues();
                int j = 0;
                while (j < values.length) {
                    if (values[j] instanceof MITuple) {
                        aList.add(new MIAsm((MITuple)values[j]));
                    }
                    ++j;
                }
            }
            if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
            } else if (var.equals("file")) {
                this.file = str;
            }
            ++i;
        }
        this.asm = aList.toArray(new MIAsm[aList.size()]);
    }
}

