/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.ResourcePropertySource;

public class BinaryPropertySource
extends FilePropertySource {
    private static final String ELF_CPU = "CElementProperties.elf_cpu";
    private static final String ELF_TEXT = "CElementProperties.elf_text";
    private static final String ELF_DATA = "CElementProperties.elf_data";
    private static final String ELF_BSS = "CElementProperties.elf_bss";
    private static final String ELF_TYPE = "CElementProperties.elf_type";
    private static final String ELF_HAS_DEBUG = "CElementProperties.elf_has_debug";
    private static final String ELF_SONAME = "CElementProperties.elf_soname";
    private static final String ELF_NEEDED = "CElementProperties.elf_needed";
    private IBinary binary;
    private static IPropertyDescriptor[] fgPropertyDescriptors;

    private static IPropertyDescriptor[] getInitialPropertyDescriptor() {
        String cpuName = CUIPlugin.getResourceString(ELF_CPU);
        PropertyDescriptor cpuDescriptor = new PropertyDescriptor((Object)"elf_cpu", cpuName);
        cpuDescriptor.setAlwaysIncompatible(true);
        String textName = CUIPlugin.getResourceString(ELF_TEXT);
        PropertyDescriptor textDescriptor = new PropertyDescriptor((Object)"text", textName);
        textDescriptor.setAlwaysIncompatible(true);
        String dataName = CUIPlugin.getResourceString(ELF_DATA);
        PropertyDescriptor dataDescriptor = new PropertyDescriptor((Object)"data", dataName);
        dataDescriptor.setAlwaysIncompatible(true);
        String bssName = CUIPlugin.getResourceString(ELF_BSS);
        PropertyDescriptor bssDescriptor = new PropertyDescriptor((Object)"bss", bssName);
        bssDescriptor.setAlwaysIncompatible(true);
        String typeName = CUIPlugin.getResourceString(ELF_TYPE);
        PropertyDescriptor typeDescriptor = new PropertyDescriptor((Object)"type", typeName);
        bssDescriptor.setAlwaysIncompatible(true);
        String neededName = CUIPlugin.getResourceString(ELF_NEEDED);
        PropertyDescriptor neededDescriptor = new PropertyDescriptor((Object)"needed", neededName);
        bssDescriptor.setAlwaysIncompatible(true);
        String sonameName = CUIPlugin.getResourceString(ELF_SONAME);
        PropertyDescriptor sonameDescriptor = new PropertyDescriptor((Object)"soname", sonameName);
        bssDescriptor.setAlwaysIncompatible(true);
        String debugName = CUIPlugin.getResourceString(ELF_HAS_DEBUG);
        PropertyDescriptor debugDescriptor = new PropertyDescriptor((Object)"debug", debugName);
        bssDescriptor.setAlwaysIncompatible(true);
        return new IPropertyDescriptor[]{cpuDescriptor, textDescriptor, dataDescriptor, bssDescriptor, typeDescriptor, sonameDescriptor, debugDescriptor, neededDescriptor};
    }

    public BinaryPropertySource(IBinary bin) {
        super(bin.getFile());
        this.binary = bin;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (fgPropertyDescriptors == null) {
            this.initializeBinaryDescriptors();
        }
        return fgPropertyDescriptors;
    }

    public Object getPropertyValue(Object name) {
        Object returnValue;
        if (((ResourcePropertySource)this).element != null && (returnValue = super.getPropertyValue(name)) != null) {
            return returnValue;
        }
        if (name.equals("elf_cpu")) {
            return this.binary.getCPU();
        }
        if (name.equals("text")) {
            return Long.toString(this.binary.getText());
        }
        if (name.equals("data")) {
            return Long.toString(this.binary.getData());
        }
        if (name.equals("bss")) {
            return Long.toString(this.binary.getBSS());
        }
        if (name.equals("soname")) {
            return this.binary.getSoname();
        }
        if (name.equals("debug")) {
            if (this.binary.hasDebug()) {
                return "true";
            }
            return "false";
        }
        if (name.equals("needed")) {
            String[] needed = this.binary.getNeededSharedLibs();
            String need = "";
            int i = 0;
            while (i < needed.length) {
                need = need + " " + needed[i];
                ++i;
            }
            return need.trim();
        }
        if (name.equals("type")) {
            if (this.binary.isObject()) {
                return "object";
            }
            if (this.binary.isExecutable()) {
                return "executable";
            }
            if (this.binary.isSharedLib()) {
                return "shared library";
            }
        }
        return null;
    }

    private void initializeBinaryDescriptors() {
        IPropertyDescriptor[] superDescriptors = super.getPropertyDescriptors();
        int superLength = superDescriptors.length;
        IPropertyDescriptor[] binDescriptors = BinaryPropertySource.getInitialPropertyDescriptor();
        int binLength = binDescriptors.length;
        fgPropertyDescriptors = new IPropertyDescriptor[superLength + binLength];
        System.arraycopy(superDescriptors, 0, fgPropertyDescriptors, 0, superLength);
        System.arraycopy(binDescriptors, 0, fgPropertyDescriptors, superLength, binLength);
    }
}

