/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.core.index.IndexModel;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.CElementLabelProvider;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.ICCompletionProposal;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class CCompletionProcessor
implements IContentAssistProcessor {
    private CEditor fEditor;
    private char[] fProposalAutoActivationSet;
    private CCompletionProposalComparator fComparator;
    private TemplateEngine fTemplateEngine;
    private boolean fRestrictToMatchingCase;
    private boolean fAllowAddIncludes;
    private CElementLabelProvider fElementLabelProvider;

    public CCompletionProcessor(IEditorPart editor) {
        this.fEditor = (CEditor)editor;
        ContextType contextType = ContextTypeRegistry.getInstance().getContextType("C");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fRestrictToMatchingCase = false;
        this.fAllowAddIncludes = true;
        this.fComparator = new CCompletionProposalComparator();
        this.fElementLabelProvider = new CElementLabelProvider();
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void allowAddingIncludes(boolean allowAddingIncludes) {
        this.fAllowAddIncludes = allowAddingIncludes;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IDocument document = viewer.getDocument();
        ICompletionProposal[] results = null;
        try {
            if (document != null) {
                int offset = documentOffset;
                int length = 0;
                Point selection = viewer.getSelectedRange();
                if (selection.y > 0) {
                    offset = selection.x;
                    length = selection.y;
                }
                results = this.evalProposals(document, offset, length);
            }
        }
        catch (Exception e) {
            CUIPlugin.log(e);
        }
        if (results == null) {
            results = new ICCompletionProposal[]{};
        }
        if (this.fTemplateEngine != null) {
            try {
                this.fTemplateEngine.reset();
                this.fTemplateEngine.complete(viewer, documentOffset, null);
            }
            catch (Exception x) {
                System.out.println("Template Exception");
                CUIPlugin.log(x);
            }
            ICCompletionProposal[] templateResults = this.fTemplateEngine.getResults();
            if (results.length == 0) {
                results = templateResults;
            } else {
                ICCompletionProposal[] total = new ICCompletionProposal[results.length + templateResults.length];
                System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                System.arraycopy(results, 0, total, templateResults.length, results.length);
                results = total;
            }
        }
        this.order((ICCompletionProposal[])results);
        if (results.length == 1 && CUIPlugin.getDefault().getPreferenceStore().getBoolean("content_assist_autoinsert")) {
            results[0].apply(document);
            return new ICCompletionProposal[0];
        }
        return results;
    }

    private ICCompletionProposal[] order(ICCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private void addProjectCompletions(IProject project, IRegion region, String frag, ArrayList completions) {
        IndexModel model = IndexModel.getDefault();
        ITagEntry[] tags = model.query(project, frag + "*", false, false);
        if (tags != null && tags.length > 0) {
            int i = 0;
            while (i < tags.length) {
                String fname = tags[i].getTagName();
                int kind = tags[i].getKind();
                if (kind == 4 || kind == 8) {
                    fname = fname + "()";
                }
                String proto = fname + " - " + tags[i].getPattern();
                if (tags[i].getKind() != 6) {
                    completions.add(new CCompletionProposal(fname, region.getOffset(), region.getLength(), this.getTagImage(kind), proto.equals("") ? fname + "()" : proto, 3));
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICCompletionProposal[] evalProposals(IDocument document, int pos, int length) {
        String frag = "";
        if (pos > 2) {
            try {
                if (!Character.isJavaIdentifierPart(document.getChar(pos)) && Character.isJavaIdentifierPart(document.getChar(--pos))) {
                    // empty if block
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        IRegion region = CWordFinder.findWord(document, pos);
        try {
            frag = document.get(region.getOffset(), region.getLength());
            frag = frag.trim();
            if (frag.length() == 0) {
                return null;
            }
        }
        catch (BadLocationException x) {
            return null;
        }
        ArrayList<CCompletionProposal> completions = new ArrayList<CCompletionProposal>();
        IProject project = null;
        IEditorInput input = this.fEditor.getEditorInput();
        if (input instanceof IFileEditorInput && !(project = ((IFileEditorInput)input).getFile().getProject()).exists()) {
            project = null;
        }
        if (project != null) {
            this.addProjectCompletions(project, region, frag, completions);
            try {
                IProject[] referenced = project.getReferencedProjects();
                if (referenced.length > 0) {
                    int i = 0;
                    while (i < referenced.length) {
                        this.addProjectCompletions(referenced[i], region, frag, completions);
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        CCompletionContributorManager.getDefault();
        IFunctionSummary[] summary = CCompletionContributorManager.getMatchingFunctions(frag);
        if (summary != null) {
            int i = 0;
            while (i < summary.length) {
                String fname = summary[i].getName();
                String proto = summary[i].getPrototype();
                completions.add(new CCompletionProposal(fname + "()", region.getOffset(), region.getLength(), CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif"), proto.equals("") ? fname + "()" : proto, 2));
                ++i;
            }
        }
        return completions.toArray(new ICCompletionProposal[0]);
    }

    private Image getTagImage(int kind) {
        switch (kind) {
            case 8: {
                return CPluginImages.get("org.eclipse.cdt.ui.cdeclaration_obj.gif");
            }
            case 1: {
                return CPluginImages.get("org.eclipse.cdt.ui.class_obj.gif");
            }
            case 5: 
            case 6: 
            case 12: {
                return CPluginImages.get("org.eclipse.cdt.ui.field_obj.gif");
            }
            case 4: {
                return CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif");
            }
            case 9: {
                return CPluginImages.get("org.eclipse.cdt.ui.struct_obj.gif");
            }
            case 11: {
                return CPluginImages.get("org.eclipse.cdt.ui.union_obj.gif");
            }
            case 2: {
                return CPluginImages.get("org.eclipse.cdt.ui.define_obj.gif");
            }
        }
        return CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif");
    }
}

