/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICMemoryManager;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryPresentation;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryText;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MemoryControlArea
extends Composite {
    private MemoryView fMemoryView;
    private MemoryPresentation fPresentation;
    private int fIndex = 0;
    private ICMemoryManager fMemoryManager = null;
    private Text fAddressText;
    private MemoryText fMemoryText;
    private int fFormat = 0;
    private int fWordSize = 1;
    private int fNumberOfRows = 40;
    private int fNumberOfColumns = 16;
    private char fPaddingChar = (char)46;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IDebugTarget;

    public MemoryControlArea(Composite parent, int style, int index, MemoryView view) {
        super(parent, style);
        this.fMemoryView = view;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gridData = new GridData(1808);
        this.setLayout((Layout)layout);
        this.setLayoutData(gridData);
        this.setIndex(index);
        this.fPresentation = this.createPresentation();
        this.fAddressText = this.createAddressText(this);
        this.fMemoryText = this.createMemoryText(this, style, this.fPresentation);
    }

    private MemoryPresentation createPresentation() {
        return new MemoryPresentation();
    }

    public MemoryPresentation getPresentation() {
        return this.fPresentation;
    }

    private Text createAddressText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 131072);
        label.setText("Address: ");
        label.pack();
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' && e.stateMask == 0) {
                    MemoryControlArea.this.handleAddressEnter();
                }
            }
        });
        return text;
    }

    private MemoryText createMemoryText(Composite parent, int styles, MemoryPresentation presentation) {
        return new MemoryText(parent, 35584, presentation);
    }

    protected void handleAddressEnter() {
        if (this.getMemoryManager() != null) {
            String address = this.fAddressText.getText().trim();
            try {
                this.removeBlock();
                if (address.length() > 0) {
                    this.createBlock(address);
                }
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog("Unable to get memory block.", e.getStatus());
            }
            this.refresh();
            this.fMemoryView.updateObjects();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Memory.background.RGB")) {
            this.fMemoryText.setBackgroundColor();
        } else if (event.getProperty().equals("Memory.Foreground.RGB")) {
            this.fMemoryText.setForegroundColor();
        } else if (event.getProperty().equals("Memory.font")) {
            this.fMemoryText.changeFont();
        } else if (event.getProperty().equals("Memory.Address.RGB")) {
            this.fMemoryText.setAddressColor();
        } else if (event.getProperty().equals("Memory.Changed.RGB")) {
            this.fMemoryText.setChangedColor();
        } else if (event.getProperty().equals("Memory.Dirty.RGB")) {
            this.fMemoryText.setDirtyColor();
        }
    }

    public void setInput(Object input) {
        this.setMemoryManager(input instanceof ICMemoryManager ? (ICMemoryManager)input : null);
        this.getPresentation().setMemoryBlock(this.getMemoryBlock());
        this.setState();
        this.refresh();
    }

    protected void refresh() {
        this.fAddressText.setText(this.getPresentation() != null ? this.getPresentation().getAddressExpression() : "");
        this.fMemoryText.refresh();
        this.fMemoryView.updateObjects();
    }

    protected void setMemoryManager(ICMemoryManager mm) {
        this.fMemoryManager = mm;
    }

    protected ICMemoryManager getMemoryManager() {
        return this.fMemoryManager;
    }

    protected IFormattedMemoryBlock getMemoryBlock() {
        return this.getMemoryManager() != null ? this.getMemoryManager().getBlock(this.getIndex()) : null;
    }

    protected int getIndex() {
        return this.fIndex;
    }

    protected void setIndex(int index) {
        this.fIndex = index;
    }

    private void createBlock(String address) throws DebugException {
        if (this.getMemoryManager() != null) {
            this.getMemoryManager().setBlockAt(this.getIndex(), CDebugModel.createFormattedMemoryBlock((IDebugTarget)((IDebugTarget)this.getMemoryManager().getAdapter(class$org$eclipse$debug$core$model$IDebugTarget == null ? (class$org$eclipse$debug$core$model$IDebugTarget = MemoryControlArea.class$("org.eclipse.debug.core.model.IDebugTarget")) : class$org$eclipse$debug$core$model$IDebugTarget)), (String)address, (int)this.getFormat(), (int)this.getWordSize(), (int)this.getNumberOfRows(), (int)this.getNumberOfColumns(), (char)this.getPaddingChar()));
            this.getPresentation().setMemoryBlock(this.getMemoryBlock());
        }
        this.setMemoryTextState();
    }

    private void removeBlock() throws DebugException {
        if (this.getMemoryManager() != null) {
            this.getMemoryManager().removeBlock(this.getIndex());
            this.getPresentation().setMemoryBlock(null);
        }
        this.setMemoryTextState();
    }

    public int getFormat() {
        return this.fFormat;
    }

    public int getNumberOfColumns() {
        return this.fNumberOfColumns;
    }

    public int getNumberOfRows() {
        return this.fNumberOfRows;
    }

    public char getPaddingChar() {
        return this.fPaddingChar;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public void setFormat(int format) {
        this.fFormat = format;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.fNumberOfColumns = numberOfColumns;
    }

    public void setNumberOfRows(int numberOfRows) {
        this.fNumberOfRows = numberOfRows;
    }

    public void setPaddingChar(char paddingChar) {
        this.fPaddingChar = paddingChar;
    }

    public void setWordSize(int wordSize) {
        this.fWordSize = wordSize;
    }

    private void enableAddressText(boolean enable) {
        this.fAddressText.setEnabled(enable);
    }

    protected void setState() {
        this.enableAddressText(this.getMemoryManager() != null);
        this.setMemoryTextState();
    }

    private void setMemoryTextState() {
        this.fMemoryText.setEditable(this.getMemoryManager() != null && this.getMemoryBlock() != null);
    }

    protected MemoryText getMemoryText() {
        return this.fMemoryText;
    }

    protected void clear() {
        this.fAddressText.setText("");
        this.handleAddressEnter();
    }

    public void dispose() {
        if (this.getPresentation() != null) {
            this.getPresentation().dispose();
        }
        super.dispose();
    }

    protected String getTitle() {
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] tabItems = ((CTabFolder)this.getParent()).getItems();
            return tabItems[this.fIndex].getText();
        }
        return "";
    }

    protected void setTitle(String title) {
        if (this.getParent() instanceof CTabFolder) {
            CTabItem[] tabItems = ((CTabFolder)this.getParent()).getItems();
            tabItems[this.fIndex].setText(title);
        }
    }

    protected void refreshMemoryBlock() {
        if (this.getMemoryBlock() != null) {
            try {
                this.getMemoryBlock().refresh();
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog("Unable to refresh memory.", e.getStatus());
            }
        }
    }

    protected void saveChanges() {
        if (this.getMemoryBlock() != null) {
            try {
                this.getMemoryBlock().saveChanges();
                String title = this.getTitle();
                if (title.charAt(0) == '*') {
                    this.setTitle(title.substring(1));
                }
            }
            catch (DebugException e) {
                CDebugUIPlugin.errorDialog("Unable to save memory changes.", e.getStatus());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

