/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CDirectorySourceLocation
implements IDirectorySourceLocation {
    private IPath fDirectory;
    private IPath fAssociation = null;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation;
    static /* synthetic */ Class class$org$eclipse$core$runtime$IPath;

    public CDirectorySourceLocation(IPath directory) {
        this.setDirectory(directory);
    }

    public CDirectorySourceLocation(IPath directory, IPath association) {
        this.setDirectory(directory);
        this.setAssociation(association);
    }

    public Object findSourceElement(String name) throws CoreException {
        if (this.getDirectory() != null) {
            File file = new File(name);
            if (file.isAbsolute()) {
                return this.findFileByAbsolutePath(name);
            }
            return this.findFileByRelativePath(name);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation = CDirectorySourceLocation.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation == null ? (class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation = CDirectorySourceLocation.class$("org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation")) : class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$core$runtime$IPath == null ? (class$org$eclipse$core$runtime$IPath = CDirectorySourceLocation.class$("org.eclipse.core.runtime.IPath")) : class$org$eclipse$core$runtime$IPath)) {
            return this.getDirectory();
        }
        return null;
    }

    private void setDirectory(IPath directory) {
        this.fDirectory = directory;
    }

    public IPath getDirectory() {
        return this.fDirectory;
    }

    private void setAssociation(IPath association) {
        this.fAssociation = association;
    }

    public IPath getAssociation() {
        return this.fAssociation;
    }

    private Object findFileByAbsolutePath(String fileName) {
        Path filePath = new Path(fileName);
        IPath path = this.getDirectory();
        IPath association = this.getAssociation();
        if (path.isPrefixOf((IPath)filePath)) {
            filePath = path.append(filePath.removeFirstSegments(path.segmentCount()));
        } else if (association != null && association.isPrefixOf((IPath)filePath)) {
            filePath = path.append(filePath.removeFirstSegments(association.segmentCount()));
        } else {
            return null;
        }
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
        if (f != null) {
            return f;
        }
        File file = filePath.toFile();
        if (file.exists()) {
            return this.createExternalFileStorage((IPath)filePath);
        }
        return null;
    }

    private Object findFileByRelativePath(String fileName) {
        File file;
        IPath path = this.getDirectory();
        if (path != null && (file = (path = path.append(fileName)).toFile()).exists()) {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (f != null) {
                return f;
            }
            return this.createExternalFileStorage(path);
        }
        return null;
    }

    private IStorage createExternalFileStorage(IPath path) {
        return new FileStorage(path);
    }

    public IPath[] getPaths() {
        return new IPath[]{this.fDirectory};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

