/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceLocator
implements ICSourceLocator {
    private ICSourceLocation[] fSourceLocations;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IStackFrameInfo;

    public CSourceLocator() {
        this.setSourceLocations(new ICSourceLocation[0]);
    }

    public CSourceLocator(IProject project) {
        this.fSourceLocations = CSourceLocator.getDefaultSourceLocations(project);
    }

    public CSourceLocator(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        if (stackFrame != null && stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo) != null) {
            return this.getInput((IStackFrameInfo)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo));
        }
        return null;
    }

    public int getLineNumber(IStackFrame frame) {
        IStackFrameInfo info = (IStackFrameInfo)frame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo);
        return info != null ? info.getFrameLineNumber() : 0;
    }

    protected Object getInput(IStackFrameInfo info) {
        String fileName;
        Object result = null;
        if (info != null && (fileName = info.getFile()) != null && fileName.length() > 0 && (result = this.findFileByAbsolutePath(fileName)) == null) {
            ICSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException e) {
                    // empty catch block
                }
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public boolean contains(IResource resource) {
        ICSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            if (resource instanceof IProject && locations[i] instanceof CProjectSourceLocation && ((CProjectSourceLocation)locations[i]).getProject().equals((Object)resource)) {
                return true;
            }
            if (resource instanceof IFile) {
                try {
                    if (locations[i].findSourceElement(resource.getLocation().toOSString()) != null) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceLocations;
    }

    public void setSourceLocations(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public static ICSourceLocation[] getDefaultSourceLocations(IProject project) {
        ArrayList<CProjectSourceLocation> list = new ArrayList<CProjectSourceLocation>();
        if (project != null && project.exists()) {
            list.add(new CProjectSourceLocation(project));
            CSourceLocator.addReferencedSourceLocations(list, project);
        }
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private static void addReferencedSourceLocations(List list, IProject project) {
        if (project != null) {
            try {
                IProject[] projects = project.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].exists()) {
                        list.add(new CProjectSourceLocation(projects[i]));
                        CSourceLocator.addReferencedSourceLocations(list, projects[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private Object findFileByAbsolutePath(String fileName) {
        Path path = new Path(fileName);
        if (path.isAbsolute() && path.toFile().exists()) {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (f != null) {
                return f;
            }
            return new FileStorage((IPath)path);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

