/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.core.model.ICRoot;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class BinaryRunner
implements Runnable {
    ArchiveContainer clib;
    BinaryContainer cbin;
    CProject cproject;

    public BinaryRunner(CProject cprj) {
        this.cproject = cprj;
        this.cbin = (BinaryContainer)cprj.getBinaryContainer();
        this.clib = (ArchiveContainer)cprj.getArchiveContainer();
    }

    public void run() {
        this.cproject.setStartBinaryRunner(true);
        this.clib.removeChildren();
        this.cbin.removeChildren();
        try {
            this.cproject.getProject().accept((IResourceVisitor)new Visitor(this));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fireEvents(this.cbin);
        this.fireEvents(this.clib);
    }

    public void fireEvents(Parent container) {
        ICElement[] children = container.getChildren();
        if (children.length > 0) {
            CModelManager factory = CModelManager.getDefault();
            ICRoot root = factory.getCRoot();
            CElementDelta cdelta = new CElementDelta(root);
            cdelta.added(this.cproject);
            cdelta.added(container);
            int i = 0;
            while (i < children.length) {
                cdelta.added(children[i]);
                ++i;
            }
            factory.registerCModelDelta(cdelta);
            factory.fire();
        }
    }

    void addChildIfBinary(CoreModel factory, IFile file) {
        if (!factory.isTranslationUnit(file)) {
            ICFile celement;
            if (factory.isBinary(file)) {
                IBinary bin;
                ICFile celement2 = factory.create(file);
                if (celement2 != null && celement2 instanceof IBinary && ((bin = (IBinary)celement2).isExecutable() || bin.isSharedLib())) {
                    this.cbin.addChild(bin);
                }
            } else if (factory.isArchive(file) && (celement = factory.create(file)) instanceof IArchive) {
                this.clib.addChild(celement);
            }
        }
    }

    class Visitor
    implements IResourceVisitor {
        CoreModel factory = CoreModel.getDefault();
        BinaryRunner runner;

        public Visitor(BinaryRunner r) {
            this.runner = r;
        }

        public boolean visit(IResource res) throws CoreException {
            if (res instanceof IFile) {
                this.runner.addChildIfBinary(this.factory, (IFile)res);
                return false;
            }
            return true;
        }
    }
}

