/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.internal.core.model.parser.ElfBinaryFile;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class ElfBinaryArchive
extends PlatformObject
implements IBinaryParser.IBinaryArchive {
    IFile file;
    ArrayList children;
    long timestamp;

    public ElfBinaryArchive(IFile f) {
        this.file = f;
        this.children = new ArrayList(5);
    }

    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            IPath location = this.file.getLocation();
            if (location != null) {
                AR ar = null;
                try {
                    ar = new AR(location.toOSString());
                    AR.ARHeader[] headers = ar.getHeaders();
                    int i = 0;
                    while (i < headers.length) {
                        ElfBinaryFile bin = new ElfBinaryFile(this.file, headers[i].getObjectName());
                        this.children.add(bin);
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ar != null) {
                    ar.dispose();
                }
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }

    public IFile getFile() {
        return this.file;
    }

    public int getType() {
        return 8;
    }

    public InputStream getContents() {
        try {
            return this.file.getContents();
        }
        catch (CoreException coreException) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    boolean hasChanged() {
        long modif = this.file.getModificationStamp();
        boolean changed = modif != this.timestamp;
        this.timestamp = modif;
        return changed;
    }

    public void add(IBinaryParser.IBinaryObject[] objs) throws IOException {
    }

    public void delete(IBinaryParser.IBinaryObject[] objs) throws IOException {
    }
}

