/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;

public class MemoryManager
extends SessionObject
implements ICDIMemoryManager {
    List blockList = new ArrayList();

    public MemoryManager(CSession session) {
        super(session);
    }

    public void update() {
        MISession mi = this.getCSession().getMISession();
        MemoryBlock[] blocks = this.listMemoryBlocks();
        ArrayList eventList = new ArrayList(blocks.length);
        int i = 0;
        while (i < blocks.length) {
            if (!blocks[i].isFrozen()) {
                try {
                    this.update(blocks[i], eventList);
                }
                catch (CDIException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public Long[] update(MemoryBlock block, List aList) throws CDIException {
        MemoryBlock newBlock = this.cloneBlock(block);
        boolean newAddress = newBlock.getStartAddress() != block.getStartAddress();
        Long[] array = this.compareBlocks(block, newBlock);
        block.setMIDataReadMemoryInfo(newBlock.getMIDataReadMemoryInfo());
        if (array.length > 0 || newAddress) {
            if (aList != null) {
                aList.add(new MIMemoryChangedEvent(array));
            } else {
                MISession mi = this.getCSession().getMISession();
                mi.fireEvent(new MIMemoryChangedEvent(array));
            }
        }
        return array;
    }

    public MemoryBlock[] listMemoryBlocks() {
        return this.blockList.toArray(new MemoryBlock[0]);
    }

    Long[] compareBlocks(MemoryBlock oldBlock, MemoryBlock newBlock) throws CDIException {
        byte[] oldBytes = oldBlock.getBytes();
        byte[] newBytes = newBlock.getBytes();
        ArrayList<Long> aList = new ArrayList<Long>(newBytes.length);
        long diff = newBlock.getStartAddress() - oldBlock.getStartAddress();
        if (Math.abs(diff) < (long)newBytes.length) {
            int i = 0;
            while (i < newBytes.length) {
                if (i + (int)diff < oldBytes.length && i + (int)diff >= 0 && oldBytes[i + (int)diff] != newBytes[i]) {
                    aList.add(new Long(newBlock.getStartAddress() + (long)i));
                }
                ++i;
            }
        }
        return aList.toArray(new Long[0]);
    }

    MemoryBlock cloneBlock(MemoryBlock block) throws CDIException {
        String exp = block.getExpression();
        MIDataReadMemoryInfo info = this.createMIDataReadMemoryInfo(exp, (int)block.getLength());
        return new MemoryBlock(this.getCSession().getCTarget(), exp, info);
    }

    MIDataReadMemoryInfo createMIDataReadMemoryInfo(String exp, int length) throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataReadMemory mem = factory.createMIDataReadMemory(0L, exp, 0, 1, 1, length, null);
        try {
            mi.postCommand(mem);
            MIDataReadMemoryInfo info = mem.getMIDataReadMemoryInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIMemoryBlock createMemoryBlock(long address, int length) throws CDIException {
        String addr = "0x" + Long.toHexString(address);
        return this.createMemoryBlock(addr, length);
    }

    public ICDIMemoryBlock createMemoryBlock(String address, int length) throws CDIException {
        MIDataReadMemoryInfo info = this.createMIDataReadMemoryInfo(address, length);
        MemoryBlock block = new MemoryBlock(this.getCSession().getCTarget(), address, info);
        this.blockList.add(block);
        MISession mi = this.getCSession().getMISession();
        mi.fireEvent(new MIMemoryCreatedEvent(block.getStartAddress(), block.getLength()));
        return block;
    }

    public ICDIMemoryBlock[] getMemoryBlocks() throws CDIException {
        return this.listMemoryBlocks();
    }

    public void removeAllBlocks() throws CDIException {
        this.blockList.clear();
    }

    public void removeBlock(ICDIMemoryBlock memoryBlock) throws CDIException {
        this.blockList.remove(memoryBlock);
    }

    public void removeBlocks(ICDIMemoryBlock[] memoryBlocks) throws CDIException {
        int i = 0;
        while (i < memoryBlocks.length) {
            this.removeBlock(memoryBlocks[i]);
            ++i;
        }
    }
}

