/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.SharedLibrary;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIInfoSharedLibrary;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoSharedLibraryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIShared;

public class SharedLibraryManager
extends SessionObject
implements ICDISharedLibraryManager {
    List sharedList = new ArrayList(1);
    List unloadedList = new ArrayList(1);

    public SharedLibraryManager(CSession session) {
        super(session);
    }

    public void update() throws CDIException {
        CSession s = this.getCSession();
        ICDIConfiguration conf = s.getConfiguration();
        if (!conf.supportsSharedLibrary()) {
            return;
        }
        MIShared[] miLibs = new MIShared[]{};
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIInfoSharedLibrary infoShared = factory.createMIInfoSharedLibrary();
        try {
            s.getMISession().postCommand(infoShared);
            MIInfoSharedLibraryInfo info = infoShared.getMIInfoSharedLibraryInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            miLibs = info.getMIShared();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(miLibs.length);
        int i = 0;
        while (i < miLibs.length) {
            if (this.containsSharedLib(miLibs[i])) {
                if (this.hasSharedLibChanged(miLibs[i])) {
                    SharedLibrary sharedlib = (SharedLibrary)this.getSharedLibrary(miLibs[i].getName());
                    sharedlib.setMIShared(miLibs[i]);
                    eventList.add(new MISharedLibChangedEvent(miLibs[i].getName()));
                }
            } else {
                this.sharedList.add(new SharedLibrary(this, miLibs[i]));
                eventList.add(new MISharedLibCreatedEvent(miLibs[i].getName()));
            }
            ++i;
        }
        ICDISharedLibrary[] oldlibs = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int i2 = 0;
        while (i2 < oldlibs.length) {
            boolean found = false;
            int j = 0;
            while (j < miLibs.length) {
                if (miLibs[j].getName().equals(oldlibs[i2].getFileName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.sharedList.remove(oldlibs[i2]);
                this.unloadedList.add(oldlibs[i2]);
                eventList.add(new MISharedLibUnloadedEvent(oldlibs[i2].getFileName()));
            }
            ++i2;
        }
        MISession mi = this.getCSession().getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public boolean containsSharedLib(MIShared miLib) {
        ICDISharedLibrary[] libs = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int i = 0;
        while (i < libs.length) {
            if (miLib.getName().equals(libs[i].getFileName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasSharedLibChanged(MIShared miLib) {
        ICDISharedLibrary[] libs = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int i = 0;
        while (i < libs.length) {
            if (miLib.getName().equals(libs[i].getFileName())) {
                return miLib.getFrom() != libs[i].getStartAddress() || miLib.getTo() != libs[i].getEndAddress() || miLib.isRead() != libs[i].areSymbolsLoaded();
            }
            ++i;
        }
        return false;
    }

    public ICDISharedLibrary getUnloadedLibrary(String name) {
        ICDISharedLibrary[] libs = this.unloadedList.toArray(new ICDISharedLibrary[0]);
        int i = 0;
        while (i < libs.length) {
            if (name.equals(libs[i].getFileName())) {
                return libs[i];
            }
            ++i;
        }
        return null;
    }

    public void removeFromUnloadedList(String name) {
        ICDISharedLibrary[] libs = this.unloadedList.toArray(new ICDISharedLibrary[0]);
        int i = 0;
        while (i < libs.length) {
            if (name.equals(libs[i].getFileName())) {
                this.unloadedList.remove(libs[i]);
            }
            ++i;
        }
    }

    public ICDISharedLibrary getSharedLibrary(String name) {
        ICDISharedLibrary[] libs = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int i = 0;
        while (i < libs.length) {
            if (name.equals(libs[i].getFileName())) {
                return libs[i];
            }
            ++i;
        }
        return null;
    }

    public ICDISharedLibrary[] getSharedLibraries() throws CDIException {
        this.update();
        return this.sharedList.toArray(new ICDISharedLibrary[0]);
    }

    public void loadSymbols() throws CDIException {
        CSession s = this.getCSession();
        CLICommand cmd = new CLICommand("shared");
        try {
            s.getMISession().postCommand(cmd);
            MIInfo info = cmd.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.update();
    }

    public void loadSymbols(ICDISharedLibrary[] libs) throws CDIException {
        int i = 0;
        while (i < libs.length) {
            if (!libs[i].areSymbolsLoaded()) {
                CSession s = this.getCSession();
                CLICommand cmd = new CLICommand("shared " + libs[i].getFileName());
                try {
                    s.getMISession().postCommand(cmd);
                    MIInfo info = cmd.getMIInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
            }
            ++i;
        }
        this.update();
    }
}

