/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class ChangedEvent
implements ICDIChangedEvent {
    CSession session;
    ICDIObject source;

    public ChangedEvent(CSession s, MIVarChangedEvent var) {
        this.session = s;
        VariableManager mgr = this.session.getVariableManager();
        String varName = var.getVarName();
        VariableManager.Element element = mgr.getElement(varName);
        this.source = element != null && element.variable != null ? element.variable : new CObject(this.session.getCTarget());
    }

    public ChangedEvent(CSession s, MIRegisterChangedEvent var) {
        this.session = s;
        RegisterManager mgr = this.session.getRegisterManager();
        int regno = var.getNumber();
        Register reg = null;
        try {
            reg = mgr.getRegister(regno);
        }
        catch (CDIException e) {
            // empty catch block
        }
        this.source = reg != null ? reg : new CObject(this.session.getCTarget());
    }

    public ChangedEvent(CSession s, MIBreakpointChangedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = (BreakpointManager)this.session.getBreakpointManager();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.getBreakpoint(number);
        this.source = breakpoint != null ? breakpoint : new CObject(this.session.getCTarget());
    }

    public ChangedEvent(CSession s, MISharedLibChangedEvent slib) {
        this.session = s;
        SharedLibraryManager mgr = (SharedLibraryManager)this.session.getSharedLibraryManager();
        String name = slib.getName();
        ICDISharedLibrary lib = mgr.getSharedLibrary(name);
        this.source = lib != null ? lib : new CObject(this.session.getCTarget());
    }

    public ChangedEvent(CSession s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

