/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class Breakpoint
extends CObject
implements ICDILocationBreakpoint {
    ICDILocation location;
    ICDICondition condition;
    MIBreakpoint miBreakpoint;
    BreakpointManager mgr;

    public Breakpoint(BreakpointManager m, MIBreakpoint miBreak) {
        super(m.getCSession().getCTarget());
        this.miBreakpoint = miBreak;
        this.mgr = m;
    }

    public MIBreakpoint getMIBreakpoint() {
        return this.miBreakpoint;
    }

    public ICDICondition getCondition() throws CDIException {
        if (this.condition == null) {
            this.condition = new Condition(this.miBreakpoint.getIgnoreCount(), this.miBreakpoint.getWhat());
        }
        return this.condition;
    }

    public String getThreadId() throws CDIException {
        return this.miBreakpoint.getThreadId();
    }

    public boolean isEnabled() throws CDIException {
        return this.miBreakpoint.isEnabled();
    }

    public boolean isHardware() {
        return this.miBreakpoint.isHardware();
    }

    public boolean isTemporary() {
        return this.miBreakpoint.isTemporary();
    }

    public void setCondition(ICDICondition condition) throws CDIException {
        if (this.isEnabled()) {
            this.mgr.setCondition((ICDIBreakpoint)this, condition);
        }
        this.condition = condition;
    }

    public void setEnabled(boolean enable) throws CDIException {
        if (!enable && this.isEnabled()) {
            this.mgr.disableBreakpoint((ICDIBreakpoint)this);
        } else if (enable && !this.isEnabled()) {
            this.mgr.enableBreakpoint((ICDIBreakpoint)this);
        }
    }

    public ICDILocation getLocation() throws CDIException {
        if (this.location == null) {
            this.location = new Location(this.miBreakpoint.getFile(), this.miBreakpoint.getFunction(), this.miBreakpoint.getLine(), this.miBreakpoint.getAddress());
        }
        return this.location;
    }
}

