/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fInfo;
    private ITextEditor fTextEditor;
    private IBreakpoint fBreakpoint;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof ICLineBreakpoint) {
                ICLineBreakpoint cBreakpoint = (ICLineBreakpoint)breakpoint;
                try {
                    if (this.breakpointAtRulerLine(cBreakpoint)) {
                        return cBreakpoint;
                    }
                }
                catch (CoreException ce) {
                    CDebugUIPlugin.log(ce);
                }
            }
            ++i;
        }
        return null;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.fInfo = info;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = AbstractBreakpointRulerAction.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile);
        if (resource == null) {
            resource = (IResource)input.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = AbstractBreakpointRulerAction.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        return resource;
    }

    protected boolean breakpointAtRulerLine(ICLineBreakpoint cBreakpoint) throws CoreException {
        Position position;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null && (position = model.getMarkerPosition(cBreakpoint.getMarker())) != null) {
            IDocumentProvider provider = this.getTextEditor().getDocumentProvider();
            IDocument doc = provider.getDocument((Object)this.getTextEditor().getEditorInput());
            try {
                int markerLineNumber = doc.getLineOfOffset(position.getOffset());
                int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
                if (rulerLine == markerLineNumber) {
                    if (this.getTextEditor().isDirty()) {
                        return cBreakpoint.getLineNumber() == markerLineNumber + 1;
                    }
                    return true;
                }
            }
            catch (BadLocationException x) {
                CDebugUIPlugin.log(x);
            }
        }
        return false;
    }

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.getTextEditor().getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    public abstract void update();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

