/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.ICBreakpointManager;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyMarkerAnnotation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DisassemblyMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IWorkspace fWorkspace;
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private IResourceDeltaVisitor fResourceDeltaVisitor = new ResourceDeltaVisitor();
    private IDisassemblyStorage fStorage = null;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICBreakpointManager;

    public DisassemblyMarkerAnnotationModel(IDisassemblyStorage storage, IResource resource) {
        this.fResource = resource;
        this.fWorkspace = resource.getWorkspace();
        this.fStorage = storage;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        if (this.fStorage == null) {
            return null;
        }
        IDebugTarget target = this.fStorage.getDebugTarget();
        if (target != null) {
            IBreakpointManager bm = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] brkpts = bm.getBreakpoints();
            ArrayList<IMarker> list = new ArrayList<IMarker>(brkpts.length);
            int i = 0;
            while (i < brkpts.length) {
                if (target.supportsBreakpoint(brkpts[i]) && this.isAcceptable(brkpts[i].getMarker())) {
                    list.add(brkpts[i].getMarker());
                }
                ++i;
            }
            return list.toArray(new IMarker[list.size()]);
        }
        return null;
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null);
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected boolean isAcceptable(IMarker marker) {
        try {
            return marker.getType().equals(CLineBreakpoint.getMarkerType()) || marker.getType().equals(CAddressBreakpoint.getMarkerType());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected IResourceDeltaVisitor getResourceDeltaVisitor() {
        return this.fResourceDeltaVisitor;
    }

    protected void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta delta = markerDeltas[i];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                }
            }
            ++i;
        }
        this.fireModelChanged();
    }

    protected Position createPositionFromMarker(IMarker marker) {
        try {
            if (marker.getType().equals(CLineBreakpoint.getMarkerType())) {
                return this.createPositionFromLineBreakpoint(marker);
            }
            if (marker.getType().equals(CAddressBreakpoint.getMarkerType())) {
                return this.createPositionFromAddressBreakpoint(marker);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private Position createPositionFromLineBreakpoint(IMarker marker) {
        ICBreakpointManager bm;
        long address;
        if (this.fStorage == null) {
            return null;
        }
        IDebugTarget target = this.fStorage.getDebugTarget();
        if (target != null && target.getAdapter(class$org$eclipse$cdt$debug$core$ICBreakpointManager == null ? (class$org$eclipse$cdt$debug$core$ICBreakpointManager = DisassemblyMarkerAnnotationModel.class$("org.eclipse.cdt.debug.core.ICBreakpointManager")) : class$org$eclipse$cdt$debug$core$ICBreakpointManager) != null && (address = (bm = (ICBreakpointManager)target.getAdapter(class$org$eclipse$cdt$debug$core$ICBreakpointManager == null ? (class$org$eclipse$cdt$debug$core$ICBreakpointManager = DisassemblyMarkerAnnotationModel.class$("org.eclipse.cdt.debug.core.ICBreakpointManager")) : class$org$eclipse$cdt$debug$core$ICBreakpointManager)).getBreakpointAddress(DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker))) != 0L) {
            return this.createPositionFromAddress(address);
        }
        return null;
    }

    private Position createPositionFromAddressBreakpoint(IMarker marker) throws CoreException {
        try {
            return this.createPositionFromAddress(Long.parseLong(marker.getAttribute("org.eclipse.cdt.debug.core.address", "0")));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Position createPositionFromAddress(long address) {
        try {
            int start = -1;
            int line = this.fStorage.getLineNumber(address);
            if (line > 0 && ((AnnotationModel)this).fDocument != null && (start = ((AnnotationModel)this).fDocument.getLineOffset(line - 1)) > -1) {
                return new Position(start, ((AnnotationModel)this).fDocument.getLineLength(line - 1));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        return new DisassemblyMarkerAnnotation(marker);
    }

    public Position getMarkerPosition(IMarker marker) {
        return this.createPositionFromMarker(marker);
    }

    protected void doHandleCoreException(CoreException e, String message) {
        this.handleCoreException(e, message);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null && delta.getResource() instanceof IFile) {
                DisassemblyMarkerAnnotationModel.this.update(delta.getMarkerDeltas());
                return false;
            }
            return true;
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null) {
                    delta.accept(DisassemblyMarkerAnnotationModel.this.getResourceDeltaVisitor());
                }
            }
            catch (CoreException x) {
                DisassemblyMarkerAnnotationModel.this.doHandleCoreException(x, "Resource Changed");
            }
        }
    }
}

