/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CElementImageDescriptor;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final int OVERLAY_ERROR = 8;
    public static final int OVERLAY_WARNING = 16;
    public static final int OVERLAY_OVERRIDE = 32;
    public static final int OVERLAY_IMPLEMENTS = 64;
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private static ImageDescriptor DESC_OBJ_FOLDER;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public CElementImageProvider() {
        ISharedImages images = CUIPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        DESC_OBJ_FOLDER = images.getImageDescriptor("IMG_OBJ_FOLDER");
        this.fRegistry = CUIPlugin.getImageDescriptorRegistry();
    }

    public Image getImageLabel(Object element, int flags) {
        ImageDescriptor descriptor = null;
        if (element instanceof ICElement) {
            descriptor = this.getCImageDescriptor((ICElement)element, flags);
        }
        if (descriptor == null && element instanceof ICFile) {
            element = ((ICFile)element).getFile();
        }
        if (descriptor == null && element instanceof IAdaptable) {
            descriptor = this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        if (descriptor != null) {
            return this.fRegistry.get(descriptor);
        }
        return null;
    }

    private boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    private boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public ImageDescriptor getCImageDescriptor(ICElement element, int flags) {
        int adornmentFlags = this.computeCAdornmentFlags(element, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor desc = this.getBaseImageDescriptor(element, flags);
        if (desc != null) {
            return new CElementImageDescriptor(desc, adornmentFlags, size);
        }
        return null;
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = CElementImageProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        int adornmentFlags = this.computeBasicAdornmentFlags(adaptable, flags);
        Point size = this.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new CElementImageDescriptor(descriptor, adornmentFlags, size);
    }

    public ImageDescriptor getBaseImageDescriptor(ICElement celement, int renderFlags) {
        int type = celement.getElementType();
        switch (type) {
            case 30: {
                return CPluginImages.DESC_OBJS_CONTAINER;
            }
            case 13: {
                ICFile cfile = (ICFile)celement;
                if (cfile.isArchive()) {
                    return CPluginImages.DESC_OBJS_ARCHIVE;
                }
                if (cfile.isBinary()) {
                    IBinary bin = (IBinary)cfile;
                    if (bin.isExecutable()) {
                        if (bin.hasDebug()) {
                            return CPluginImages.DESC_OBJS_CEXEC_DEBUG;
                        }
                        return CPluginImages.DESC_OBJS_CEXEC;
                    }
                    if (bin.isSharedLib()) {
                        return CPluginImages.DESC_OBJS_SHLIB;
                    }
                    if (bin.isCore()) {
                        return CPluginImages.DESC_OBJS_CORE;
                    }
                    return CPluginImages.DESC_OBJS_BINARY;
                }
                if (!cfile.isTranslationUnit()) break;
                return CPluginImages.DESC_OBJS_TUNIT;
            }
            case 12: {
                return DESC_OBJ_FOLDER;
            }
            case 11: {
                ICProject cp = (ICProject)celement;
                if (cp.getProject().isOpen()) {
                    ImageDescriptor result;
                    IProject project = cp.getProject();
                    IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = CElementImageProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
                    if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                        return result;
                    }
                    return DESC_OBJ_PROJECT;
                }
                return DESC_OBJ_PROJECT_CLOSED;
            }
            case 65: {
                return CPluginImages.DESC_OBJS_STRUCT;
            }
            case 64: {
                return CPluginImages.DESC_OBJS_CLASS;
            }
            case 66: {
                return CPluginImages.DESC_OBJS_UNION;
            }
            case 69: 
            case 74: {
                return CPluginImages.DESC_OBJS_FIELD;
            }
            case 67: 
            case 71: {
                return CPluginImages.DESC_OBJS_FUNCTION;
            }
            case 70: {
                return CPluginImages.DESC_OBJS_DECLARARION;
            }
            case 72: {
                return CPluginImages.DESC_OBJS_INCLUDE;
            }
            case 77: {
                return CPluginImages.DESC_OBJS_MACRO;
            }
        }
        return null;
    }

    public ImageDescriptor getCElementImageDescriptor(int type) {
        switch (type) {
            case 30: {
                return CPluginImages.DESC_OBJS_CONTAINER;
            }
            case 13: {
                return CPluginImages.DESC_OBJS_TUNIT;
            }
            case 65: {
                return CPluginImages.DESC_OBJS_STRUCT;
            }
            case 64: {
                return CPluginImages.DESC_OBJS_CLASS;
            }
            case 66: {
                return CPluginImages.DESC_OBJS_UNION;
            }
            case 69: 
            case 74: {
                return CPluginImages.DESC_OBJS_FIELD;
            }
            case 67: 
            case 70: 
            case 71: {
                return CPluginImages.DESC_OBJS_FUNCTION;
            }
            case 72: {
                return CPluginImages.DESC_OBJS_INCLUDE;
            }
            case 77: {
                return CPluginImages.DESC_OBJS_MACRO;
            }
        }
        System.out.println("Unknown base object ype " + type);
        return CPluginImages.DESC_OBJS_MACRO;
    }

    private int computeCAdornmentFlags(ICElement element, int renderFlags) {
        int flags = this.computeBasicAdornmentFlags(element, renderFlags);
        return flags;
    }

    private int computeBasicAdornmentFlags(Object element, int renderFlags) {
        int flags = 0;
        if ((renderFlags & 8) != 0) {
            flags |= 0x40;
        }
        if ((renderFlags & 0x10) != 0) {
            flags |= 0x20;
        }
        if ((renderFlags & 0x20) != 0) {
            flags |= 0x80;
        }
        if ((renderFlags & 0x40) != 0) {
            flags |= 0x100;
        }
        return flags;
    }

    public void dispose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

