/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.core.index.IndexModel;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class OpenOnSelectionAction
extends Action {
    private String fDialogTitle;
    private String fDialogMessage;
    protected CEditor fEditor;

    protected OpenOnSelectionAction() {
        this.setText(CEditorMessages.getString("OpenOnSelection.label"));
        this.setToolTipText(CEditorMessages.getString("OpenOnSelection.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenOnSelection.description"));
        this.setDialogTitle(CEditorMessages.getString("OpenOnSelection.dialog.title"));
        this.setDialogMessage(CEditorMessages.getString("OpenOnSelection.dialog.message"));
    }

    public OpenOnSelectionAction(ImageDescriptor image) {
        this();
        this.setImageDescriptor(image);
    }

    public OpenOnSelectionAction(CEditor editor) {
        this();
        this.fEditor = editor;
    }

    protected void OOpenOnSelectionAction(String label) {
    }

    protected void setDialogTitle(String title) {
        this.fDialogTitle = title;
    }

    protected void setDialogMessage(String message) {
        this.fDialogMessage = message;
    }

    public void setContentEditor(CEditor editor) {
        this.fEditor = editor;
    }

    public void run() {
        IndexModel model = IndexModel.getDefault();
        if (model != null && this.fEditor.getSelectionProvider() != null) {
            ITextSelection selection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            try {
                ITagEntry selected;
                String sel = selection.getText();
                IFile file = this.fEditor.getInputFile();
                if (file == null) {
                    return;
                }
                IProject project = file.getProject();
                if (project == null) {
                    return;
                }
                ITagEntry[] result = model.query(project, sel);
                ArrayList filtered = new ArrayList();
                if (result != null && result.length > 0) {
                    this.filterResolveResults(result, filtered);
                }
                IProject[] p = project.getReferencedProjects();
                int j = 0;
                while (j < p.length) {
                    result = model.query(p[j], sel);
                    if (result != null && result.length > 0) {
                        this.filterResolveResults(result, filtered);
                    }
                    ++j;
                }
                if (!filtered.isEmpty() && (selected = this.selectCElement(filtered, this.getShell(), this.fDialogTitle, this.fDialogMessage)) != null) {
                    this.open(selected);
                    return;
                }
            }
            catch (CModelException x) {
                CUIPlugin.log(x.getStatus());
            }
            catch (PartInitException x) {
                CUIPlugin.log(x);
            }
            catch (CoreException x) {
                CUIPlugin.log(x);
            }
        }
        this.getShell().getDisplay().beep();
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    protected void open(ITagEntry element) throws CModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element.getIFile());
        int line = element.getLineNumber();
        if (line > 0) {
            --line;
        }
        if (part instanceof CEditor) {
            CEditor ed = (CEditor)part;
            try {
                IDocument document = ed.getDocumentProvider().getDocument((Object)ed.getEditorInput());
                if (line > 3) {
                    ed.selectAndReveal(document.getLineOffset(line - 3), 0);
                }
                ed.selectAndReveal(document.getLineOffset(line), 0);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    protected List filterResolveResults(ITagEntry[] codeResolveResults, List list) {
        int nResults = codeResolveResults.length;
        List refs = list;
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i].getKind() != 8) {
                refs.add(codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    protected ITagEntry selectCElement(List elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.size();
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return (ITagEntry)elements.get(0);
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new TagEntryLabelProvider(), false, false);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof ITagEntry) {
                    return (ITagEntry)current;
                }
                ++i;
            }
        }
        return null;
    }

    private class TagEntryLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ITagEntry) {
                int kind = ((ITagEntry)element).getKind();
                switch (kind) {
                    case 8: {
                        return CPluginImages.get("org.eclipse.cdt.ui.cdeclaration_obj.gif");
                    }
                    case 1: {
                        return CPluginImages.get("org.eclipse.cdt.ui.class_obj.gif");
                    }
                    case 5: 
                    case 6: 
                    case 12: {
                        return CPluginImages.get("org.eclipse.cdt.ui.field_obj.gif");
                    }
                    case 4: {
                        return CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif");
                    }
                    case 9: {
                        return CPluginImages.get("org.eclipse.cdt.ui.struct_obj.gif");
                    }
                    case 11: {
                        return CPluginImages.get("org.eclipse.cdt.ui.union_obj.gif");
                    }
                    case 2: {
                        return CPluginImages.get("org.eclipse.cdt.ui.define_obj.gif");
                    }
                }
            }
            return CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof ITagEntry) {
                ITagEntry entry = (ITagEntry)element;
                if (entry.getIFile() != null) {
                    return entry.getIFile().getName() + ":" + entry.getTagName() + ":" + entry.getLineNumber() + " - " + entry.getIFile().getFullPath().toOSString();
                }
                return entry.getFileName() + ":" + entry.getTagName() + ":" + entry.getLineNumber();
            }
            return "";
        }
    }
}

