/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.link;

import org.eclipse.cdt.internal.ui.text.link.LinkedPositionListener;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LinkedPositionUI
implements LinkedPositionListener,
ITextInputListener,
ModifyListener,
VerifyListener,
VerifyKeyListener,
PaintListener,
IPropertyChangeListener {
    private static final int UNINSTALL = 1;
    private static final int COMMIT = 2;
    private static final int DOCUMENT_CHANGED = 4;
    private static final int UPDATE_CARET = 8;
    private static final String CARET_POSITION = "LinkedPositionUI.caret.position";
    private static final IPositionUpdater fgUpdater = new DefaultPositionUpdater("LinkedPositionUI.caret.position");
    private static final IPreferenceStore fgStore = CUIPlugin.getDefault().getPreferenceStore();
    private final ITextViewer fViewer;
    private final LinkedPositionManager fManager;
    private Color fFrameColor;
    private int fFinalCaretOffset = -1;
    private Position fFramePosition;
    private int fCaretOffset;
    private ExitListener fExitListener;

    public LinkedPositionUI(ITextViewer viewer, LinkedPositionManager manager) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)manager);
        this.fViewer = viewer;
        this.fManager = manager;
        this.fManager.setLinkedPositionListener(this);
        this.initializeHighlightColor(viewer);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("linkedPositionColor")) {
            this.initializeHighlightColor(this.fViewer);
            this.redrawRegion();
        }
    }

    private void initializeHighlightColor(ITextViewer viewer) {
        StyledText text;
        if (this.fFrameColor != null) {
            this.fFrameColor.dispose();
        }
        if ((text = viewer.getTextWidget()) != null) {
            Display display = text.getDisplay();
            this.fFrameColor = this.createColor(fgStore, "linkedPositionColor", display);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void setFinalCaretOffset(int offset) {
        this.fFinalCaretOffset = offset;
    }

    public void setCancelListener(ExitListener listener) {
        this.fExitListener = listener;
    }

    public void setCurrentPosition(Position position, int caretOffset) {
        if (!this.fFramePosition.equals((Object)position)) {
            this.redrawRegion();
            this.fFramePosition = position;
        }
        this.fCaretOffset = caretOffset;
    }

    public void enter() {
        IDocument document = this.fViewer.getDocument();
        document.addPositionCategory(CARET_POSITION);
        document.addPositionUpdater(fgUpdater);
        try {
            if (this.fFinalCaretOffset != -1) {
                document.addPosition(CARET_POSITION, new Position(this.fFinalCaretOffset));
            }
        }
        catch (BadLocationException e) {
            LinkedPositionUI.openErrorDialog(this.fViewer.getTextWidget().getShell(), (Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            CUIPlugin.log(e);
            Assert.isTrue((boolean)false);
        }
        this.fViewer.addTextInputListener((ITextInputListener)this);
        ITextViewerExtension extension = (ITextViewerExtension)this.fViewer;
        extension.prependVerifyKeyListener((VerifyKeyListener)this);
        StyledText text = this.fViewer.getTextWidget();
        text.addVerifyListener((VerifyListener)this);
        text.addModifyListener((ModifyListener)this);
        text.addPaintListener((PaintListener)this);
        text.showSelection();
        this.fFramePosition = this.fManager.getFirstPosition();
        if (this.fFramePosition == null) {
            this.leave(11);
        }
        fgStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void exit(boolean success) {
        this.leave((success ? 2 : 0) | 8);
    }

    public IRegion getSelectedRegion() {
        if (this.fFramePosition == null) {
            return new Region(this.fFinalCaretOffset, 0);
        }
        return new Region(this.fFramePosition.getOffset(), this.fFramePosition.getLength());
    }

    private void leave(int flags) {
        if ((flags & 1) != 0) {
            this.fManager.uninstall((flags & 2) != 0);
        }
        fgStore.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fFrameColor != null) {
            this.fFrameColor.dispose();
            this.fFrameColor = null;
        }
        StyledText text = this.fViewer.getTextWidget();
        text.removePaintListener((PaintListener)this);
        text.removeModifyListener((ModifyListener)this);
        text.removeVerifyListener((VerifyListener)this);
        ITextViewerExtension extension = (ITextViewerExtension)this.fViewer;
        extension.removeVerifyKeyListener((VerifyKeyListener)this);
        this.fViewer.removeTextInputListener((ITextInputListener)this);
        try {
            int offset;
            Position[] positions;
            IRegion region = this.fViewer.getVisibleRegion();
            IDocument document = this.fViewer.getDocument();
            if ((flags & 2) != 0 && (flags & 4) == 0 && (flags & 8) != 0 && (positions = document.getPositions(CARET_POSITION)) != null && positions.length != 0 && (offset = positions[0].getOffset() - region.getOffset()) >= 0 && offset <= region.getLength()) {
                text.setSelection(offset, offset);
            }
            document.removePositionUpdater(fgUpdater);
            document.removePositionCategory(CARET_POSITION);
            if (this.fExitListener != null) {
                this.fExitListener.exit((flags & 2) != 0 || (flags & 4) != 0);
            }
        }
        catch (BadPositionCategoryException e) {
            CUIPlugin.log(e);
            Assert.isTrue((boolean)false);
        }
        if ((flags & 4) == 0) {
            text.redraw();
        }
    }

    private void next() {
        this.redrawRegion();
        this.fFramePosition = this.fManager.getNextPosition(this.fFramePosition.getOffset());
        if (this.fFramePosition == null) {
            this.leave(11);
        } else {
            this.selectRegion();
            this.redrawRegion();
        }
    }

    private void previous() {
        this.redrawRegion();
        Position position = this.fManager.getPreviousPosition(this.fFramePosition.getOffset());
        if (position == null) {
            this.fViewer.getTextWidget().getDisplay().beep();
        } else {
            this.fFramePosition = position;
            this.selectRegion();
            this.redrawRegion();
        }
    }

    public void verifyKey(VerifyEvent event) {
        switch (event.character) {
            case '\t': {
                Point selection = this.fViewer.getTextWidget().getSelection();
                IRegion region = this.fViewer.getVisibleRegion();
                int offset = selection.x + region.getOffset();
                int length = selection.y - selection.x;
                if (!LinkedPositionManager.includes(this.fFramePosition, offset, length)) {
                    this.leave(11);
                    return;
                }
                if (event.stateMask == 131072) {
                    this.previous();
                } else {
                    this.next();
                }
                event.doit = false;
                break;
            }
            case '\r': {
                this.leave(11);
                event.doit = false;
                break;
            }
            case '\u001b': {
                this.leave(3);
                event.doit = false;
            }
        }
    }

    public void verifyText(VerifyEvent event) {
        int length;
        if (!event.doit) {
            return;
        }
        IRegion region = this.fViewer.getVisibleRegion();
        int offset = event.start + region.getOffset();
        if (!this.fManager.anyPositionIncludes(offset, length = event.end - event.start)) {
            this.leave(3);
        }
    }

    public void paintControl(PaintEvent event) {
        if (this.fFramePosition == null) {
            return;
        }
        IRegion region = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(region, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int offset = this.fFramePosition.getOffset() - region.getOffset();
        int length = this.fFramePosition.getLength();
        StyledText text = this.fViewer.getTextWidget();
        Point minLocation = LinkedPositionUI.getMinimumLocation(text, offset, length);
        Point maxLocation = LinkedPositionUI.getMaximumLocation(text, offset, length);
        int x1 = minLocation.x;
        int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
        int y = minLocation.y + text.getLineHeight() - 1;
        GC gc = event.gc;
        gc.setForeground(this.fFrameColor);
        gc.drawLine(x1, y, x2, y);
    }

    private static Point getMinimumLocation(StyledText text, int offset, int length) {
        Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x < minLocation.x) {
                minLocation.x = location.x;
            }
            if (location.y < minLocation.y) {
                minLocation.y = location.y;
            }
            ++i;
        }
        return minLocation;
    }

    private static Point getMaximumLocation(StyledText text, int offset, int length) {
        Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x > maxLocation.x) {
                maxLocation.x = location.x;
            }
            if (location.y > maxLocation.y) {
                maxLocation.y = location.y;
            }
            ++i;
        }
        return maxLocation;
    }

    private void redrawRegion() {
        IRegion region = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(region, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int offset = this.fFramePosition.getOffset() - region.getOffset();
        int length = this.fFramePosition.getLength();
        this.fViewer.getTextWidget().redrawRange(offset, length, true);
    }

    private void selectRegion() {
        IRegion region = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(region, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int start = this.fFramePosition.getOffset() - region.getOffset();
        int end = this.fFramePosition.getLength() + start;
        this.fViewer.getTextWidget().setSelection(start, end);
    }

    private void updateCaret() {
        IRegion region = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(region, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int offset = this.fFramePosition.getOffset() + this.fCaretOffset - region.getOffset();
        if (offset >= 0 && offset <= region.getLength()) {
            this.fViewer.getTextWidget().setCaretOffset(offset);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.redrawRegion();
        this.updateCaret();
    }

    private static void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)LinkedPositionMessages.getString("LinkedPositionUI.error.title"), (String)e.getMessage());
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        int flags = 3 | (oldInput.equals(newInput) ? 0 : 4);
        this.leave(flags);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
    }

    private static boolean includes(IRegion region, Position position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    public static interface ExitListener {
        public void exit(boolean var1);
    }
}

