/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.CProjectWizardPage;
import org.eclipse.cdt.ui.wizards.IWizardTab;
import org.eclipse.cdt.ui.wizards.TabFolderPage;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class CProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private static final String OP_ERROR = "CProjectWizard.op_error";
    private static final String OP_DESC = "CProjectWizard.op_description";
    private static final String PREFIX = "CProjectWizard";
    private static final String WZ_TITLE = "CProjectWizard.title";
    private static final String WZ_DESC = "CProjectWizard.description";
    private static final String WINDOW_TITLE = "CProjectWizard.windowTitle";
    private String wz_title;
    private String wz_desc;
    private String op_error;
    protected IConfigurationElement fConfigElement;
    protected CProjectWizardPage fMainPage;
    protected TabFolderPage fTabFolderPage;
    protected IProject newProject;
    List tabItemsList = new ArrayList();

    public CProjectWizard() {
        this(CUIPlugin.getResourceString(WZ_TITLE), CUIPlugin.getResourceString(WZ_DESC), CUIPlugin.getResourceString(OP_ERROR));
    }

    public CProjectWizard(String title, String description) {
        this(title, description, CUIPlugin.getResourceString(OP_ERROR));
    }

    public CProjectWizard(String title, String description, String error) {
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.wz_title = title;
        this.wz_desc = description;
        this.op_error = error;
    }

    public void addPages() {
        this.fMainPage = new CProjectWizardPage(this, CUIPlugin.getResourceString(PREFIX));
        this.fMainPage.setTitle(this.wz_title);
        this.fMainPage.setDescription(this.wz_desc);
        this.addPage((IWizardPage)this.fMainPage);
        this.fTabFolderPage = new TabFolderPage(this);
        this.addPage((IWizardPage)this.fTabFolderPage);
    }

    public void addTabItem(IWizardTab item) {
        this.tabItemsList.add(item);
    }

    public IWizardTab[] getTabItems() {
        return this.tabItemsList.toArray(new IWizardTab[0]);
    }

    public abstract void addTabItems(TabFolder var1);

    protected abstract void doRunPrologue(IProgressMonitor var1);

    protected abstract void doRunEpilogue(IProgressMonitor var1);

    protected IStatus isValidName(String name) {
        return new Status(0, "org.eclipse.cdt.ui", 0, "", null);
    }

    protected IStatus isValidLocation(String projectFieldContents) {
        return new Status(0, "org.eclipse.cdt.ui", 0, "", null);
    }

    protected IPath getLocationPath() throws UnsupportedOperationException {
        if (null == this.fMainPage) {
            throw new UnsupportedOperationException();
        }
        return this.fMainPage.getLocationPath();
    }

    protected IProject getProjectHandle() throws UnsupportedOperationException {
        if (null == this.fMainPage) {
            throw new UnsupportedOperationException();
        }
        return this.fMainPage.getProjectHandle();
    }

    protected IProject getNewProject() {
        return this.newProject;
    }

    protected IResource getSelectedResource() {
        return this.getNewProject();
    }

    protected IValidation getValidation() {
        return this.fTabFolderPage;
    }

    public boolean performFinish() {
        if (!this.invokeRunnable(this.getRunnable())) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        IResource resource = this.getSelectedResource();
        this.selectAndReveal(resource);
        if (resource != null && resource.getType() == 1) {
            IFile file = (IFile)resource;
            IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
            if (dw != null) {
                try {
                    IWorkbenchPage page = dw.getActivePage();
                    if (page != null) {
                        page.openEditor(file);
                    }
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)dw.getShell(), (String)CUIPlugin.getResourceString(OP_ERROR), (String)e.getMessage());
                }
            }
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(CPluginImages.DESC_WIZABAN_NEW_PROJ);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(CUIPlugin.getResourceString(WINDOW_TITLE));
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(CUIPlugin.getResourceString(CProjectWizard.OP_DESC), 3);
                CProjectWizard.this.doRunPrologue((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                try {
                    CProjectWizard.this.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                CProjectWizard.this.doRunEpilogue((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.done();
            }
        };
    }

    protected boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            IStatus status;
            Shell shell = this.getShell();
            String title = CUIPlugin.getResourceString("CProjectWizard.op_error.title");
            String message = CUIPlugin.getResourceString("CProjectWizard.op_error.message");
            Throwable th = e.getTargetException();
            if (th instanceof CoreException && (status = ((CoreException)th).getStatus()) != null) {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
                CUIPlugin.log(status);
                return false;
            }
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
            CUIPlugin.log(th);
            try {
                this.getProjectHandle().delete(false, false, null);
            }
            catch (CoreException ignore) {
            }
            catch (UnsupportedOperationException ignore) {
                // empty catch block
            }
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        this.createNewProject(monitor);
    }

    protected IProject createNewProject(IProgressMonitor monitor) throws CoreException {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = null;
        try {
            newProjectHandle = this.getProjectHandle();
        }
        catch (UnsupportedOperationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, e.getMessage(), null));
        }
        IPath defaultPath = Platform.getLocation();
        IPath newPath = this.getLocationPath();
        if (defaultPath.equals((Object)newPath)) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        this.newProject = CCorePlugin.getDefault().createCProject(description, newProjectHandle, monitor, this.getProjectID());
        return this.newProject;
    }

    public abstract String getProjectID();
}

