/*
 * (c) Copyright QNX Software Systems Ltd. 2002.
 * All Rights Reserved.
 */

package org.eclipse.cdt.debug.mi.core.output;

/**
 * base Abstract class for the OOB stream MI responses. 
 */
public abstract class MIAsyncRecord extends MIOOBRecord {

	final static MIResult[] nullResults = new MIResult[0];

	MIResult[] results = null;
	String asynClass = "";
	int token = 0;

	public int getToken() {
		return token;
	}

	public void setToken(int t) {
		token = t;
	}

	public String getAsyncClass() {
		return asynClass;
	}

	public void setAsyncClass(String a) {
		asynClass = a;
	}

	public MIResult[] getMIResults() {
		if (results == null) {
			return nullResults;
		}
		return results;
	}

	public void setMIResults(MIResult[] res) {
		results = res;
	}

	public String toString() {
		StringBuffer buffer = new StringBuffer();
		if (token != 0) {
			buffer.append(token);
		}
		if (this instanceof MIExecAsyncOutput) {
			buffer.append('*');
		} else if (this instanceof MIStatusAsyncOutput) {
			buffer.append('+');
		} else if (this instanceof MINotifyAsyncOutput) {
			buffer.append('=');
		}
		buffer.append(asynClass);
		if (results != null) {
			for (int i = 0; i < results.length; i++) {
				buffer.append(',');
				buffer.append(results.toString());
			}
		}
		buffer.append('\n');
		return buffer.toString();
	}
}
