/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SharedLibrariesViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache = new HashMap(10);
    private IDebugExceptionHandler fExceptionHandler = null;

    public Object[] getChildren(Object parent) {
        Object[] children = null;
        if (parent != null && parent instanceof ICSharedLibraryManager) {
            children = ((ICSharedLibraryManager)parent).getSharedLibraries();
        }
        if (children != null) {
            this.cache(parent, children);
            return children;
        }
        return new Object[0];
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            this.fParentCache.put(children[i], parent);
            ++i;
        }
    }

    public Object getParent(Object element) {
        return this.fParentCache.get(element);
    }

    public boolean hasChildren(Object parent) {
        if (parent != null && parent instanceof ICSharedLibraryManager) {
            return ((ICSharedLibraryManager)parent).getSharedLibraries().length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.fParentCache != null) {
            int i = 0;
            while (i < children.length) {
                this.fParentCache.remove(children[i]);
                ++i;
            }
        }
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }
}

