/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceLookupBlock {
    private Composite fControl = null;
    private Shell fShell = null;
    private ListDialogField fSourceListField;

    public SourceLookupBlock() {
        String[] buttonLabels = new String[]{"Add...", null, "Up", "Down", null, "Remove"};
        SourceLookupAdapter adapter = new SourceLookupAdapter();
        this.fSourceListField = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new SourceLookupLabelProvider());
        this.fSourceListField.setLabelText("Source Locations");
        this.fSourceListField.setUpButtonIndex(2);
        this.fSourceListField.setDownButtonIndex(3);
        this.fSourceListField.setRemoveButtonIndex(5);
    }

    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        this.fControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fControl.setLayout((Layout)layout);
        this.fControl.setLayoutData((Object)new GridData(1808));
        this.fControl.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)this.fControl);
        this.fSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fSourceListField.getLabelControl(null), converter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fSourceListField.getListControl(null));
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void initialize(ICSourceLocation[] locations) {
        this.fSourceListField.removeAllElements();
        int i = 0;
        while (i < locations.length) {
            this.fSourceListField.addElement(locations[i]);
            ++i;
        }
    }

    protected void doButtonPressed(int index) {
        switch (index) {
            case 0: {
                this.addSourceLocation();
            }
        }
    }

    protected void doSelectionChanged() {
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceListField.getElements().toArray(new ICSourceLocation[this.fSourceListField.getElements().size()]);
    }

    private void addSourceLocation() {
        AddSourceLocationWizard wizard = new AddSourceLocationWizard(this.getSourceLocations());
        WizardDialog dialog = new WizardDialog(this.fControl.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.fSourceListField.addElement(wizard.getSourceLocation());
        }
    }

    private static class SourceLookupLabelProvider
    extends LabelProvider {
        private SourceLookupLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IProjectSourceLocation) {
                return ((IProjectSourceLocation)element).getProject().getName();
            }
            if (element instanceof IDirectorySourceLocation) {
                return ((IDirectorySourceLocation)element).getDirectory().toOSString();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof IProjectSourceLocation) {
                return CDebugImages.get("org.eclipse.cdt.debug.ui.project_obj.gif");
            }
            if (element instanceof IDirectorySourceLocation) {
                return CDebugImages.get("org.eclipse.cdt.debug.ui.folder_obj.gif");
            }
            return null;
        }
    }

    private class SourceLookupAdapter
    implements IListAdapter {
        private SourceLookupAdapter() {
        }

        public void customButtonPressed(DialogField field, int index) {
            SourceLookupBlock.this.doButtonPressed(index);
        }

        public void selectionChanged(DialogField field) {
            SourceLookupBlock.this.doSelectionChanged();
        }
    }
}

