/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CValue;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public abstract class CVariable
extends CDebugElement
implements ICVariable,
ICDIEventListener {
    private CDebugElement fParent;
    private ICDIVariable fCDIVariable;
    protected ICValue fValue;
    private int fLastChangeIndex = -1;
    protected boolean fChanged = false;
    private String fTypeName = null;
    private int fFormat = 0;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IVariable;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$ICVariable;

    public CVariable(CDebugElement parent, ICDIVariable cdiVariable) {
        super((CDebugTarget)parent.getDebugTarget());
        this.fParent = parent;
        this.fCDIVariable = cdiVariable;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public IValue getValue() throws DebugException {
        if (this.fValue == null) {
            this.fValue = CValueFactory.createValue(this, this.getCurrentValue());
        }
        return this.fValue;
    }

    public boolean hasValueChanged() throws DebugException {
        IValue value = this.getValue();
        if (value != null) {
            if (value instanceof CValue && ((CValue)this.getValue()).getType() == 4) {
                return false;
            }
            return value.hasVariables() ? false : this.fChanged;
        }
        return false;
    }

    public void setValue(String expression) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public void setValue(IValue value) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$debug$core$model$IVariable == null ? (class$org$eclipse$debug$core$model$IVariable = CVariable.class$("org.eclipse.debug.core.model.IVariable")) : class$org$eclipse$debug$core$model$IVariable)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$ICVariable == null ? (class$org$eclipse$cdt$debug$core$model$ICVariable = CVariable.class$("org.eclipse.cdt.debug.core.model.ICVariable")) : class$org$eclipse$cdt$debug$core$model$ICVariable)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected final ICDIValue getCurrentValue() throws DebugException {
        try {
            return this.retrieveValue();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), null);
            return null;
        }
    }

    protected void setChangeCount(int count) {
        this.fLastChangeIndex = count;
    }

    protected int getChangeCount() {
        return this.fLastChangeIndex;
    }

    protected ICDIValue getLastKnownValue() {
        if (this.fValue == null) {
            return null;
        }
        return this.fValue.getUnderlyingValue();
    }

    protected void dispose() {
        if (this.fValue != null) {
            ((CValue)this.fValue).dispose();
        }
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    protected synchronized void setChanged(boolean changed) throws DebugException {
        if (this.getValue() != null && this.getValue() instanceof ICValue) {
            ((ICValue)this.getValue()).setChanged(changed);
            if (!this.getValue().hasVariables() || ((ICValue)this.getValue()).getType() == 4) {
                this.fChanged = changed;
            }
        }
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null) {
            return;
        }
        if (source.getTarget().equals(this.getCDITarget()) && event instanceof ICDIChangedEvent && source instanceof ICDIVariable && source.equals(this.getCDIVariable())) {
            this.handleChangedEvent((ICDIChangedEvent)event);
        }
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
        try {
            this.setChanged(true);
            if (this.getValue() != null && ((CValue)this.getValue()).getType() == 8 && this.getParent() instanceof CValue) {
                this.updateParentVariable((CValue)this.getParent());
            }
            this.getParent().fireChangeEvent(512);
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
    }

    protected CDebugElement getParent() {
        return this.fParent;
    }

    protected ICDIVariable getCDIVariable() {
        return this.fCDIVariable;
    }

    protected void setCDIVariable(ICDIVariable newVar) {
        this.fCDIVariable = newVar;
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return this.getParent().getDebugTarget().isSuspended() ? this.getCDIVariable().getValue() : this.getLastKnownValue();
    }

    public String getName() throws DebugException {
        String name = null;
        try {
            name = this.getCDIVariable().getName();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
        return name;
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.fTypeName == null) {
            try {
                this.fTypeName = this.getCDIVariable().getTypeName();
            }
            catch (CDIException e) {
                this.targetRequestFailed(e.getMessage(), null);
            }
        }
        return this.fTypeName;
    }

    protected void updateParentVariable(CValue parentValue) throws DebugException {
        parentValue.getParentVariable().setChanged(true);
        parentValue.getParentVariable().fireChangeEvent(256);
    }

    public int getFormat() {
        return this.fFormat;
    }

    public void setFormat(int format) throws DebugException {
        try {
            this.getCDIVariable().setFormat(format);
            this.fFormat = format;
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void refresh() throws DebugException {
        ((ICValue)this.getValue()).setChanged(true);
        this.fireChangeEvent(256);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

