/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.core.CDescriptor;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.InternalCExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class CDescriptorManager
implements IResourceChangeListener {
    private static HashMap fDescriptorMap;

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void shutdown() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void startup() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (fDescriptorMap == null) {
            return;
        }
        IResource resource = event.getResource();
        Object source = event.getSource();
        int eventType = event.getType();
        switch (eventType) {
            case 4: {
                if (resource.getType() != 4) break;
                fDescriptorMap.remove(resource);
                break;
            }
            case 1: {
                IFile file;
                IResource dResource;
                IResourceDelta delta = event.getDelta();
                if (delta == null || !((dResource = delta.getResource()) instanceof IFile) || (file = (IFile)dResource) == null || !file.getName().endsWith(".cdtproject") || file.exists() || fDescriptorMap == null) break;
                fDescriptorMap.remove(resource);
            }
        }
    }

    public synchronized ICDescriptor getDescriptor(IProject project) throws CoreException {
        CDescriptor cproject;
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        if ((cproject = (CDescriptor)fDescriptorMap.get(project)) == null) {
            cproject = new CDescriptor(project);
            fDescriptorMap.put(project, cproject);
        }
        return cproject;
    }

    public synchronized void configure(IProject project, String id) throws CoreException {
        CDescriptor cproject2;
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        if (fDescriptorMap.get(project) != null) {
            Status status = new Status(4, "org.eclipse.cdt.core", 1, "CDTProject already configured", (Throwable)null);
            throw new CoreException((IStatus)status);
        }
        try {
            cproject2 = new CDescriptor(project, id);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status.getCode() == 1) {
                CDescriptor cproject2 = new CDescriptor(project);
                fDescriptorMap.put(project, cproject2);
                return;
            }
            throw e;
        }
        COwner cowner = new COwner(id);
        cowner.configure(project, cproject2);
        cproject2.saveInfo();
        fDescriptorMap.put(project, cproject2);
    }

    public ICExtension[] createExtensions(String extensionID, IProject project) throws CoreException {
        ArrayList<InternalCExtension> extensionList = new ArrayList<InternalCExtension>(1);
        ICDescriptor cDescriptor = this.getDescriptor(project);
        ICExtensionReference[] ext = cDescriptor.get(extensionID, true);
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        int i = 0;
        while (i < ext.length) {
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(ext[i].getExtension());
            IExtension extension = extensionPoint.getExtension(ext[i].getID());
            IConfigurationElement[] element = extension.getConfigurationElements();
            int j = 0;
            while (j < element.length) {
                if (element[j].getName().equalsIgnoreCase("run")) {
                    InternalCExtension cExtension = (InternalCExtension)element[i].createExecutableExtension("class");
                    cExtension.setExtenionReference(ext[i]);
                    cExtension.setProject(project);
                    extensionList.add(cExtension);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return extensionList.toArray(new ICExtension[extensionList.size()]);
    }

    public static void removeExistingCdtProjectFile(IProject project) {
        IFile file = project.getFile(".cdtproject");
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (file != null && file.exists()) {
            try {
                file.delete(true, (IProgressMonitor)monitor);
                if (fDescriptorMap != null) {
                    fDescriptorMap.remove(project);
                }
                project.refreshLocal(1, (IProgressMonitor)monitor);
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        }
    }
}

