/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICResource;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.core.resources.IResourceDelta;

public class CElementDelta
implements ICElementDelta {
    protected ICElement fChangedElement;
    private int fKind = 0;
    private int fChangeFlags = 0;
    protected ICElement fMovedFromHandle = null;
    protected ICElement fMovedToHandle = null;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected static ICElementDelta[] fgEmptyDelta = new ICElementDelta[0];
    protected ICElementDelta[] fAffectedChildren = fgEmptyDelta;

    public CElementDelta(ICElement element) {
        this.fChangedElement = element;
    }

    protected void addAffectedChild(CElementDelta child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 8;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 8;
            }
        }
        if (!(this.fChangedElement instanceof ICResource)) {
            this.fineGrained();
        }
        if (this.fAffectedChildren.length == 0) {
            this.fAffectedChildren = new ICElementDelta[]{child};
            return;
        }
        ICElementDelta existingChild = null;
        int existingChildIndex = -1;
        int i = 0;
        while (i < this.fAffectedChildren.length) {
            if (this.equalsAndSameParent(this.fAffectedChildren[i].getElement(), child.getElement())) {
                existingChild = this.fAffectedChildren[i];
                existingChildIndex = i;
                break;
            }
            ++i;
        }
        if (existingChild == null) {
            this.fAffectedChildren = this.growAndAddToArray(this.fAffectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.fKind = 4;
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            ICElementDelta[] children = child.getAffectedChildren();
                            int i2 = 0;
                            while (i2 < children.length) {
                                CElementDelta childsChild = (CElementDelta)children[i2];
                                ((CElementDelta)existingChild).addAffectedChild(childsChild);
                                ++i2;
                            }
                            IResourceDelta[] resDeltas = child.getResourceDeltas();
                            if (resDeltas != null) {
                                ((CElementDelta)existingChild).resourceDeltas = resDeltas;
                                ((CElementDelta)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.fAffectedChildren[existingChildIndex] = child;
                    child.fChangeFlags |= flags;
                }
            }
        }
    }

    public void added(ICElement element) {
        CElementDelta addedDelta = new CElementDelta(element);
        addedDelta.fKind = 1;
        this.insertDeltaTree(element, addedDelta);
        if (element instanceof IArchive) {
            CProject cproj = (CProject)element.getCProject();
            ArchiveContainer container = (ArchiveContainer)cproj.getArchiveContainer();
            container.addChild(element);
        } else if (element instanceof IBinary && (((IBinary)element).isExecutable() || ((IBinary)element).isSharedLib())) {
            CProject cproj = (CProject)element.getCProject();
            BinaryContainer container = (BinaryContainer)cproj.getBinaryContainer();
            container.addChild(element);
        }
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 1;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    public void changed(ICElement element, int changeFlag) {
        CElementDelta changedDelta = new CElementDelta(element);
        changedDelta.fKind = 4;
        changedDelta.fChangeFlags |= changeFlag;
        this.insertDeltaTree(element, changedDelta);
    }

    public void closed(ICElement element) {
        CElementDelta delta = new CElementDelta(element);
        delta.fKind = 4;
        delta.fChangeFlags |= 0x400;
        this.insertDeltaTree(element, delta);
    }

    protected boolean equalsAndSameParent(ICElement e1, ICElement e2) {
        ICElement parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    protected CElementDelta createDeltaTree(ICElement element, CElementDelta delta) {
        CElementDelta childDelta = delta;
        ArrayList ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.fKind = delta.fKind;
                this.fChangeFlags = delta.fChangeFlags;
                this.fMovedToHandle = delta.fMovedToHandle;
                this.fMovedFromHandle = delta.fMovedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                ICElement ancestor = (ICElement)ancestors.get(i);
                CElementDelta ancestorDelta = new CElementDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    protected CElementDelta find(ICElement e) {
        if (this.equalsAndSameParent(this.fChangedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.fAffectedChildren.length) {
            CElementDelta delta = ((CElementDelta)this.fAffectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public void fineGrained() {
        this.fChangeFlags |= 0x4000;
    }

    public ICElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    public ICElementDelta[] getAffectedChildren() {
        return this.fAffectedChildren;
    }

    private ArrayList getAncestors(ICElement element) {
        ICElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<ICElement> parents = new ArrayList<ICElement>();
        while (!parent.equals(this.fChangedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    public ICElementDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    protected ICElementDelta[] getChildrenOfType(int type) {
        int length = this.fAffectedChildren.length;
        if (length == 0) {
            return new ICElementDelta[0];
        }
        ArrayList<ICElementDelta> children = new ArrayList<ICElementDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.fAffectedChildren[i].getKind() == type) {
                children.add(this.fAffectedChildren[i]);
            }
            ++i;
        }
        ICElementDelta[] childrenOfType = new ICElementDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    protected CElementDelta getDeltaFor(ICElement element) {
        if (this.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        if (this.fAffectedChildren.length == 0) {
            return null;
        }
        int childrenCount = this.fAffectedChildren.length;
        int i = 0;
        while (i < childrenCount) {
            CElementDelta delta = (CElementDelta)this.fAffectedChildren[i];
            if (this.equalsAndSameParent(delta.getElement(), element)) {
                return delta;
            }
            if ((delta = delta.getDeltaFor(element)) != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public ICElement getElement() {
        return this.fChangedElement;
    }

    public int getFlags() {
        return this.fChangeFlags;
    }

    public int getKind() {
        return this.fKind;
    }

    public ICElement getMovedFromElement() {
        return this.fMovedFromHandle;
    }

    public ICElement getMovedToElement() {
        return this.fMovedToHandle;
    }

    public ICElementDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected ICElementDelta[] growAndAddToArray(ICElementDelta[] array, ICElementDelta addition) {
        ICElementDelta[] old = array;
        array = new ICElementDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected void insertDeltaTree(ICElement element, CElementDelta delta) {
        CElementDelta childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    public void movedFrom(ICElement movedFromElement, ICElement movedToElement) {
        CElementDelta removedDelta = new CElementDelta(movedFromElement);
        removedDelta.fKind = 2;
        removedDelta.fChangeFlags |= 0x20;
        removedDelta.fMovedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(ICElement movedToElement, ICElement movedFromElement) {
        CElementDelta addedDelta = new CElementDelta(movedToElement);
        addedDelta.fKind = 1;
        addedDelta.fChangeFlags |= 0x10;
        addedDelta.fMovedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    public void opened(ICElement element) {
        CElementDelta delta = new CElementDelta(element);
        delta.fKind = 4;
        delta.fChangeFlags |= 0x200;
        this.insertDeltaTree(element, delta);
    }

    protected void removeAffectedChild(CElementDelta child) {
        int index = -1;
        if (this.fAffectedChildren != null) {
            int i = 0;
            while (i < this.fAffectedChildren.length) {
                if (this.equalsAndSameParent(this.fAffectedChildren[i].getElement(), child.getElement())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, index);
        }
    }

    protected ICElementDelta[] removeAndShrinkArray(ICElementDelta[] old, int index) {
        int rest;
        ICElementDelta[] array = new ICElementDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    public void removed(ICElement element) {
        CElementDelta removedDelta = new CElementDelta(element);
        this.insertDeltaTree(element, removedDelta);
        CElementDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.fKind = 2;
            actualDelta.fChangeFlags = 0;
            actualDelta.fAffectedChildren = fgEmptyDelta;
        }
    }

    public void binaryParserChanged(ICElement element) {
        CElementDelta attachedDelta = new CElementDelta(element);
        attachedDelta.fKind = 4;
        attachedDelta.fChangeFlags |= 0x800;
        this.insertDeltaTree(element, attachedDelta);
    }

    public void sourceAttached(ICElement element) {
        CElementDelta attachedDelta = new CElementDelta(element);
        attachedDelta.fKind = 4;
        attachedDelta.fChangeFlags |= 0x1000;
        this.insertDeltaTree(element, attachedDelta);
    }

    public void sourceDetached(ICElement element) {
        CElementDelta detachedDelta = new CElementDelta(element);
        detachedDelta.fKind = 4;
        detachedDelta.fChangeFlags |= 0x2000;
        this.insertDeltaTree(element, detachedDelta);
    }

    public String toDebugString(int depth) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((CElement)this.getElement()).toDebugString());
        buffer.append(" [");
        switch (this.getKind()) {
            case 1: {
                buffer.append('+');
                break;
            }
            case 2: {
                buffer.append('-');
                break;
            }
            case 4: {
                buffer.append('*');
                break;
            }
            default: {
                buffer.append('?');
            }
        }
        buffer.append("]: {");
        int changeFlags = this.getFlags();
        boolean prev = false;
        if ((changeFlags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((changeFlags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((changeFlags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            prev = true;
        }
        if ((changeFlags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            prev = true;
        }
        if ((changeFlags & 2) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MODIFIERS CHANGED");
            prev = true;
        }
        if ((changeFlags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        buffer.append("}");
        ICElementDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((CElementDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.toDebugString(0);
    }
}

