/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICatchEvent;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDICatchpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIBreakAfter;
import org.eclipse.cdt.debug.mi.core.command.MIBreakCondition;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDelete;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDisable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakEnable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakInsert;
import org.eclipse.cdt.debug.mi.core.command.MIBreakList;
import org.eclipse.cdt.debug.mi.core.command.MIBreakWatch;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakListInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakWatchInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class BreakpointManager
extends SessionObject
implements ICDIBreakpointManager {
    List breakList = Collections.synchronizedList(new ArrayList());
    boolean allowInterrupt = true;
    boolean autoupdate = false;

    public BreakpointManager(Session session) {
        super(session);
    }

    public MIBreakpoint[] getMIBreakpoints() throws CDIException {
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakList breakpointList = factory.createMIBreakList();
        try {
            s.getMISession().postCommand(breakpointList);
            MIBreakListInfo info = breakpointList.getMIBreakListInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.getMIBreakpoints();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    boolean containsBreakpoint(int number) {
        return this.getBreakpoint(number) != null;
    }

    boolean hasBreakpointChanged(MIBreakpoint miBreakpoint) {
        boolean changed = false;
        int no = miBreakpoint.getNumber();
        Breakpoint point = this.getBreakpoint(no);
        if (point != null) {
            MIBreakpoint miBreak = point.getMIBreakpoint();
            changed = miBreak.isEnabled() != miBreakpoint.isEnabled() || !miBreak.getCondition().equals(miBreakpoint.getCondition()) || miBreak.getIgnoreCount() != miBreakpoint.getIgnoreCount();
        }
        return changed;
    }

    public Breakpoint getBreakpoint(int number) {
        Breakpoint[] bkpts = this.listBreakpoints();
        int i = 0;
        while (i < bkpts.length) {
            Breakpoint point;
            MIBreakpoint miBreak;
            if (bkpts[i] instanceof Breakpoint && (miBreak = (point = bkpts[i]).getMIBreakpoint()).getNumber() == number) {
                return point;
            }
            ++i;
        }
        return null;
    }

    Watchpoint getWatchpoint(int number) {
        return (Watchpoint)this.getBreakpoint(number);
    }

    Breakpoint[] listBreakpoints() {
        return this.breakList.toArray(new Breakpoint[0]);
    }

    boolean suspendInferior() throws CDIException {
        Target target;
        boolean shouldRestart = false;
        Session s = (Session)this.getSession();
        ICDITarget currentTarget = s.getCurrentTarget();
        if (currentTarget instanceof Target && (target = (Target)currentTarget).isRunning() && this.allowInterrupt) {
            int lastToken = target.getLastExecutionToken();
            shouldRestart = true;
            ((EventManager)s.getEventManager()).disableEventToken(lastToken);
            target.suspend();
            ((EventManager)s.getEventManager()).enableEventToken(lastToken);
        }
        return shouldRestart;
    }

    void resumeInferior(boolean shouldRestart) throws CDIException {
        if (shouldRestart) {
            Session s = (Session)this.getSession();
            ICDITarget target = s.getCurrentTarget();
            target.resume();
        }
    }

    public void deleteBreakpoint(int no) {
        Breakpoint[] points = this.listBreakpoints();
        int i = 0;
        while (i < points.length) {
            if (points[i].getMIBreakpoint().getNumber() == no) {
                this.breakList.remove(points[i]);
                break;
            }
            ++i;
        }
    }

    public void enableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        boolean state = this.suspendInferior();
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakEnable breakEnable = factory.createMIBreakEnable(new int[]{number});
        try {
            try {
                s.getMISession().postCommand(breakEnable);
                MIInfo info = breakEnable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var9_9 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        ((Breakpoint)breakpoint).getMIBreakpoint().setEnabled(true);
        MISession mi = s.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    public void disableBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        boolean state = this.suspendInferior();
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakDisable breakDisable = factory.createMIBreakDisable(new int[]{number});
        try {
            try {
                s.getMISession().postCommand(breakDisable);
                MIInfo info = breakDisable.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var9_9 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        ((Breakpoint)breakpoint).getMIBreakpoint().setEnabled(false);
        MISession mi = s.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    public void setCondition(ICDIBreakpoint breakpoint, ICDICondition condition) throws CDIException {
        int ignoreCount;
        int number = 0;
        if (!(breakpoint instanceof Breakpoint) || !this.breakList.contains(breakpoint)) {
            throw new CDIException("Not a CDT breakpoint");
        }
        number = ((Breakpoint)breakpoint).getMIBreakpoint().getNumber();
        boolean state = this.suspendInferior();
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        String exprCond = condition.getExpression();
        if (exprCond == null) {
            exprCond = "";
        }
        if ((ignoreCount = condition.getIgnoreCount()) < 0) {
            ignoreCount = 0;
        }
        try {
            try {
                MIBreakCondition breakCondition = factory.createMIBreakCondition(number, exprCond);
                s.getMISession().postCommand(breakCondition);
                MIInfo info = breakCondition.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                MIBreakAfter breakAfter = factory.createMIBreakAfter(number, ignoreCount);
                s.getMISession().postCommand(breakAfter);
                info = breakAfter.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var13_13 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        MISession mi = s.getMISession();
        mi.fireEvent(new MIBreakpointChangedEvent(((Breakpoint)breakpoint).getMIBreakpoint().getNumber()));
    }

    public void update() throws CDIException {
        MIBreakpoint[] newMIBreakpoints = this.getMIBreakpoints();
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(newMIBreakpoints.length);
        int i = 0;
        while (i < newMIBreakpoints.length) {
            int no = newMIBreakpoints[i].getNumber();
            if (this.containsBreakpoint(no)) {
                if (this.hasBreakpointChanged(newMIBreakpoints[i])) {
                    eventList.add(new MIBreakpointChangedEvent(no));
                }
            } else {
                if (newMIBreakpoints[i].isWatchpoint()) {
                    this.breakList.add(new Watchpoint(this, newMIBreakpoints[i]));
                } else {
                    this.breakList.add(new Breakpoint(this, newMIBreakpoints[i]));
                }
                eventList.add(new MIBreakpointCreatedEvent(no));
            }
            ++i;
        }
        Breakpoint[] oldBreakpoints = this.listBreakpoints();
        int i2 = 0;
        while (i2 < oldBreakpoints.length) {
            boolean found = false;
            int no = oldBreakpoints[i2].getMIBreakpoint().getNumber();
            int j = 0;
            while (j < newMIBreakpoints.length) {
                if (no == newMIBreakpoints[j].getNumber()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                eventList.add(new MIBreakpointDeletedEvent(no));
            }
            ++i2;
        }
        MISession mi = ((Session)this.getSession()).getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public void allowProgramInterruption(boolean e) {
        this.allowInterrupt = e;
    }

    public void deleteAllBreakpoints() throws CDIException {
        this.deleteBreakpoints((ICDIBreakpoint[])this.listBreakpoints());
    }

    public void deleteBreakpoint(ICDIBreakpoint breakpoint) throws CDIException {
        this.deleteBreakpoints(new ICDIBreakpoint[]{breakpoint});
    }

    public void deleteBreakpoints(ICDIBreakpoint[] breakpoints) throws CDIException {
        int[] numbers = new int[breakpoints.length];
        int i = 0;
        while (i < numbers.length) {
            if (!(breakpoints[i] instanceof Breakpoint) || !this.breakList.contains(breakpoints[i])) {
                throw new CDIException("Not a CDT breakpoint");
            }
            numbers[i] = ((Breakpoint)breakpoints[i]).getMIBreakpoint().getNumber();
            ++i;
        }
        boolean state = this.suspendInferior();
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakDelete breakDelete = factory.createMIBreakDelete(numbers);
        try {
            try {
                s.getMISession().postCommand(breakDelete);
                MIInfo info = breakDelete.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                Object var10_10 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        ArrayList<MIBreakpointDeletedEvent> eventList = new ArrayList<MIBreakpointDeletedEvent>(breakpoints.length);
        int i2 = 0;
        while (i2 < breakpoints.length) {
            int no = ((Breakpoint)breakpoints[i2]).getMIBreakpoint().getNumber();
            eventList.add(new MIBreakpointDeletedEvent(no));
            ++i2;
        }
        MISession mi = s.getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        this.update();
        return this.breakList.toArray(new ICDIBreakpoint[0]);
    }

    public ICDICatchpoint setCatchpoint(int type, ICDICatchEvent event, String expression, ICDICondition condition) throws CDIException {
        throw new CDIException("Not Supported");
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int type, ICDILocation location, ICDICondition condition, String threadId) throws CDIException {
        boolean hardware = type == 2;
        boolean temporary = type == 1;
        String exprCond = null;
        int ignoreCount = 0;
        StringBuffer line = new StringBuffer();
        if (condition != null) {
            exprCond = condition.getExpression();
            ignoreCount = condition.getIgnoreCount();
        }
        if (location != null) {
            String file = location.getFile();
            String function = location.getFunction();
            if (file != null && file.length() > 0) {
                line.append(file).append(':');
                if (function != null && function.length() > 0) {
                    line.append(function);
                } else {
                    line.append(location.getLineNumber());
                }
            } else if (function != null && function.length() > 0) {
                line.append(function);
            } else if (location.getLineNumber() != 0) {
                line.append(location.getLineNumber());
            } else {
                line.append('*').append(location.getAddress());
            }
        }
        boolean state = this.suspendInferior();
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakInsert breakInsert = factory.createMIBreakInsert(temporary, hardware, exprCond, ignoreCount, line.toString());
        MIBreakpoint[] points = null;
        try {
            try {
                s.getMISession().postCommand(breakInsert);
                MIBreakInsertInfo info = breakInsert.getMIBreakInsertInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                points = info.getMIBreakpoints();
                if (points == null || points.length == 0) {
                    throw new CDIException("Error parsing");
                }
                Object var17_18 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        Breakpoint bkpt = new Breakpoint(this, points[0]);
        this.breakList.add(bkpt);
        MISession mi = s.getMISession();
        mi.fireEvent(new MIBreakpointCreatedEvent(bkpt.getMIBreakpoint().getNumber()));
        return bkpt;
    }

    public ICDIWatchpoint setWatchpoint(int type, int watchType, String expression, ICDICondition condition) throws CDIException {
        boolean access = (watchType & 1) == 1 && (watchType & 2) == 2;
        boolean read = (watchType & 1) != 1 && (watchType & 2) == 2;
        boolean state = this.suspendInferior();
        Session s = (Session)this.getSession();
        CommandFactory factory = s.getMISession().getCommandFactory();
        MIBreakWatch breakWatch = factory.createMIBreakWatch(access, read, expression);
        MIBreakpoint[] points = null;
        try {
            try {
                s.getMISession().postCommand(breakWatch);
                MIBreakWatchInfo info = breakWatch.getMIBreakWatchInfo();
                points = info.getMIBreakpoints();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                if (points == null || points.length == 0) {
                    throw new CDIException("Parsing Error");
                }
                Object var14_14 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.resumeInferior(state);
            throw throwable;
        }
        this.resumeInferior(state);
        Watchpoint bkpt = new Watchpoint(this, points[0]);
        this.breakList.add(bkpt);
        MISession mi = s.getMISession();
        mi.fireEvent(new MIBreakpointCreatedEvent(bkpt.getMIBreakpoint().getNumber()));
        return bkpt;
    }

    public ICDICondition createCondition(int ignoreCount, String expression) {
        return new Condition(ignoreCount, expression);
    }

    public ICDILocation createLocation(String file, String function, int line) {
        return new Location(file, function, line);
    }

    public ICDILocation createLocation(long address) {
        return new Location(address);
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }
}

