/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.IUpdateListener;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.UpdateManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Expression;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;

public class ExpressionManager
extends SessionObject
implements ICDIExpressionManager,
IUpdateListener {
    private List expList = Collections.synchronizedList(new ArrayList());
    private boolean autoupdate = true;

    public ExpressionManager(Session session) {
        super(session);
    }

    private synchronized void addExpression(Expression exp) {
        this.expList.add(exp);
    }

    public ICDIExpression createExpression(String name) throws CDIException {
        Expression expression = null;
        try {
            Session session = (Session)this.getSession();
            ICDITarget currentTarget = session.getCurrentTarget();
            MISession mi = session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarCreate var = factory.createMIVarCreate(name);
            mi.postCommand(var);
            MIVarCreateInfo info = var.getMIVarCreateInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            VariableObject varObj = new VariableObject(currentTarget, name, null, 0, 0);
            expression = new Expression(varObj, info.getMIVar());
            this.addExpression(expression);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return expression;
    }

    public ICDIExpression createExpression(ICDIStackFrame frame, String name) throws CDIException {
        Expression expression = null;
        if (!(frame instanceof StackFrame)) {
            return expression;
        }
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIThread currentThread = currentTarget.getCurrentThread();
        ICDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        frame.getThread().setCurrentStackFrame(frame);
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                ICDITarget target = frame.getThread().getTarget();
                VariableObject varObj = new VariableObject(target, name, (StackFrame)frame, 0, 0);
                expression = new Expression(varObj, info.getMIVar());
                this.addExpression(expression);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            currentThread.setCurrentStackFrame(currentFrame);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame);
        return expression;
    }

    public ICDIExpression[] getExpressions() throws CDIException {
        return this.expList.toArray(new ICDIExpression[0]);
    }

    public synchronized void removeExpression(ICDIExpression expression) throws CDIException {
        this.expList.remove(expression);
    }

    public void destroyExpression(ICDIExpression expression) throws CDIException {
        this.removeExpression(expression);
    }

    public Expression getExpression(String varName) {
        Expression[] exps = this.expList.toArray(new Expression[0]);
        int i = 0;
        while (i < exps.length) {
            if (exps[i].getMIVar().getVarName().equals(varName)) {
                return exps[i];
            }
            ++i;
        }
        return null;
    }

    public void update() throws CDIException {
        Session session = (Session)this.getSession();
        UpdateManager mgr = session.getUpdateManager();
        mgr.update();
    }

    public void changeList(MIVarChange[] changes) {
        ArrayList<MIVarChangedEvent> eventList = new ArrayList<MIVarChangedEvent>(changes.length);
        int i = 0;
        while (i < changes.length) {
            String varName = changes[i].getVarName();
            Expression expression = this.getExpression(varName);
            if (expression != null) {
                eventList.add(new MIVarChangedEvent(0, varName, changes[i].isInScope()));
            }
            ++i;
        }
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }
}

