/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataListChangedRegisters;
import org.eclipse.cdt.debug.mi.core.command.MIDataListRegisterNames;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataListChangedRegistersInfo;
import org.eclipse.cdt.debug.mi.core.output.MIDataListRegisterNamesInfo;

public class RegisterManager
extends SessionObject
implements ICDIRegisterManager {
    private List regList = Collections.synchronizedList(new ArrayList());
    private boolean autoupdate = true;

    public RegisterManager(Session session) {
        super(session);
    }

    public ICDIRegisterObject[] getRegisterObjects() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListRegisterNames registers = factory.createMIDataListRegisterNames();
        try {
            mi.postCommand(registers);
            MIDataListRegisterNamesInfo info = registers.getMIDataListRegisterNamesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            String[] names = info.getRegisterNames();
            ICDIRegisterObject[] regs = new RegisterObject[names.length];
            int i = 0;
            while (i < names.length) {
                regs[i] = new RegisterObject(session.getCurrentTarget(), names[i], i);
                ++i;
            }
            return regs;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIRegister createRegister(ICDIRegisterObject regObject) throws CDIException {
        Register reg = this.getRegister(regObject);
        if (reg == null) {
            Session session = (Session)this.getSession();
            reg = new Register(session.getCurrentTarget(), regObject);
            this.regList.add(reg);
            MISession mi = session.getMISession();
            mi.fireEvent(new MIRegisterCreatedEvent(reg.getName(), reg.getID()));
        }
        return reg;
    }

    public void destroyRegister(ICDIRegister reg) {
        this.regList.remove(reg);
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public Register getRegister(int regno) throws CDIException {
        Register[] regs = this.getRegisters();
        int i = 0;
        while (i < regs.length) {
            if (regs[i].getID() == regno) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }

    public void update() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListChangedRegisters changed = factory.createMIDataListChangedRegisters();
        try {
            mi.postCommand(changed);
            MIDataListChangedRegistersInfo info = changed.getMIDataListChangedRegistersInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            int[] regnos = info.getRegisterNumbers();
            ArrayList<MIRegisterChangedEvent> eventList = new ArrayList<MIRegisterChangedEvent>(regnos.length);
            int i = 0;
            while (i < regnos.length) {
                Register reg = this.getRegister(regnos[i]);
                if (reg != null) {
                    eventList.add(new MIRegisterChangedEvent(changed.getToken(), reg.getName(), regnos[i]));
                }
                ++i;
            }
            MIEvent[] events = eventList.toArray(new MIEvent[0]);
            mi.fireEvents(events);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    private Register[] getRegisters() {
        return this.regList.toArray(new Register[0]);
    }

    private Register getRegister(ICDIRegisterObject regObject) throws CDIException {
        Register[] regs = this.getRegisters();
        int i = 0;
        while (i < regs.length) {
            if (regObject.getName().equals(regs[i].getName())) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }
}

