/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.IUpdateListener;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class UpdateManager {
    Session session;
    List updateList = Collections.synchronizedList(new ArrayList(5));
    MIVarChange[] noChanges = new MIVarChange[0];

    public UpdateManager(Session s) {
        this.session = s;
    }

    public void addUpdateListener(IUpdateListener listener) {
        this.updateList.add(listener);
    }

    public void removeUpdateListener(IUpdateListener listener) {
        this.updateList.remove(listener);
    }

    public void update() throws CDIException {
        MIVarChange[] changes = this.noChanges;
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarUpdate update = factory.createMIVarUpdate();
        try {
            mi.postCommand(update);
            MIVarUpdateInfo info = update.getMIVarUpdateInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            changes = info.getMIVarChanges();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        IUpdateListener[] listeners = this.updateList.toArray(new IUpdateListener[0]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].changeList(changes);
            ++i;
        }
    }
}

